package jp.sourceforge.acerola3d.a3editor;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import java.awt.BorderLayout;
import java.awt.event.*;
import java.net.URL;
import jp.sourceforge.acerola3d.a3panels.*;

class A3EditorGUI extends JFrame implements ActionListener, ChangeListener {
    private static final long serialVersionUID = 1L;
    A3Editor editor;
    JTabbedPane tPane;
    JMenuItem helpMI;
    JMenuItem aboutMI;
    JMenuItem closeMI;
    A3eFileManagerGUI fileManagerGUI;
    A3eActionEditorGUI actionEditorGUI;
    A3eMetadataGUI metadataGUI;
    A3eA3Panel a3eA3Panel;
    CreateA3GUI createA3GUI;
    JFrame htmlFrame;
    HtmlPanel htmlViewer;

    A3EditorGUI(A3Editor e) {
        super("A3Editor");
        editor = e;
        //this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        this.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosing(WindowEvent e) {
                actionEditorGUI.clear();
                metadataGUI.clear();
                System.exit(0);
            }
        });

        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        menuBar.add(Box.createHorizontalGlue());
        JMenu menu = new JMenu("menu");
        menuBar.add(menu);
        helpMI = new JMenuItem("help");
        helpMI.addActionListener(this);
        menu.add(helpMI);
        aboutMI = new JMenuItem("about");
        aboutMI.addActionListener(this);
        menu.add(aboutMI);
        closeMI = new JMenuItem("close");
        closeMI.addActionListener(this);
        menu.add(closeMI);

        tPane = new JTabbedPane();
        tPane.addChangeListener(this);
        this.add(tPane);
        fileManagerGUI = editor.fileManager.getGUI();
        tPane.addTab("ファイルの整理確認",fileManagerGUI);
        actionEditorGUI = editor.actionEditor.getGUI();
        tPane.addTab("アクション編集",actionEditorGUI);
        metadataGUI = editor.catalog.getMetadataGUI();
        tPane.addTab("メタデータ編集",metadataGUI);
        a3eA3Panel = new A3eA3Panel(editor.fileManager);
        tPane.addTab("表示確認",a3eA3Panel);
        createA3GUI = new CreateA3GUI(editor.fileManager);
        tPane.addTab("ファイル生成",createA3GUI);

        htmlFrame = new JFrame();
        htmlFrame.setLayout(new BorderLayout());
        htmlViewer = new HtmlPanel(null);
        htmlFrame.add(htmlViewer,BorderLayout.CENTER);

        this.setSize(1000,700);
        this.setVisible(true);
    }
    public void actionPerformed(ActionEvent e) {
        if (e.getSource()==helpMI) {
            openHelp();
        } else if (e.getSource()==aboutMI) {
            openAbout();
        } else if (e.getSource()==closeMI) {
            actionEditorGUI.clear();
            metadataGUI.clear();
            System.exit(0);
        }
    }
    int currentPane = 0;
    public void stateChanged(ChangeEvent e) {
        if (e.getSource()==tPane) {
            // 0: ファイルの整理確認
            // 1: アクション編集
            // 2: メタデータ編集
            // 3: 表示確認
            // 4: ファイル生成
            int newPane = tPane.getSelectedIndex();
            //System.out.println("oldPane:"+currentPane);
            //System.out.println("newPane:"+newPane);

            if (currentPane==0 && fileManagerGUI!=null) fileManagerGUI.clear();
            if (currentPane==1 && actionEditorGUI!=null) actionEditorGUI.clear();
            if (currentPane==2 && metadataGUI!=null) metadataGUI.clear();
            if (currentPane==3 && a3eA3Panel!=null) a3eA3Panel.clear();
            if (currentPane==4 && createA3GUI!=null) createA3GUI.clear();
            if (newPane==0) {
                fileManagerGUI.init();
            } else if (newPane==1) {
                actionEditorGUI.init();
            } else if (newPane==2) {
                metadataGUI.init();
            } else if (newPane==3) {
                a3eA3Panel.loadAction3D(editor.fileManager.rootDir);
            } else if (newPane==4) {
                createA3GUI.init();
            }
            currentPane = newPane;
        }
    }
    void openHelp() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/a3editor/resources/ja/help.html");
        } catch(Exception e) {
            e.printStackTrace();
        }
        htmlViewer.open(url);
        htmlFrame.setSize(500,500);
        htmlFrame.setVisible(true);
    }
    void openAbout() {
        URL url = null;
        try {
            url = new URL("x-res:///jp/sourceforge/acerola3d/a3editor/resources/ja/about.html");
        } catch(Exception e) {
            e.printStackTrace();
        }
        htmlViewer.open(url);
        htmlFrame.setSize(500,500);
        htmlFrame.setVisible(true);
    }
}
