/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashSet;
import java.util.Locale;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.NanoParser;
import net.morilib.lisp.nano.ReadFileException;
import net.morilib.lisp.nano.Scheme;
import net.morilib.lisp.nano.Symbol;

public final class SchemeOptions {
    private static final int INIT = 1000;
    private static final int EVAL = 1010;
    private static final int EXEC = 1020;
    private static final String REPORT_LOAD_TIME = "--report-load-time";
    private static long loadTime;

    private SchemeOptions() {
    }

    static Locale parseLocale(String s) {
        if (s == null || s.equals("")) {
            return null;
        }
        String[] ls = s.split("(-|\\.|[_,])");
        switch (ls.length) {
            case 1: {
                return new Locale(ls[0].toLowerCase());
            }
            case 2: {
                return new Locale(ls[0].toLowerCase(), ls[1].toUpperCase());
            }
            case 3: {
                return new Locale(ls[0].toLowerCase(), ls[1].toUpperCase(), ls[2].toUpperCase());
            }
        }
        return null;
    }

    public static Scheme preparseOption(String[] args) {
        int opt = 0;
        LinkedHashSet<String> libs = new LinkedHashSet<String>();
        Locale l = null;
        libs.add("core");
        while (opt < args.length) {
            String s;
            if ((s = args[opt++]).equals("-version") || s.equals("--version")) {
                System.out.print("Schluessel, Version ");
                System.out.println("0.4.5");
                System.exit(0);
                continue;
            }
            if (s.equals(REPORT_LOAD_TIME)) {
                loadTime = System.currentTimeMillis();
                continue;
            }
            if (s.equals("--")) break;
        }
        return Scheme.newInstance(l);
    }

    public static int parseOption(String[] args, Scheme eval) {
        int opt = 0;
        int state = 1000;
        boolean end = false;
        try {
            String u = System.getProperty("schluessel.foldcase");
            Symbol.foldCase = Boolean.parseBoolean(u) ? 2 : 0;
        }
        catch (SecurityException securityException) {}
        try {
            while (opt < args.length) {
                String s = args[opt++];
                switch (state) {
                    case 1000: {
                        if (s.equals("-e") || s.equals("--eval")) {
                            state = 1010;
                            break;
                        }
                        if (s.equals("-E") || s.equals("--exec")) {
                            state = 1020;
                            break;
                        }
                        if (s.equals("--fold-case")) {
                            Symbol.foldCase = 2;
                            break;
                        }
                        if (s.equals("--no-fold-case")) {
                            Symbol.foldCase = 0;
                            break;
                        }
                        if (s.equals("--")) {
                            if (end) {
                                System.exit(0);
                            }
                            return opt;
                        }
                        if (s.equals("-")) {
                            if (end) {
                                System.exit(0);
                            }
                            return opt - 1;
                        }
                        if (s.equals(REPORT_LOAD_TIME)) {
                            long endtime = System.currentTimeMillis();
                            System.err.print("Load time: ");
                            System.err.print((double)(endtime - loadTime) / 1000.0);
                            System.err.println(" seconds");
                            break;
                        }
                        System.err.print("Invalid option: ");
                        System.err.println(s);
                        System.exit(2);
                        break;
                    }
                    case 1010: {
                        eval.read(new StringReader(s));
                        end = true;
                        state = 1000;
                        break;
                    }
                    case 1020: {
                        Datum d = NanoParser.exec(s);
                        if (d != null) {
                            System.out.println(LispUtils.toDisplay(d));
                        }
                        end = true;
                        state = 1000;
                    }
                }
            }
        }
        catch (ReadFileException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        if (end) {
            System.exit(0);
        }
        return opt;
    }
}

