/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.LispBoolean;
import net.morilib.lisp.nano.LispCharacter;
import net.morilib.lisp.nano.LispComplex;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispException;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispNumber;
import net.morilib.lisp.nano.LispRational;
import net.morilib.lisp.nano.LispReal;
import net.morilib.lisp.nano.LispString;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.LispVector;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.ReadException;
import net.morilib.lisp.nano.Scheme;
import net.morilib.lisp.nano.Symbol;
import net.morilib.lisp.nano.util.PeekableReader;

public class NanoParser {
    private static final int NINA_ACCEPT = -1;
    private static final int NINA_FAIL = -9;
    private static final int NINA_HALT_ACCEPT = -91;
    private static final int NINA_HALT_REJECT = -72;
    private static final int NINA_BEGIN = -2;
    private static final int NINA_STACKLEN = 72;
    static final int INITIAL = 0;
    private int STATE;
    private int[] __sts = new int[72];
    private Engine[] __stk = new Engine[72];
    private Object[][] __stv = new Object[72][];
    private int __slen = 0;
    Throwable exception;
    private int unread = -1;
    private int[] __backtrack = null;
    private int __backtrack_ptr = -1;
    private int __backtrack_len = -1;
    private int __backtrack_wptr = -1;
    private int __backtrack_sym = -1;
    private int[] __backtrack_state = null;
    private int[] __backtrack_wsym = null;
    private int[] __backtrack_ptrs = null;
    private Continuation[] __backtrack_cont = null;
    private int __backtrack_sptr = -1;
    private boolean __backtrack_flg = false;
    private static final Symbol QUT = Symbol.getSymbol("quote");
    private static final Symbol QQT = Symbol.getSymbol("quasiquote");
    private static final Symbol UQT = Symbol.getSymbol("unquote");
    private static final Symbol UQS = Symbol.getSymbol("unquote-splicing");
    private static final int EXACT = 1;
    private static final int INEXACT = 2;
    private StringBuffer nbf;
    private StringBuffer dbf;
    private StringBuffer fbf;
    private StringBuffer ybf;
    private StringBuffer bbf;
    private StringBuffer obf;
    private StringBuffer zbf;
    private StringBuffer xbf;
    private StringBuffer cbf;
    private Stack<List<Datum>> lst;
    private LispReal real;
    private LispNumber num;
    private Datum dtm;
    private int chr;
    private int exactness;
    Datum res;
    private String prompt1;
    private Scheme scheme;
    private final Engine ENGINE_real = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoParser.this.real_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoParser.this.real_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoParser.this.real_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoParser.this.real_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 10;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "real";
        }
    };
    private final Engine ENGINE_read = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoParser.this.read_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoParser.this.read_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoParser.this.read_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoParser.this.read_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 2;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "read";
        }
    };
    private final Engine ENGINE_number = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoParser.this.number_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoParser.this.number_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoParser.this.number_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoParser.this.number_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 9;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "number";
        }
    };
    private final Engine ENGINE_sexp = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoParser.this.sexp_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoParser.this.sexp_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoParser.this.sexp_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoParser.this.sexp_isend();
        }

        @Override
        int recover(Exception e) {
            return -1;
        }

        @Override
        int deadState() {
            return -1;
        }

        @Override
        int stateSize() {
            return 72;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "sexp";
        }
    };
    private final Engine ENGINE_nanoParser = new Engine(){

        @Override
        int step(Reader __rd, int c) throws IOException {
            return NanoParser.this.nanoParser_step(__rd, c);
        }

        @Override
        boolean accepted() {
            return NanoParser.this.nanoParser_accepted();
        }

        @Override
        int execaction(int c) {
            return NanoParser.this.nanoParser_execaction(c);
        }

        @Override
        boolean isend() {
            return NanoParser.this.nanoParser_isend();
        }

        @Override
        int recover(Exception e) {
            if (e instanceof LispException) {
                return 3;
            }
            return -1;
        }

        @Override
        int deadState() {
            return 2;
        }

        @Override
        int stateSize() {
            return 4;
        }

        @Override
        int finallyState() {
            return -1;
        }

        public String toString() {
            return "nanoParser";
        }
    };

    public NanoParser(Scheme scheme, String prompt1, String prompt2) {
        this.scheme = scheme;
        this.prompt1 = prompt1;
    }

    public NanoParser(Scheme scheme) {
        this.scheme = scheme;
        this.prompt1 = null;
    }

    public NanoParser() {
        this.scheme = Scheme.newInstance();
    }

    public Datum readExpr(PeekableReader p) throws IOException {
        this.parse(p);
        p.unget(this.unread);
        return this.res;
    }

    private void putprompt1() {
        if (this.prompt1 != null) {
            System.out.print(this.prompt1);
        }
    }

    private void putresult(Datum res) {
        if (this.prompt1 != null && this.scheme != null && res != null) {
            System.out.println(this.scheme.input(res));
        } else if (this.scheme != null && res != null) {
            this.scheme.input(res);
        }
    }

    private void init() {
        this.cbf = null;
        this.xbf = null;
        this.zbf = null;
        this.obf = null;
        this.bbf = null;
        this.ybf = null;
        this.chr = -1;
        this.dtm = null;
        this.exactness = 0;
    }

    private void l2d() {
        this.dtm = LispUtils.listToCons((Collection<? extends Datum>)this.lst.pop(), this.get());
    }

    private void adl(int c) {
        if (c == 40) {
            this.lst.push(new ArrayList());
        }
    }

    private void adg(int c) {
        this.lst.peek().add(this.get());
    }

    private LispNumber toExactness(LispNumber n) {
        switch (this.exactness) {
            case 1: {
                return n.toExact();
            }
            case 2: {
                return n.toInexact();
            }
        }
        return n;
    }

    private Datum get() {
        if (this.dtm != null) {
            return this.dtm;
        }
        if (this.ybf != null) {
            String s = this.ybf.toString();
            if (s.equals("+inf.0")) {
                return LispDouble.POSITIVE_INFINITY;
            }
            if (s.equals("-inf.0")) {
                return LispDouble.NEGATIVE_INFINITY;
            }
            if (s.equals("+nan.0")) {
                return LispDouble.NaN;
            }
            return Symbol.getSymbol(s);
        }
        if (this.bbf != null) {
            try {
                LispInteger n = LispInteger.valueOf(new BigInteger(this.bbf.toString(), 2));
                return this.toExactness(n);
            }
            catch (NumberFormatException e) {
                throw LispMessage.getInstance().getError("err.read.number.invalid");
            }
        }
        if (this.obf != null) {
            try {
                LispInteger n = LispInteger.valueOf(new BigInteger(this.obf.toString(), 8));
                return this.toExactness(n);
            }
            catch (NumberFormatException e) {
                throw LispMessage.getInstance().getError("err.read.number.invalid");
            }
        }
        if (this.zbf != null) {
            try {
                LispInteger n = LispInteger.valueOf(new BigInteger(this.zbf.toString(), 10));
                return this.toExactness(n);
            }
            catch (NumberFormatException e) {
                throw LispMessage.getInstance().getError("err.read.number.invalid");
            }
        }
        if (this.xbf != null) {
            try {
                LispInteger n = LispInteger.valueOf(new BigInteger(this.xbf.toString(), 16));
                return this.toExactness(n);
            }
            catch (NumberFormatException e) {
                throw LispMessage.getInstance().getError("err.read.number.invalid");
            }
        }
        if (this.cbf != null) {
            LispCharacter r = LispCharacter.getByName(this.cbf.toString());
            if (r != null) {
                return r;
            }
            throw LispMessage.getInstance().getError("err.read.character.unknown");
        }
        if (this.chr >= 0) {
            return new LispCharacter(this.chr);
        }
        return null;
    }

    private void ay(int c) {
        if (this.ybf == null) {
            this.ybf = new StringBuffer();
        }
        if (c > 0) {
            this.ybf.appendCodePoint(c);
        }
    }

    private void ayn() {
        this.ay(10);
    }

    private void ayq() {
        this.ay(92);
    }

    private void ab(int c) {
        if (this.bbf == null) {
            this.bbf = new StringBuffer();
        }
        this.bbf.appendCodePoint(c);
    }

    private void ao(int c) {
        if (this.obf == null) {
            this.obf = new StringBuffer();
        }
        this.obf.appendCodePoint(c);
    }

    private void az(int c) {
        if (this.zbf == null) {
            this.zbf = new StringBuffer();
        }
        this.zbf.appendCodePoint(c);
    }

    private void ax(int c) {
        if (this.xbf == null) {
            this.xbf = new StringBuffer();
        }
        this.xbf.appendCodePoint(c);
    }

    private void ac(int c) {
        if (this.cbf == null) {
            this.cbf = new StringBuffer();
            this.cbf.appendCodePoint(this.chr);
        }
        this.cbf.appendCodePoint(c);
    }

    private void ib() {
        this.real = LispInteger.ONE;
        this.num = null;
    }

    private void ia() {
        this.nbf = new StringBuffer();
        this.fbf = null;
        this.dbf = null;
    }

    private void an(int c) {
        if (c != 43) {
            this.nbf.append((char)c);
        }
    }

    private void ad(int c) {
        this.dbf.append((char)c);
    }

    private void af(int c) {
        if (this.fbf == null) {
            this.fbf = this.nbf;
        }
        this.fbf.append((char)c);
    }

    private LispReal getr() {
        if (this.dbf != null) {
            return LispRational.newRational(new BigInteger(this.nbf.toString()), new BigInteger(this.dbf.toString()));
        }
        if (this.fbf != null) {
            return new LispDouble(Double.parseDouble(this.fbf.toString()));
        }
        return LispInteger.valueOf(new BigInteger(this.nbf.toString()));
    }

    public static Datum exec(String s) {
        try {
            NanoParser r = new NanoParser(null);
            r.parse(new StringReader(s));
            return r.res;
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    public static Datum read(PeekableReader rd) throws IOException {
        NanoParser r = new NanoParser(null);
        r.parse(rd, r.ENGINE_read);
        if (r.unread >= 0) {
            rd.unget(r.unread);
        }
        return r.res;
    }

    public static void read(Scheme sch, InputStream rd) throws IOException {
        NanoParser r = new NanoParser(sch);
        r.parse(rd);
    }

    public Datum read(String s) {
        try {
            this.parse(new StringReader(s), this.ENGINE_read);
            return this.res;
        }
        catch (TokenException e) {
            throw LispMessage.getInstance().getError("err.read");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void repl(Scheme scheme, PeekableReader rd, LispMessage msg) throws IOException {
        block4: {
            try {
                NanoParser r = new NanoParser(scheme, " >", ">>");
                r.parse(rd);
            }
            catch (ReadException e) {
                System.err.println(String.valueOf(msg.get("err.repl.read")) + e.getMessage());
            }
            catch (LispException e) {
                System.err.println(String.valueOf(msg.get("err.repl.err")) + e.getMessage());
                if (scheme.stackTrace != null && !scheme.stackTrace.equals("")) {
                    System.err.println(msg.get("err.stacktrace"));
                    System.err.print(scheme.stackTrace);
                }
                if (e.getException() == null) break block4;
                e.getException().printStackTrace();
            }
        }
    }

    private int _read(Reader rd) throws IOException {
        int c;
        if (this.__backtrack_sym >= 0) {
            c = this.__backtrack_sym;
            this.__backtrack_sym = -1;
            this.__logprint("Read Backtracking: ", c);
        } else if (this.unread >= 0) {
            c = this.unread;
            this.unread = -1;
            this.__logprint("Read unread: ", c);
        } else if (this.__backtrack_ptr >= 0) {
            if (this.__backtrack_ptr < this.__backtrack_len) {
                c = this.__backtrack[this.__backtrack_ptr++];
            } else {
                this.__backtrack = null;
                this.__backtrack_wptr = -1;
                this.__backtrack_ptr = -1;
                c = this._read(rd);
            }
            this.__logprint("Read Backtracking: ", c);
        } else {
            c = rd.read();
            if (c >= 0) {
                this.__write_backtrack(c);
                this.__logprint("Read: ", c);
            } else {
                this.__logprint("Read end-of-file");
            }
        }
        return c;
    }

    void UNGET(int c) {
        this.unread = c;
        this.__logprint("Set unread: ", c);
    }

    private void __logprint(String s, int c) {
    }

    private void __logopen() {
    }

    private void __logprint(String s) {
    }

    private void __logclose() {
    }

    private void __puttrace() {
    }

    void SET_BACKTRACK(int c) {
        if (this.__backtrack_sym != c) {
            if (this.__backtrack_ptr < 0) {
                this.__backtrack = new int[1024];
                this.__backtrack_wptr = 0;
            } else {
                this.__backtrack_wptr = this.__backtrack_ptr;
            }
            if (this.__backtrack_wsym == null) {
                this.__backtrack_state = new int[72];
                this.__backtrack_wsym = new int[72];
                this.__backtrack_ptrs = new int[72];
                this.__backtrack_cont = new Continuation[72];
                this.__backtrack_sptr = 0;
            } else if (this.__backtrack_sptr >= this.__backtrack_wsym.length) {
                int[] a = this.__backtrack_wsym;
                int[] b = this.__backtrack_ptrs;
                this.__backtrack_wsym = new int[a.length];
                this.__backtrack_ptrs = new int[b.length];
                System.arraycopy(a, 0, this.__backtrack_wsym, 0, a.length);
                System.arraycopy(b, 0, this.__backtrack_ptrs, 0, b.length);
            }
            this.__backtrack_state[this.__backtrack_sptr] = this.STATE;
            this.__backtrack_wsym[this.__backtrack_sptr] = c;
            this.__backtrack_ptrs[this.__backtrack_sptr] = this.__backtrack_wptr;
            this.__backtrack_cont[this.__backtrack_sptr] = this.GETCC();
            ++this.__backtrack_sptr;
            this.__backtrack_flg = true;
            this.__logprint("Set Backtrack: ", c);
        }
    }

    private void __write_backtrack(int c) {
        if (this.__backtrack_wptr >= 0) {
            if (this.__backtrack_wptr < this.__backtrack.length) {
                this.__backtrack[this.__backtrack_wptr++] = c;
            } else {
                int[] a = new int[this.__backtrack.length * 2];
                System.arraycopy(this.__backtrack, 0, a, 0, this.__backtrack.length);
                this.__backtrack = a;
                this.__backtrack[this.__backtrack_wptr++] = c;
            }
        }
    }

    void BACKTRACK_COMMIT() {
        if (--this.__backtrack_sptr <= 0) {
            this.__backtrack_state = null;
            this.__backtrack_wsym = null;
            this.__backtrack_ptrs = null;
            this.__backtrack_cont = null;
            this.__backtrack_sptr = -1;
            this.__backtrack_wptr = -1;
            this.__logprint("Commit Backtracking");
        }
    }

    boolean BACKTRACK(int c) {
        if (this.__backtrack_wptr >= 0) {
            this.__backtrack_len = this.__backtrack_wptr;
            this.__backtrack_wptr = -1;
            --this.__backtrack_sptr;
            this.STATE = this.__backtrack_state[this.__backtrack_sptr];
            this.__backtrack_ptr = this.__backtrack_ptrs[this.__backtrack_sptr];
            this.__backtrack_sym = this.__backtrack_wsym[this.__backtrack_sptr];
            this.SETCC(this.__backtrack_cont[this.__backtrack_sptr]);
            this.__logprint("Rollback Backtracking");
            return true;
        }
        return false;
    }

    Continuation GETCC() {
        return new Continuation(this.STATE, this.__sts, this.__stk, this.__stv, this.__slen);
    }

    void SETCC(Continuation c) {
        this.STATE = c.STATE;
        int l = c.__stk.length;
        l = this.__stk.length > l ? this.__stk.length : l * 2;
        this.__sts = new int[l];
        this.__stk = new Engine[l];
        System.arraycopy(c.__sts, 0, this.__sts, 0, c.__sts.length);
        System.arraycopy(c.__stk, 0, this.__stk, 0, c.__stk.length);
        this.__slen = c.__sts.length;
    }

    private int real_step(Reader __rd, int $c) throws IOException {
        boolean __g = true;
        switch (this.STATE) {
            case 0: {
                if (__g && $c == 43) {
                    this.STATE = 1;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.STATE = 1;
                    return 1;
                }
                if (__g && $c == 46) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 3;
                    return 1;
                }
                return 0;
            }
            case 3: {
                if (__g && $c == 46) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c == 47) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 3;
                    return 1;
                }
                if (__g && $c == 69) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 70) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 101) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 102) {
                    this.STATE = 5;
                    return 1;
                }
                return 0;
            }
            case 5: {
                if (__g && $c == 43) {
                    this.STATE = 6;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.STATE = 6;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 7;
                    return 1;
                }
                return 0;
            }
            case 7: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 7;
                    return 1;
                }
                return 0;
            }
            case 6: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 7;
                    return 1;
                }
                return 0;
            }
            case 4: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 8;
                    return 1;
                }
                return 0;
            }
            case 8: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 8;
                    return 1;
                }
                return 0;
            }
            case 2: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 9;
                    return 1;
                }
                return 0;
            }
            case 9: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 9;
                    return 1;
                }
                if (__g && $c == 69) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 70) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 101) {
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 102) {
                    this.STATE = 5;
                    return 1;
                }
                return 0;
            }
            case 1: {
                if (__g && $c == 46) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 3;
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    private boolean real_accepted() {
        return this.STATE == 3 || this.STATE == 7 || this.STATE == 8 || this.STATE == 9;
    }

    int real_execaction(int $c) {
        switch (this.STATE) {
            case 9: {
                this.af($c);
                break;
            }
            case 6: {
                this.af($c);
                break;
            }
            case 3: {
                this.an($c);
                break;
            }
            case 8: {
                this.ad($c);
                break;
            }
            case 1: {
                this.an($c);
                break;
            }
            case 7: {
                this.af($c);
                break;
            }
            case 4: {
                this.dbf = new StringBuffer();
                break;
            }
            case 0: {
                this.ia();
                break;
            }
            case 2: {
                this.af($c);
                break;
            }
            case 5: {
                this.af($c);
            }
        }
        return 1;
    }

    boolean real_isend() {
        return false;
    }

    private int read_step(Reader __rd, int $c) throws IOException {
        switch (this.STATE) {
            case 0: {
                this.__stkpush(1, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 1: {
                return 0;
            }
        }
        return 0;
    }

    private boolean read_accepted() {
        return this.STATE == 0 || this.STATE == 1;
    }

    int read_execaction(int $c) {
        switch (this.STATE) {
            case 0: {
                this.lst = new Stack();
                break;
            }
            case 1: {
                this.res = this.get();
            }
        }
        return 1;
    }

    boolean read_isend() {
        return false;
    }

    private int number_step(Reader __rd, int $c) throws IOException {
        boolean __g = true;
        switch (this.STATE) {
            case 0: {
                this.__stkpush(1, this.ENGINE_real);
                this.STATE = 0;
                return -1;
            }
            case 1: {
                if (__g && $c == 43) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.UNGET($c);
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c == 64) {
                    this.STATE = 3;
                    return 1;
                }
                if (__g && $c == 105) {
                    this.STATE = 4;
                    return 1;
                }
                return 0;
            }
            case 4: {
                return 0;
            }
            case 3: {
                this.__stkpush(5, this.ENGINE_real);
                this.STATE = 0;
                return -1;
            }
            case 5: {
                return 0;
            }
            case 2: {
                if (__g && $c == 105) {
                    this.STATE = 6;
                    return 1;
                }
                this.__stkpush(7, this.ENGINE_real);
                this.STATE = 0;
                return -1;
            }
            case 7: {
                if (__g && $c == 105) {
                    this.STATE = 8;
                    return 1;
                }
                return 0;
            }
            case 8: {
                return 0;
            }
            case 6: {
                return 0;
            }
        }
        return 0;
    }

    private boolean number_accepted() {
        return this.STATE == 1 || this.STATE == 4 || this.STATE == 5 || this.STATE == 6 || this.STATE == 8;
    }

    int number_execaction(int $c) {
        switch (this.STATE) {
            case 2: {
                break;
            }
            case 5: {
                this.num = LispComplex.newPolar(this.real.getRealDouble(), this.getr().getRealDouble());
                break;
            }
            case 0: {
                this.ib();
                break;
            }
            case 8: {
                this.num = LispComplex.newComplex(this.real, this.getr());
                break;
            }
            case 3: {
                break;
            }
            case 7: {
                break;
            }
            case 1: {
                this.real = this.getr();
                break;
            }
            case 6: {
                this.num = LispComplex.newComplex(this.real, LispInteger.ONE);
                break;
            }
            case 4: {
                this.num = LispComplex.newComplex(LispInteger.ZERO, this.getr());
            }
        }
        return 1;
    }

    boolean number_isend() {
        return false;
    }

    private int sexp_step(Reader __rd, int $c) throws IOException {
        boolean __g = true;
        switch (this.STATE) {
            case 0: {
                if (__g && $c >= 9 && $c <= 13) {
                    this.STATE = 0;
                    return 1;
                }
                if (__g && $c == 32) {
                    this.STATE = 0;
                    return 1;
                }
                if (__g && $c == 34) {
                    this.STATE = 1;
                    return 1;
                }
                if (__g && $c == 35) {
                    this.STATE = 2;
                    return 1;
                }
                if (__g && $c == 39) {
                    this.STATE = 3;
                    return 1;
                }
                if (__g && $c == 40) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c == 43) {
                    this.UNGET($c);
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 44) {
                    this.STATE = 6;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.UNGET($c);
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 46) {
                    this.UNGET($c);
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.UNGET($c);
                    this.STATE = 5;
                    return 1;
                }
                if (__g && $c == 59) {
                    this.STATE = 7;
                    return 1;
                }
                if (__g && $c == 96) {
                    this.STATE = 8;
                    return 1;
                }
                this.STATE = 9;
                return 1;
            }
            case 9: {
                if (__g && $c >= 0 && $c <= 8) {
                    this.STATE = 9;
                    return 1;
                }
                if (__g && $c >= 14 && $c <= 31) {
                    this.STATE = 9;
                    return 1;
                }
                if (__g && $c == 33) {
                    this.STATE = 9;
                    return 1;
                }
                if (__g && $c >= 36 && $c <= 39) {
                    this.STATE = 9;
                    return 1;
                }
                if (__g && $c >= 42 && $c <= 58) {
                    this.STATE = 9;
                    return 1;
                }
                if (__g && $c >= 60 && $c <= Integer.MAX_VALUE) {
                    this.STATE = 9;
                    return 1;
                }
                return 0;
            }
            case 8: {
                this.__stkpush(10, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 10: {
                return 0;
            }
            case 7: {
                if (__g && $c == 10) {
                    this.STATE = 0;
                    return 1;
                }
                this.STATE = 7;
                return 1;
            }
            case 6: {
                if (__g && $c == 64) {
                    this.STATE = 11;
                    return 1;
                }
                this.__stkpush(12, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 12: {
                return 0;
            }
            case 11: {
                this.__stkpush(13, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 13: {
                return 0;
            }
            case 5: {
                if (__g && $c == 0) {
                    this.STATE = 14;
                    return 1;
                }
                this.__stkpush(15, this.ENGINE_number);
                this.STATE = 0;
                return -1;
            }
            case 15: {
                if (__g && $c >= 9 && $c <= 13) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                if (__g && $c == 32) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                if (__g && $c == 34) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                if (__g && $c == 35) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                if (__g && $c == 39) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                if (__g && $c == 40) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                if (__g && $c == 41) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                if (__g && $c == 44) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                if (__g && $c == 59) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                if (__g && $c == 96) {
                    this.UNGET($c);
                    this.STATE = 16;
                    return 1;
                }
                this.UNGET($c);
                this.STATE = 17;
                return 1;
            }
            case 17: {
                return 0;
            }
            case 16: {
                return 0;
            }
            case 14: {
                if (__g && $c >= 0 && $c <= 8) {
                    this.STATE = 14;
                    return 1;
                }
                if (__g && $c >= 14 && $c <= 31) {
                    this.STATE = 14;
                    return 1;
                }
                if (__g && $c == 33) {
                    this.STATE = 14;
                    return 1;
                }
                if (__g && $c >= 36 && $c <= 39) {
                    this.STATE = 14;
                    return 1;
                }
                if (__g && $c >= 42 && $c <= 58) {
                    this.STATE = 14;
                    return 1;
                }
                if (__g && $c >= 60 && $c <= Integer.MAX_VALUE) {
                    this.STATE = 14;
                    return 1;
                }
                return 0;
            }
            case 4: {
                if (__g && $c >= 9 && $c <= 13) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c == 32) {
                    this.STATE = 4;
                    return 1;
                }
                if (__g && $c == 41) {
                    this.STATE = 18;
                    return 1;
                }
                this.__stkpush(19, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 19: {
                if (__g && $c >= 9 && $c <= 13) {
                    this.STATE = 20;
                    return 1;
                }
                if (__g && $c == 32) {
                    this.STATE = 20;
                    return 1;
                }
                if (__g && $c == 41) {
                    this.STATE = 18;
                    return 1;
                }
                if (__g && $c == 46) {
                    this.STATE = 21;
                    return 1;
                }
                this.__stkpush(19, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 21: {
                if (__g && $c >= 9 && $c <= 13) {
                    this.STATE = 22;
                    return 1;
                }
                if (__g && $c == 32) {
                    this.STATE = 22;
                    return 1;
                }
                if (__g && $c == 34) {
                    this.UNGET($c);
                    this.STATE = 22;
                    return 1;
                }
                if (__g && $c == 35) {
                    this.UNGET($c);
                    this.STATE = 22;
                    return 1;
                }
                if (__g && $c == 40) {
                    this.UNGET($c);
                    this.STATE = 22;
                    return 1;
                }
                if (__g && $c == 41) {
                    this.UNGET($c);
                    this.STATE = 22;
                    return 1;
                }
                if (__g && $c == 59) {
                    this.UNGET($c);
                    this.STATE = 22;
                    return 1;
                }
                this.ay(46);
                this.STATE = 23;
                return 1;
            }
            case 23: {
                if (__g && $c >= 0 && $c <= 8) {
                    this.STATE = 23;
                    return 1;
                }
                if (__g && $c >= 14 && $c <= 31) {
                    this.STATE = 23;
                    return 1;
                }
                if (__g && $c == 33) {
                    this.STATE = 23;
                    return 1;
                }
                if (__g && $c >= 36 && $c <= 39) {
                    this.STATE = 23;
                    return 1;
                }
                if (__g && $c >= 42 && $c <= 58) {
                    this.STATE = 23;
                    return 1;
                }
                if (__g && $c >= 60 && $c <= Integer.MAX_VALUE) {
                    this.STATE = 23;
                    return 1;
                }
                this.UNGET($c);
                this.STATE = 19;
                return 1;
            }
            case 22: {
                if (__g && $c >= 9 && $c <= 13) {
                    this.STATE = 22;
                    return 1;
                }
                if (__g && $c == 32) {
                    this.STATE = 22;
                    return 1;
                }
                this.__stkpush(24, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 24: {
                if (__g && $c >= 9 && $c <= 13) {
                    this.STATE = 24;
                    return 1;
                }
                if (__g && $c == 32) {
                    this.STATE = 24;
                    return 1;
                }
                if (__g && $c == 41) {
                    this.STATE = 25;
                    return 1;
                }
                return 0;
            }
            case 25: {
                return 0;
            }
            case 20: {
                if (__g && $c >= 9 && $c <= 13) {
                    this.STATE = 20;
                    return 1;
                }
                if (__g && $c == 32) {
                    this.STATE = 20;
                    return 1;
                }
                if (__g && $c == 41) {
                    this.STATE = 18;
                    return 1;
                }
                if (__g && $c == 46) {
                    this.STATE = 21;
                    return 1;
                }
                this.__stkpush(19, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 18: {
                return 0;
            }
            case 3: {
                this.__stkpush(26, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 26: {
                return 0;
            }
            case 2: {
                if (__g && $c == 40) {
                    this.STATE = 27;
                    return 1;
                }
                if (__g && $c == 66) {
                    this.STATE = 28;
                    return 1;
                }
                if (__g && $c == 68) {
                    this.STATE = 29;
                    return 1;
                }
                if (__g && $c == 69) {
                    this.STATE = 30;
                    return 1;
                }
                if (__g && $c == 72) {
                    this.STATE = 31;
                    return 1;
                }
                if (__g && $c == 73) {
                    this.STATE = 32;
                    return 1;
                }
                if (__g && $c == 79) {
                    this.STATE = 33;
                    return 1;
                }
                if (__g && $c == 92) {
                    this.STATE = 34;
                    return 1;
                }
                if (__g && $c == 98) {
                    this.STATE = 28;
                    return 1;
                }
                if (__g && $c == 100) {
                    this.STATE = 29;
                    return 1;
                }
                if (__g && $c == 101) {
                    this.STATE = 30;
                    return 1;
                }
                if (__g && $c == 102) {
                    this.STATE = 35;
                    return 1;
                }
                if (__g && $c == 104) {
                    this.STATE = 31;
                    return 1;
                }
                if (__g && $c == 105) {
                    this.STATE = 32;
                    return 1;
                }
                if (__g && $c == 111) {
                    this.STATE = 33;
                    return 1;
                }
                if (__g && $c == 116) {
                    this.STATE = 36;
                    return 1;
                }
                if (__g && ($c == 120 || $c == 88)) {
                    this.STATE = 31;
                    return 1;
                }
                return 0;
            }
            case 36: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 37;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 90) {
                    this.STATE = 37;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 122) {
                    this.STATE = 37;
                    return 1;
                }
                return 0;
            }
            case 37: {
                return 0;
            }
            case 35: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 38;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 90) {
                    this.STATE = 38;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 122) {
                    this.STATE = 38;
                    return 1;
                }
                return 0;
            }
            case 38: {
                return 0;
            }
            case 34: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 39;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 90) {
                    this.STATE = 39;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 122) {
                    this.STATE = 39;
                    return 1;
                }
                this.STATE = 40;
                return 1;
            }
            case 40: {
                return 0;
            }
            case 39: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 41;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 90) {
                    this.STATE = 41;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 122) {
                    this.STATE = 41;
                    return 1;
                }
                return 0;
            }
            case 41: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 41;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 90) {
                    this.STATE = 41;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 122) {
                    this.STATE = 41;
                    return 1;
                }
                return 0;
            }
            case 33: {
                if (__g && $c == 35) {
                    this.STATE = 42;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.STATE = 43;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 44;
                    return 1;
                }
                return 0;
            }
            case 44: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 44;
                    return 1;
                }
                return 0;
            }
            case 43: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 44;
                    return 1;
                }
                return 0;
            }
            case 42: {
                if (__g && $c == 69) {
                    this.STATE = 45;
                    return 1;
                }
                if (__g && $c == 73) {
                    this.STATE = 46;
                    return 1;
                }
                if (__g && $c == 101) {
                    this.STATE = 45;
                    return 1;
                }
                if (__g && $c == 105) {
                    this.STATE = 46;
                    return 1;
                }
                return 0;
            }
            case 46: {
                this.UNGET($c);
                this.STATE = 44;
                return 1;
            }
            case 45: {
                this.UNGET($c);
                this.STATE = 44;
                return 1;
            }
            case 32: {
                if (__g && $c == 35) {
                    this.STATE = 47;
                    return 1;
                }
                this.__stkpush(48, this.ENGINE_number);
                this.STATE = 0;
                return -1;
            }
            case 48: {
                return 0;
            }
            case 47: {
                if (__g && $c == 66) {
                    this.STATE = 28;
                    return 1;
                }
                if (__g && $c == 68) {
                    this.STATE = 29;
                    return 1;
                }
                if (__g && $c == 72) {
                    this.STATE = 31;
                    return 1;
                }
                if (__g && $c == 79) {
                    this.STATE = 33;
                    return 1;
                }
                if (__g && $c == 98) {
                    this.STATE = 28;
                    return 1;
                }
                if (__g && $c == 100) {
                    this.STATE = 29;
                    return 1;
                }
                if (__g && $c == 104) {
                    this.STATE = 31;
                    return 1;
                }
                if (__g && $c == 111) {
                    this.STATE = 33;
                    return 1;
                }
                if (__g && ($c == 120 || $c == 88)) {
                    this.STATE = 31;
                    return 1;
                }
                return 0;
            }
            case 31: {
                if (__g && $c == 35) {
                    this.STATE = 49;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.STATE = 50;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 51;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 70) {
                    this.STATE = 51;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 102) {
                    this.STATE = 51;
                    return 1;
                }
                return 0;
            }
            case 51: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 51;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 70) {
                    this.STATE = 51;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 102) {
                    this.STATE = 51;
                    return 1;
                }
                return 0;
            }
            case 50: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 51;
                    return 1;
                }
                if (__g && $c >= 65 && $c <= 70) {
                    this.STATE = 51;
                    return 1;
                }
                if (__g && $c >= 97 && $c <= 102) {
                    this.STATE = 51;
                    return 1;
                }
                return 0;
            }
            case 49: {
                if (__g && $c == 69) {
                    this.STATE = 52;
                    return 1;
                }
                if (__g && $c == 73) {
                    this.STATE = 53;
                    return 1;
                }
                if (__g && $c == 101) {
                    this.STATE = 52;
                    return 1;
                }
                if (__g && $c == 105) {
                    this.STATE = 53;
                    return 1;
                }
                return 0;
            }
            case 53: {
                this.UNGET($c);
                this.STATE = 51;
                return 1;
            }
            case 52: {
                this.UNGET($c);
                this.STATE = 51;
                return 1;
            }
            case 30: {
                if (__g && $c == 35) {
                    this.STATE = 54;
                    return 1;
                }
                this.__stkpush(55, this.ENGINE_number);
                this.STATE = 0;
                return -1;
            }
            case 55: {
                return 0;
            }
            case 54: {
                if (__g && $c == 66) {
                    this.STATE = 28;
                    return 1;
                }
                if (__g && $c == 68) {
                    this.STATE = 29;
                    return 1;
                }
                if (__g && $c == 72) {
                    this.STATE = 31;
                    return 1;
                }
                if (__g && $c == 79) {
                    this.STATE = 33;
                    return 1;
                }
                if (__g && $c == 98) {
                    this.STATE = 28;
                    return 1;
                }
                if (__g && $c == 100) {
                    this.STATE = 29;
                    return 1;
                }
                if (__g && $c == 104) {
                    this.STATE = 31;
                    return 1;
                }
                if (__g && $c == 111) {
                    this.STATE = 33;
                    return 1;
                }
                return 0;
            }
            case 29: {
                if (__g && $c == 35) {
                    this.STATE = 56;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.STATE = 57;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 58;
                    return 1;
                }
                return 0;
            }
            case 58: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 58;
                    return 1;
                }
                return 0;
            }
            case 57: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 58;
                    return 1;
                }
                return 0;
            }
            case 56: {
                if (__g && $c == 69) {
                    this.STATE = 59;
                    return 1;
                }
                if (__g && $c == 73) {
                    this.STATE = 60;
                    return 1;
                }
                if (__g && $c == 101) {
                    this.STATE = 59;
                    return 1;
                }
                if (__g && $c == 105) {
                    this.STATE = 60;
                    return 1;
                }
                return 0;
            }
            case 60: {
                this.UNGET($c);
                this.STATE = 58;
                return 1;
            }
            case 59: {
                this.UNGET($c);
                this.STATE = 58;
                return 1;
            }
            case 28: {
                if (__g && $c == 35) {
                    this.STATE = 61;
                    return 1;
                }
                if (__g && $c == 45) {
                    this.STATE = 62;
                    return 1;
                }
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 63;
                    return 1;
                }
                return 0;
            }
            case 63: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 63;
                    return 1;
                }
                return 0;
            }
            case 62: {
                if (__g && $c >= 48 && $c <= 57) {
                    this.STATE = 63;
                    return 1;
                }
                return 0;
            }
            case 61: {
                if (__g && $c == 69) {
                    this.STATE = 64;
                    return 1;
                }
                if (__g && $c == 73) {
                    this.STATE = 65;
                    return 1;
                }
                if (__g && $c == 101) {
                    this.STATE = 64;
                    return 1;
                }
                if (__g && $c == 105) {
                    this.STATE = 65;
                    return 1;
                }
                return 0;
            }
            case 65: {
                this.UNGET($c);
                this.STATE = 63;
                return 1;
            }
            case 64: {
                this.UNGET($c);
                this.STATE = 63;
                return 1;
            }
            case 27: {
                this.UNGET($c);
                this.STATE = 66;
                return 1;
            }
            case 66: {
                if (__g && $c >= 9 && $c <= 13) {
                    this.STATE = 66;
                    return 1;
                }
                if (__g && $c == 32) {
                    this.STATE = 66;
                    return 1;
                }
                if (__g && $c == 41) {
                    this.STATE = 67;
                    return 1;
                }
                this.__stkpush(68, this.ENGINE_sexp);
                this.STATE = 0;
                return -1;
            }
            case 68: {
                if (__g && $c == 41) {
                    this.STATE = 67;
                    return 1;
                }
                this.UNGET($c);
                this.STATE = 66;
                return 1;
            }
            case 67: {
                return 0;
            }
            case 1: {
                if (__g && $c == 34) {
                    this.STATE = 69;
                    return 1;
                }
                if (__g && $c == 92) {
                    this.STATE = 70;
                    return 1;
                }
                this.STATE = 1;
                return 1;
            }
            case 70: {
                if (__g && $c == 110) {
                    this.ayn();
                    this.STATE = 71;
                    return 1;
                }
                this.ayq();
                this.STATE = 1;
                return 1;
            }
            case 71: {
                this.UNGET($c);
                this.STATE = 1;
                return 1;
            }
            case 69: {
                return 0;
            }
        }
        return 0;
    }

    private boolean sexp_accepted() {
        return this.STATE == 0 || this.STATE == 69 || this.STATE == 7 || this.STATE == 67 || this.STATE == 9 || this.STATE == 10 || this.STATE == 12 || this.STATE == 13 || this.STATE == 14 || this.STATE == 15 || this.STATE == 16 || this.STATE == 18 || this.STATE == 23 || this.STATE == 25 || this.STATE == 26 || this.STATE == 35 || this.STATE == 39 || this.STATE == 36 || this.STATE == 40 || this.STATE == 41 || this.STATE == 44 || this.STATE == 51 || this.STATE == 48 || this.STATE == 55 || this.STATE == 58 || this.STATE == 63;
    }

    int sexp_execaction(int $c) {
        switch (this.STATE) {
            case 19: {
                this.adg($c);
                break;
            }
            case 50: {
                this.ax($c);
                break;
            }
            case 48: {
                this.dtm = (this.num != null ? this.num : this.real).toInexact();
                break;
            }
            case 27: {
                this.lst.push(new ArrayList());
                break;
            }
            case 35: {
                this.dtm = LispBoolean.FALSE;
                break;
            }
            case 62: {
                this.ab($c);
                break;
            }
            case 46: {
                this.exactness = 2;
                break;
            }
            case 57: {
                this.az($c);
                break;
            }
            case 56: {
                break;
            }
            case 53: {
                this.exactness = 2;
                break;
            }
            case 45: {
                this.exactness = 1;
                break;
            }
            case 44: {
                this.ao($c);
                break;
            }
            case 40: {
                this.chr = $c;
                break;
            }
            case 54: {
                break;
            }
            case 30: {
                break;
            }
            case 2: {
                break;
            }
            case 25: {
                this.l2d();
                break;
            }
            case 14: {
                this.ay($c);
                break;
            }
            case 8: {
                break;
            }
            case 38: {
                break;
            }
            case 61: {
                break;
            }
            case 67: {
                this.dtm = new LispVector((Collection<Datum>)this.lst.pop());
                break;
            }
            case 1: {
                this.ay($c);
                break;
            }
            case 42: {
                break;
            }
            case 11: {
                break;
            }
            case 60: {
                this.exactness = 2;
                break;
            }
            case 15: {
                this.dtm = this.num != null ? this.num : this.real;
                break;
            }
            case 21: {
                this.ybf = null;
                break;
            }
            case 49: {
                break;
            }
            case 20: {
                break;
            }
            case 63: {
                this.ab($c);
                break;
            }
            case 18: {
                this.dtm = LispUtils.listToCons((Collection<? extends Datum>)this.lst.pop());
                break;
            }
            case 22: {
                break;
            }
            case 3: {
                break;
            }
            case 13: {
                this.dtm = new Cons(UQS, new Cons(this.get(), Nil.NIL));
                break;
            }
            case 39: {
                this.chr = $c;
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 41: {
                this.ac($c);
                break;
            }
            case 28: {
                break;
            }
            case 52: {
                this.exactness = 1;
                break;
            }
            case 23: {
                this.dtm = null;
                this.ay($c);
                break;
            }
            case 31: {
                break;
            }
            case 59: {
                this.exactness = 1;
                break;
            }
            case 43: {
                this.ao($c);
                break;
            }
            case 68: {
                this.lst.peek().add(this.get());
                break;
            }
            case 71: {
                break;
            }
            case 36: {
                this.dtm = LispBoolean.TRUE;
                break;
            }
            case 16: {
                this.BACKTRACK_COMMIT();
                break;
            }
            case 47: {
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                this.adl($c);
                break;
            }
            case 51: {
                this.ax($c);
                break;
            }
            case 69: {
                this.dtm = new LispString(this.ybf.substring(1));
                break;
            }
            case 29: {
                break;
            }
            case 32: {
                break;
            }
            case 55: {
                this.dtm = (this.num != null ? this.num : this.real).toExact();
                break;
            }
            case 64: {
                this.exactness = 1;
                break;
            }
            case 26: {
                this.dtm = new Cons(QUT, new Cons(this.get(), Nil.NIL));
                break;
            }
            case 65: {
                this.exactness = 2;
                break;
            }
            case 66: {
                break;
            }
            case 9: {
                this.ay($c);
                break;
            }
            case 5: {
                this.SET_BACKTRACK(0);
                break;
            }
            case 70: {
                break;
            }
            case 24: {
                break;
            }
            case 17: {
                this.dtm = null;
                break;
            }
            case 12: {
                this.dtm = new Cons(UQT, new Cons(this.get(), Nil.NIL));
                break;
            }
            case 58: {
                this.az($c);
                break;
            }
            case 10: {
                this.dtm = new Cons(QQT, new Cons(this.get(), Nil.NIL));
                break;
            }
            case 37: {
                break;
            }
            case 0: {
                this.init();
                break;
            }
        }
        return 1;
    }

    boolean sexp_isend() {
        return false;
    }

    private int nanoParser_step(Reader __rd, int $c) throws IOException {
        boolean __g = true;
        switch (this.STATE) {
            case 0: {
                this.__stkpush(1, this.ENGINE_read);
                this.STATE = 0;
                return -1;
            }
            case 1: {
                if (__g && $c == 10) {
                    this.STATE = 0;
                    return 1;
                }
                this.STATE = 1;
                return 1;
            }
            case 2: {
                this.STATE = 2;
                return 1;
            }
            case 3: {
                this.UNGET($c);
                this.STATE = 0;
                return 1;
            }
        }
        return 0;
    }

    private boolean nanoParser_accepted() {
        return this.STATE == 0 || this.STATE == 1 || this.STATE == 2 || this.STATE == 3;
    }

    int nanoParser_execaction(int $c) {
        switch (this.STATE) {
            case 2: {
                System.err.println("read error");
                break;
            }
            case 3: {
                System.err.println("error");
                this.exception.printStackTrace();
                break;
            }
            case 1: {
                this.putresult(this.res);
                break;
            }
            case 0: {
                this.putprompt1();
            }
        }
        return 1;
    }

    boolean nanoParser_isend() {
        return false;
    }

    void __stkpush(int st, Engine en) {
        if (this.__slen >= this.__sts.length) {
            int[] a = new int[this.__sts.length * 2];
            Engine[] b = new Engine[this.__stk.length * 2];
            Object[][] c = new Object[this.__stk.length * 2][];
            System.arraycopy(this.__sts, 0, a, 0, this.__sts.length);
            System.arraycopy(this.__stk, 0, b, 0, this.__stk.length);
            System.arraycopy(this.__stv, 0, c, 0, this.__stv.length);
            this.__sts = a;
            this.__stk = b;
            this.__stv = c;
        }
        this.__sts[this.__slen] = st;
        this.__stk[this.__slen] = en;
        this.__stv[this.__slen++] = new Object[en.stateSize()];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int _parse(Reader rd, int x) throws IOException {
        boolean b = false;
        int c = x;
        b = this.__stk[this.__slen - 1].accepted();
        if (rd == null) {
            throw new RuntimeException("can not recurse");
        }
        switch (this.__stk[this.__slen - 1].execaction(-2)) {
            case -1: {
                this.__logprint("accept " + this.__stk[this.__slen - 1]);
                return -1;
            }
            case -9: {
                this.__logprint("match failed: begin");
                this.__puttrace();
                return -9;
            }
            case -91: {
                this.__logprint("machine halted: begin");
                return -91;
            }
            case -72: {
                this.__logprint("machine halted: begin");
                return -72;
            }
        }
        try {
            do {
                Engine en = this.__stk[this.__slen - 1];
                if (c < 0) continue;
                int a = en.step(rd, c);
                if (a > 0) {
                    this.__logprint("transit to state " + this.STATE + ": ", c);
                    b = en.accepted();
                    switch (en.execaction(c)) {
                        case -1: {
                            this.__logprint("accept " + this.__stk[this.__slen - 1]);
                            this.UNGET(c);
                            return -1;
                        }
                        case -9: {
                            this.__logprint("match failed: ", c);
                            this.__puttrace();
                            this.UNGET(c);
                            return -9;
                        }
                        case -91: {
                            this.__logprint("machine halted: ", c);
                            return -91;
                        }
                        case -72: {
                            this.__logprint("machine halted: ", c);
                            return -72;
                        }
                    }
                    if (!this.__backtrack_flg) continue;
                    this.__write_backtrack(c);
                    this.__backtrack_flg = false;
                    continue;
                }
                if (a < 0) {
                    this.__logprint("entering " + this.__stk[this.__slen - 1]);
                    return c;
                }
                if (b) {
                    this.__logprint("accept " + this.__stk[this.__slen - 1]);
                    this.UNGET(c);
                    return -1;
                }
                if (!this.BACKTRACK(c)) {
                    this.__logprint("match failed: ", c);
                    this.__puttrace();
                    this.UNGET(c);
                    return -9;
                }
                this.__logprint("match failed: try backtracking: ", c);
            } while ((c = this._read(rd)) >= 0);
            if (!b) {
                throw new TokenException();
            }
            return -1;
        }
        catch (RuntimeException e) {
            this.UNGET(c);
            throw e;
        }
    }

    private Boolean execfinally() {
        int a = this.__stk[this.__slen - 1].finallyState();
        if (a >= 0) {
            int b = this.STATE;
            this.STATE = a;
            switch (this.__stk[this.__slen - 1].execaction(-2)) {
                case -91: {
                    this.__slen = 0;
                    return Boolean.TRUE;
                }
                case -72: {
                    this.__slen = 0;
                    return Boolean.FALSE;
                }
            }
            this.STATE = b;
        }
        return null;
    }

    private int getdeadstate() {
        return this.__stk[this.__slen - 1].deadState();
    }

    private int getrecover(Exception e) {
        return this.__stk[this.__slen - 1].recover(e);
    }

    /*
     * Unable to fully structure code
     */
    boolean parse(Reader rd, Engine entry) throws IOException {
        c = -1;
        this.__logopen();
        try {
            this.__stkpush(0, entry);
            block13: while (true) {
                block24: {
                    try {
                        while ((c = this._parse(rd, c)) >= 0) {
                        }
                        if (c != -9) break block24;
                        while (true) lbl-1000:
                        // 2 sources

                        {
                            if ((this.STATE = this.getdeadstate()) >= 0) continue block13;
                            b = this.execfinally();
                            if (b == null) continue;
                            var7_6 = b;
                            return var7_6;
                        }
                    }
                    catch (RuntimeException e) {
                        this.exception = e;
                        if (this.__slen > 0) ** GOTO lbl54
                        throw e;
                    }
                    {
                        ** while (this.__slen-- > 1)
                    }
lbl21:
                    // 1 sources

                    throw new TokenException();
                }
                if (c == -91) {
                    b = this.execfinally();
                    if (b != null) {
                        var7_7 = b;
                        return var7_7;
                    }
                    this.__slen = 0;
                    return true;
                }
                if (c == -72) {
                    b = this.execfinally();
                    if (b != null) {
                        var7_8 = b;
                        return var7_8;
                    }
                    this.__slen = 0;
                    return false;
                }
                if (this.__slen > 1) {
                    b = this.execfinally();
                    if (b != null) {
                        var7_9 = b;
                        return var7_9;
                    }
                    this.STATE = this.__sts[--this.__slen];
                    continue;
                }
                b = this.execfinally();
                if (b == null) break;
                var7_10 = b;
                return var7_10;
lbl-1000:
                // 1 sources

                {
                    b = this.execfinally();
                    if (b != null) {
                        var7_11 = b;
                        return var7_11;
                    }
                    if (this.__slen-- > 1) continue;
                    throw e;
lbl54:
                    // 2 sources

                    ** while ((this.STATE = this.getrecover((Exception)e)) < 0)
                }
lbl55:
                // 1 sources

            }
            var7_12 = this.__stk[this.__slen - 1].accepted();
            return var7_12;
        }
        finally {
            this.__logclose();
        }
    }

    boolean parse(Reader rd) throws IOException {
        return this.parse(rd, this.ENGINE_nanoParser);
    }

    boolean parse(InputStream rd) throws IOException {
        return this.parse(new InputStreamReader(rd));
    }

    static boolean parseAll(Reader rd) throws IOException {
        NanoParser o = new NanoParser();
        return o.parse(rd);
    }

    static boolean parseAll(InputStream rd) throws IOException {
        return NanoParser.parseAll(new InputStreamReader(rd));
    }

    static class Continuation {
        private int STATE;
        private int[] __sts;
        private Engine[] __stk;
        private Object[][] __stv;

        Continuation(int s, int[] sts, Engine[] stk, Object[][] stv, int len) {
            this.STATE = s;
            this.__sts = new int[len];
            this.__stk = new Engine[len];
            this.__stv = new Object[len][];
            System.arraycopy(sts, 0, this.__sts, 0, len);
            System.arraycopy(stk, 0, this.__stk, 0, len);
            System.arraycopy(stv, 0, this.__stv, 0, len);
        }
    }

    static abstract class Engine {
        Engine() {
        }

        abstract int step(Reader var1, int var2) throws IOException;

        abstract boolean accepted();

        abstract int execaction(int var1);

        abstract boolean isend();

        abstract int recover(Exception var1);

        abstract int deadState();

        abstract int stateSize();

        abstract int finallyState();
    }

    static class TokenException
    extends RuntimeException {
        TokenException() {
        }
    }
}

