/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Logger;
import net.morilib.lisp.nano.Closure;
import net.morilib.lisp.nano.ClosureClass;
import net.morilib.lisp.nano.CodeExecutor;
import net.morilib.lisp.nano.CompiledCode;
import net.morilib.lisp.nano.CompilerFactory;
import net.morilib.lisp.nano.Cons;
import net.morilib.lisp.nano.ConsListBuilder;
import net.morilib.lisp.nano.Continuation;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.EOFObject;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.EnvironmentObject;
import net.morilib.lisp.nano.InputPort;
import net.morilib.lisp.nano.IntLispUtils;
import net.morilib.lisp.nano.IntStack;
import net.morilib.lisp.nano.LispBoolean;
import net.morilib.lisp.nano.LispCompiler;
import net.morilib.lisp.nano.LispException;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.LispVector;
import net.morilib.lisp.nano.MultiValues;
import net.morilib.lisp.nano.NamableDatum;
import net.morilib.lisp.nano.Nil;
import net.morilib.lisp.nano.Promise;
import net.morilib.lisp.nano.ReadOnlyException;
import net.morilib.lisp.nano.Subr;
import net.morilib.lisp.nano.Symbol;
import net.morilib.lisp.nano.SymbolName;
import net.morilib.lisp.nano.Undef;
import net.morilib.lisp.nano.util.LogEnv;

class CodeExecutorImpl
implements CodeExecutor {
    private static Logger _log = LogEnv.init("schlush.vm");
    private LispMessage message;

    CodeExecutorImpl(LispMessage msg) {
        this.message = msg;
    }

    private Datum evalApplyValid(Datum body) {
        List<Datum> lst1 = LispUtils.consToList(body, this.message);
        if (lst1.size() < 2) {
            throw this.message.getError("err.argument");
        }
        return Undef.UNDEF;
    }

    private Datum evalApply(Datum body) {
        List<Datum> lst1 = LispUtils.consToList(body, this.message);
        ArrayList<Datum> arg = new ArrayList<Datum>();
        int i = 0;
        while (i < lst1.size() - 1) {
            arg.add(lst1.get(i));
            ++i;
        }
        List<Datum> elst = LispUtils.consToList(lst1.get(lst1.size() - 1), this.message);
        arg.addAll(elst);
        return LispUtils.listToCons(arg);
    }

    private void callSubr(Subr sub, int addr, Environment env, Datum d3d, Memento m, Datum callee) {
        m.addrStk.push(addr);
        m.codeStk.push(null);
        m.envStk.push(env);
        m.callerStk.push(callee);
        m.memoStk.push(null);
        try {
            m.dataStk.push(sub.eval(d3d, env, this.message));
        }
        finally {
            m.addrStk.pop();
            m.codeStk.pop();
            m.envStk.pop();
            m.callerStk.pop();
            m.memoStk.pop();
        }
    }

    private void setContinuationArgs(List<Datum> lst, Memento m) {
        m.dataStk.push(MultiValues.newValues(lst));
    }

    private ClosureClass makeLoad(InputPort ipt, Environment env, Memento memento) {
        Datum d;
        CompiledCode.Builder b = new CompiledCode.Builder();
        LispCompiler comp = CompilerFactory.getInstance(this.message);
        while ((d = ipt.readS()) != EOFObject.EOF) {
            comp.compile(d, env, b, true, new Cons(), true, new LinkedList<Cons>(), this, memento);
        }
        b.addPop();
        b.addPush(Undef.UNDEF);
        b.addReturnOp();
        ClosureClass clc = new ClosureClass(Nil.NIL, b.getCodeRef());
        return clc;
    }

    private Closure makeEval(Datum sexp, Environment env, Memento memento) {
        Datum d = sexp;
        CompiledCode.Builder b = new CompiledCode.Builder();
        LispCompiler comp = CompilerFactory.getInstance(this.message);
        comp.compile(d, env, b, true, new Cons(), true, new LinkedList<Cons>(), this, memento);
        b.addReturnOp();
        ClosureClass clc = new ClosureClass(Nil.NIL, b.getCodeRef());
        Closure res = new Closure(clc, env);
        return res;
    }

    private Environment calltail0(CompiledCode.Code c, Memento m, Closure cl) {
        CompiledCode.Builder bb = new CompiledCode.Builder();
        _log.finer("Remove " + c.getRewind() + " frame(s) for tail call");
        bb.merge(m.aftret);
        int i = 0;
        while (i < c.getRewind()) {
            m.envStk.pop();
            m.addrStk.pop();
            m.codeStk.pop();
            m.callerStk.pop();
            m.memoStk.pop();
            ++i;
        }
        m.aftret = bb.getCodeRef();
        Environment env = cl.getEnvironment().copyNotRoot();
        _log.finer("Tail jump top:" + cl.printName() + ":dtstk(" + m.dataStk.size() + "):cdstk(" + m.codeStk.size() + ")");
        return env;
    }

    private void bind0(Environment env, Symbol sym, Datum dest) {
        if (dest instanceof NamableDatum) {
            ((NamableDatum)dest).setName(sym.getName());
        }
        env.bindDatum(sym, dest);
    }

    private boolean set0(Environment env, Symbol sym, Datum dest) {
        if (dest instanceof NamableDatum) {
            ((NamableDatum)dest).setName(sym.getName());
        }
        try {
            return env.setDatum(sym, dest);
        }
        catch (ReadOnlyException e) {
            throw this.message.getError("err.variablereadonly", sym);
        }
    }

    private Datum exec(CompiledCode code1, Environment env1, IntStack memento, boolean useCont) {
        int addr = 0;
        Memento m = (Memento)memento;
        CompiledCode code = code1;
        Environment env = env1;
        Environment tenv = null;
        block32: while (true) {
            CompiledCode.Code c;
            if ((c = code.getCode(addr)) == null) {
                return Undef.UNDEF;
            }
            switch (c.getOp()) {
                case PUSH: {
                    Datum aaa = c.getDatum();
                    if (aaa instanceof ClosureClass) {
                        Closure ncl = new Closure((ClosureClass)aaa, env);
                        m.dataStk.push(ncl);
                    } else {
                        m.dataStk.push(aaa);
                    }
                    ++addr;
                    continue block32;
                }
                case POP: {
                    m.dataStk.pop();
                    ++addr;
                    continue block32;
                }
                case BEGIN_LIST: {
                    m.workStk.push(new ConsListBuilder());
                    ++addr;
                    continue block32;
                }
                case APPEND_LIST: {
                    Datum d11 = (Datum)m.dataStk.pop();
                    ConsListBuilder d12 = (ConsListBuilder)m.workStk.peek();
                    d12.append(d11);
                    ++addr;
                    continue block32;
                }
                case APPEND_LIST_SPLICING: {
                    Datum d13 = (Datum)m.dataStk.pop();
                    ConsListBuilder d14 = (ConsListBuilder)m.workStk.peek();
                    d14.appendAll(d13, this.message);
                    ++addr;
                    continue block32;
                }
                case APPEND_LIST_MULTI_VALUES: {
                    Datum d15 = (Datum)m.dataStk.pop();
                    ConsListBuilder d16 = (ConsListBuilder)m.workStk.peek();
                    d16.appendAll(LispUtils.listToCons(d15.getValues()), this.message);
                    ++addr;
                    continue block32;
                }
                case END_LIST_DOT: {
                    Datum d21 = (Datum)m.dataStk.pop();
                    ConsListBuilder d22 = (ConsListBuilder)m.workStk.pop();
                    m.dataStk.push(d22.get(d21));
                    ++addr;
                    continue block32;
                }
                case END_LIST: {
                    ConsListBuilder d23 = (ConsListBuilder)m.workStk.pop();
                    m.dataStk.push(d23.get());
                    ++addr;
                    continue block32;
                }
                case END_LIST_VECTOR: {
                    ConsListBuilder d24 = (ConsListBuilder)m.workStk.pop();
                    m.dataStk.push(new LispVector(LispUtils.consToList(d24.get(), this.message)));
                    ++addr;
                    continue block32;
                }
                case CALL: 
                case CALL_TAIL: {
                    Datum d3d = (Datum)m.dataStk.pop();
                    Datum d3s = (Datum)m.dataStk.pop();
                    if (d3s instanceof Subr) {
                        Subr sub = (Subr)d3s;
                        Environment ex2 = env.getGlobal();
                        ClosureClass cl = sub.getClosureClass(ex2);
                        if (cl == null) {
                            this.callSubr(sub, addr, env, d3d, m, d3s);
                            ++addr;
                            continue block32;
                        }
                        m.push(addr, code, env, d3s);
                        env = new Environment(ex2);
                        IntLispUtils.bindLocal(cl.getParameterList(), d3d, env, this.message);
                        code = cl.getCode();
                        addr = 0;
                        continue block32;
                    }
                    if (d3s instanceof Subr) {
                        this.callSubr((Subr)d3s, addr, env, d3d, m, d3s);
                        ++addr;
                        continue block32;
                    }
                    if (d3s instanceof Closure) {
                        Closure cl = (Closure)d3s;
                        if (c.getOp().equals((Object)CompiledCode.Oper.CALL_TAIL)) {
                            env = this.calltail0(c, m, cl);
                        } else if (c.getOp().equals((Object)CompiledCode.Oper.CALL)) {
                            m.push(addr, code, env, d3s);
                            env = new Environment(cl.getEnvironment());
                            _log.finer("Call:" + cl.printName() + ":dtstk(" + m.dataStk.size() + "):cdstk(" + m.codeStk.size() + ")");
                        }
                        IntLispUtils.bindLocal(cl.getParameterList(), d3d, env, this.message);
                        code = cl.getCode();
                        addr = 0;
                        continue block32;
                    }
                    if (d3s instanceof Continuation) {
                        Continuation ct = (Continuation)d3s;
                        List<Datum> lst = LispUtils.consToList(d3d, this.message);
                        Memento k = (Memento)ct.getMemento();
                        this.exec(m.aftret, env, m, false);
                        m.aftret = new CompiledCode();
                        int iz = 0;
                        while (iz < m.envStk.size() && iz < k.envStk.size()) {
                            if (m.envStk.get(iz) != k.envStk.get(iz)) break;
                            ++iz;
                        }
                        m.overwrite(k.copy());
                        env = (Environment)m.envStk.pop();
                        code = (CompiledCode)m.codeStk.pop();
                        addr = (Integer)m.addrStk.pop();
                        m.callerStk.pop();
                        m.dataStk.pop();
                        m.workStk.pop();
                        m.memoStk.pop();
                        this.setContinuationArgs(lst, m);
                        ++addr;
                        continue block32;
                    }
                    if (d3s instanceof Undef) {
                        m.dataStk.push(Undef.UNDEF);
                        ++addr;
                        continue block32;
                    }
                    throw this.message.getError("err.invalidap", d3s);
                }
                case CALL_METHOD: {
                    Datum d3d1 = (Datum)m.dataStk.pop();
                    Datum d3s1 = (Datum)m.dataStk.pop();
                    if (d3s1 instanceof Symbol) {
                        String nm = ((Symbol)d3s1).getName();
                        if ("aux-apply".equals(nm)) {
                            m.dataStk.push(this.evalApply(d3d1));
                        } else if ("aux-apply-valid".equals(nm)) {
                            m.dataStk.push(this.evalApplyValid(d3d1));
                        }
                    } else {
                        throw new RuntimeException();
                    }
                    ++addr;
                    continue block32;
                }
                case JMP: {
                    addr = code.getAddress(c.getJmpLabel());
                    continue block32;
                }
                case JMP_IF: {
                    if (((Datum)m.dataStk.peek()).isTrue()) {
                        addr = code.getAddress(c.getJmpLabel());
                        continue block32;
                    }
                    ++addr;
                    continue block32;
                }
                case JMP_UNLESS: {
                    if (!((Datum)m.dataStk.peek()).isTrue()) {
                        addr = code.getAddress(c.getJmpLabel());
                        continue block32;
                    }
                    ++addr;
                    continue block32;
                }
                case JMP_TOP: {
                    _log.finer("Jump to top:cdstk(" + m.codeStk.size() + ")");
                    addr = 0;
                    continue block32;
                }
                case REFER_SYMBOL: 
                case REFER_SETTER: {
                    Datum d51 = env.findDatum(c.getDatum());
                    if (d51 == null) {
                        throw this.message.getError("err.unbound", c.getDatum());
                    }
                    if (!c.getOp().equals((Object)CompiledCode.Oper.REFER_SETTER)) {
                        m.dataStk.push(d51);
                    }
                    ++addr;
                    continue block32;
                }
                case REFER_DEFINED: {
                    Datum d51 = env.findDatum(c.getDatum());
                    m.dataStk.push(LispBoolean.getInstance(d51 != null));
                    ++addr;
                    continue block32;
                }
                case BIND: {
                    if (c.getDatum() instanceof SymbolName) {
                        Symbol sym = (Symbol)c.getDatum();
                        if (tenv != null) {
                            this.bind0(tenv, sym, (Datum)m.dataStk.pop());
                        } else {
                            this.bind0(env, sym, (Datum)m.dataStk.pop());
                        }
                    } else {
                        throw this.message.getError("err.symbol", c.getDatum());
                    }
                    ++addr;
                    continue block32;
                }
                case SET: {
                    if (c.getDatum() instanceof Symbol && !this.set0(env, (Symbol)c.getDatum(), (Datum)m.dataStk.peek())) {
                        throw this.message.getError("err.unbound", c.getDatum());
                    }
                    ++addr;
                    continue block32;
                }
                case RETURN_OP: {
                    this.exec(m.aftret, env, m, false);
                    m.aftret = new CompiledCode();
                    if (m.callerStk.isEmpty()) {
                        return (Datum)m.dataStk.pop();
                    }
                    env = (Environment)m.envStk.pop();
                    code = (CompiledCode)m.codeStk.pop();
                    addr = (Integer)m.addrStk.pop();
                    m.callerStk.pop();
                    Promise p = (Promise)m.memoStk.pop();
                    _log.finer("Return:dtstk(" + m.dataStk.size() + "):cdstk(" + m.codeStk.size() + ")");
                    if (p != null) {
                        p.setMemo((Datum)m.dataStk.peek());
                    }
                    ++addr;
                    continue block32;
                }
                case PUSH_CONTINUATION: {
                    Memento cm = m.copy();
                    Continuation rs0 = new Continuation(cm);
                    m.dataStk.push(rs0);
                    ++addr;
                    continue block32;
                }
                case FORCE: {
                    Promise p;
                    Datum d61 = (Datum)m.dataStk.pop();
                    if (d61 instanceof Promise) {
                        p = (Promise)d61;
                        if (p.getMemo() == null) {
                            m.push(addr, code, env, p);
                            env = new Environment(p.getEnvironment());
                            code = p.getCode();
                            addr = 0;
                            continue block32;
                        }
                        m.dataStk.push(p.getMemo());
                        ++addr;
                        continue block32;
                    }
                    throw this.message.getError("err.force", "force");
                }
                case NEW_PROMISE: {
                    if (!(c.getDatum() instanceof Promise)) {
                        throw this.message.getError("err.force");
                    }
                    Promise p = (Promise)c.getDatum();
                    Promise np = new Promise(p.getCode());
                    np.setEnvironment(env);
                    m.dataStk.push(np);
                    ++addr;
                    continue block32;
                }
                case APPEND_VALUES: {
                    Datum d71 = (Datum)m.dataStk.pop();
                    if (d71 instanceof MultiValues) {
                        MultiValues d = (MultiValues)d71;
                        m.dataStk.push(LispUtils.listToCons(d.getValues()));
                    } else if (d71 == Undef.UNDEF) {
                        m.dataStk.push(Nil.NIL);
                    } else {
                        Cons b = new Cons();
                        b.setCar(d71);
                        m.dataStk.push(b);
                    }
                    ++addr;
                    continue block32;
                }
                case EVAL_CODE: {
                    Closure cl;
                    Datum d81 = (Datum)m.dataStk.pop();
                    Datum d82 = (Datum)m.dataStk.pop();
                    if (!(d81 instanceof EnvironmentObject)) {
                        throw this.message.getError("err.environment");
                    }
                    EnvironmentObject eo = (EnvironmentObject)d81;
                    if (eo.isInherit()) {
                        cl = this.makeEval(d82, eo.getEnvironment(), m);
                        m.push(addr, code, env, cl);
                        env = new Environment(cl.getEnvironment());
                        code = cl.getCode();
                        addr = 0;
                        continue block32;
                    }
                    cl = this.makeEval(d82, eo.getEnvironment(), m);
                    m.dataStk.push(this.exec(cl.getCode(), eo.getEnvironment(), this.newMemento()));
                    ++addr;
                    continue block32;
                }
                case OVERRIDE_LOAD_CODE: {
                    Datum d84 = (Datum)m.dataStk.pop();
                    if (d84 instanceof InputPort) {
                        InputPort ipt = (InputPort)d84;
                        try {
                            ClosureClass clc = this.makeLoad(ipt, env, m);
                            code = clc.getCode();
                            addr = 0;
                            continue block32;
                        }
                        catch (LispException e) {
                            ipt.close();
                            throw e;
                        }
                    }
                    throw this.message.getError("err.require.iport");
                }
            }
        }
    }

    @Override
    public Datum exec(CompiledCode code1, Environment env1, IntStack memento) {
        return this.exec(code1, env1, memento, true);
    }

    @Override
    public IntStack newMemento() {
        return new Memento();
    }

    private class Memento
    implements IntStack {
        private Stack<Integer> addrStk = new Stack();
        private Stack<CompiledCode> codeStk = new Stack();
        private Stack<Environment> envStk = new Stack();
        private Stack<Datum> dataStk = new Stack();
        private Stack<ConsListBuilder> workStk = new Stack();
        private Stack<Datum> callerStk = new Stack();
        private Stack<Promise> memoStk = new Stack();
        private CompiledCode aftret = new CompiledCode();

        private Memento() {
        }

        public Memento copy() {
            Memento r = new Memento();
            r.addrStk.addAll(this.addrStk);
            r.codeStk.addAll(this.codeStk);
            r.dataStk.addAll(this.dataStk);
            r.callerStk.addAll(this.callerStk);
            r.memoStk.addAll(this.memoStk);
            for (ConsListBuilder l : this.workStk) {
                r.workStk.add(new ConsListBuilder(l, CodeExecutorImpl.this.message));
            }
            for (Environment e : this.envStk) {
                r.envStk.add(e.copyNotRoot());
            }
            return r;
        }

        private void overwrite(Memento m) {
            this.addrStk = m.addrStk;
            this.codeStk = m.codeStk;
            this.envStk = m.envStk;
            this.dataStk = m.dataStk;
            this.workStk = m.workStk;
            this.callerStk = m.callerStk;
            this.memoStk = m.memoStk;
        }

        private void push(int addr, CompiledCode code, Environment env, Datum callee) {
            this.addrStk.push(addr);
            this.codeStk.push(code);
            this.envStk.push(env);
            this.callerStk.push(callee);
            this.memoStk.push(null);
        }

        private void push(int addr, CompiledCode code, Environment env, Promise p) {
            this.addrStk.push(addr);
            this.codeStk.push(code);
            this.envStk.push(env);
            this.callerStk.push(p);
            this.memoStk.push(p);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append(this.addrStk.size()).append(" , ");
            bld.append(this.codeStk.size()).append(" , ");
            bld.append(this.envStk.size()).append(" , ");
            bld.append(this.dataStk.size()).append(" , ");
            bld.append(this.workStk.size()).append(" , ");
            bld.append(this.callerStk.size()).append(" , ");
            bld.append(this.memoStk.size()).append(" , ");
            bld.append(this.addrStk).append("\n");
            bld.append(this.envStk).append("\n");
            bld.append(this.dataStk).append("\n");
            bld.append(this.workStk).append("\n");
            bld.append(this.callerStk).append("\n");
            bld.append(this.memoStk).append("\n");
            return bld.toString();
        }

        private void desc(StringBuilder buf, Datum d) {
            if (d instanceof Subr) {
                Subr s = (Subr)d;
                if (s.symbolName != null && !s.symbolName.equals("error")) {
                    buf.append("  -");
                    buf.append(CodeExecutorImpl.this.message.get("err.stacktrace.subr"));
                    buf.append(" ");
                    buf.append(s.symbolName);
                    buf.append("\n");
                }
            } else if (d instanceof Closure) {
                Closure c = (Closure)d;
                if (c.getName() != null) {
                    buf.append("  -");
                    buf.append(CodeExecutorImpl.this.message.get("err.stacktrace.closure"));
                    buf.append(" ");
                    buf.append(c.getName());
                    buf.append("\n");
                }
            } else if (d instanceof Promise) {
                Promise p = (Promise)d;
                buf.append("  -");
                buf.append(CodeExecutorImpl.this.message.get("err.stacktrace.promise"));
                buf.append(" ");
                buf.append(Integer.toString(p.hashCode(), 16));
                buf.append("\n");
            } else {
                buf.append("  -");
                buf.append(LispUtils.toDisplay(d));
                buf.append("\n");
            }
        }

        @Override
        public String getStackTrace() {
            StringBuilder buf = new StringBuilder();
            int i = this.callerStk.size() - 1;
            while (i >= 0) {
                this.desc(buf, (Datum)this.callerStk.get(i));
                --i;
            }
            return buf.toString();
        }
    }
}

