/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.awt.robot;

import java.awt.AWTException;
import java.awt.GraphicsDevice;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.awt.env.LispGraphicsDevice;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/04/05
 */
public class MakeGuiRobot extends Subr {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Subr#eval(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	public Datum eval(Datum body, Environment env, LispMessage mesg) {
		ConsIterator itr = new ConsIterator(body);
		Datum d = Iterators.nextIf(itr);
		GraphicsDevice dev;

		SubrUtils.checkTerminated(itr, body, mesg);
		if(d == null) {
			dev = null;
		} else if(d instanceof LispGraphicsDevice) {
			dev = ((LispGraphicsDevice)d).getDevice();
		} else {
			throw mesg.getError("err.awt.require.graphicsdevice", d);
		}

		try {
			return new LispRobot(dev);
		} catch (AWTException e) {
			throw mesg.getError("err.awt.robot.notavailable");
		}
	}

}
