/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.math.stat.test;

import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.math.stat.dist.continuous.GammaDistribution;
import net.morilib.util.primitive.DoubleArrayVector;
import net.morilib.util.primitive.DoubleVector;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/02/22
 */
public class IsTestFitChiSquared extends TernaryArgs {

	//
	private void todouble(ConsIterator itr, DoubleVector v,
			LispMessage mesg) {
		while(itr.hasNext()) {
			v.addDouble(SubrUtils.getDouble(itr.next(), mesg));
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.QuaternaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Datum c1a, Datum c2a, Datum c3a,
			Environment env, LispMessage mesg) {
		GammaDistribution dis;
		DoubleVector obs, exp;
		double alf, chi = 0, x;
		int i = 0;

		obs = new DoubleArrayVector();
		exp = new DoubleArrayVector();
		todouble(new ConsIterator(c1a), obs, mesg);
		todouble(new ConsIterator(c2a), exp, mesg);
		alf = SubrUtils.getDouble(c3a, mesg);

		for(; i < obs.size() && i < exp.size(); i++) {
			x    = obs.getDouble(i) - exp.getDouble(i);
			chi += x * x / exp.getDouble(i);
		}
		dis = GammaDistribution.chiSquared(i);
		return LispBoolean.getInstance(chi < dis.invCdf(1 - alf));
	}

}
