/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.chihaya;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.BinaryArgs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/03/01
 */
public class IsFreeIdentifierEq72 extends BinaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.BinaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Datum c1a, Datum c2a, Environment env,
			LispMessage mesg) {
		LispSyntax s1, s2;

		if(c1a instanceof LispSyntax && c2a instanceof LispSyntax) {
			s1 = (LispSyntax)c1a;
			s2 = (LispSyntax)c2a;
			return LispBoolean.getInstance(
					s1.getWrapped() instanceof Symbol &&
					s2.getWrapped() instanceof Symbol &&
					!((Symbol)s1.getWrapped()).isMacroBound() &&
					!((Symbol)s2.getWrapped()).isMacroBound() &&
					env.findDatum(s1.getWrapped()) == null &&
					env.findDatum(s2.getWrapped()) == null &&
					s1.getWrapped().equals(s2.getWrapped()));
		} else {
			return LispBoolean.FALSE;
		}
	}

}
