/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import net.morilib.lisp.subr.UnaryArgs;

public class SubrNullEnvironment extends UnaryArgs {
	
	//
	private LispInteger VER_5 = LispInteger.valueOf(5);
	
	
	@Override
	protected Datum execute(
			Datum c1a, Environment env, LispMessage mesg) {
		if(VER_5.isEqv(c1a)) {
			return EnvironmentObject.newNullEnv(5);
		} else {
			throw mesg.getError("err.version.invalid", c1a);
			//throw new LispException("invalid version number");
		}
	}

}
