/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lingua;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2012/05/22
 */
public class Gender {

	//
	private static final int _MUSCULINE   = 0x1;
	private static final int _FEMININE    = 0x2;
	private static final int _NEUTER      = 0x4;
	private static final int _COMMON      = 0x8;
	private static final int _ANIMATED    = 0x10;
	private static final int _INANIMATED  = 0x20;
	private static final int _PERSONAL    = 0x40;
	private static final int _PERSONS     = 0x100;
	private static final int _PLANTS      = 0x200;
	private static final int _GROUPS      = 0x300;
	private static final int _ARTEFACTS   = 0x400;
	private static final int _ANIMALS     = 0x500;
	private static final int _EXTENSION   = 0x600;
	private static final int _ABSTRACTION = 0x700;

	/**
	 * 
	 */
	public static final Gender MUSCULINE = new Gender(_MUSCULINE);

	/**
	 * 
	 */
	public static final Gender FEMININE = new Gender(_FEMININE);

	/**
	 * 
	 */
	public static final Gender NEUTER = new Gender(_NEUTER);

	/**
	 * 
	 */
	public static final Gender COMMON = new Gender(_COMMON);

	/**
	 * 
	 */
	public static final Gender ANIMATED = new Gender(_ANIMATED);

	/**
	 * 
	 */
	public static final Gender INANIMATED = new Gender(_INANIMATED);

	/**
	 * 
	 */
	public static final Gender MUSCULINE_ANIMATED =
		new Gender(_MUSCULINE | _ANIMATED);

	/**
	 * 
	 */
	public static final Gender MUSCULINE_INANIMATED =
		new Gender(_MUSCULINE | _INANIMATED);

	/**
	 * 
	 */
	public static final Gender MUSCULINE_PERSONAL =
		new Gender(_MUSCULINE | _PERSONAL);

	/**
	 * 
	 */
	public static final Gender PERSONS = new Gender(_PERSONS);

	/**
	 * 
	 */
	public static final Gender PLANTS = new Gender(_PLANTS);

	/**
	 * 
	 */
	public static final Gender GROUPS = new Gender(_GROUPS);

	/**
	 * 
	 */
	public static final Gender ARTEFACTS = new Gender(_ARTEFACTS);

	/**
	 * 
	 */
	public static final Gender ANIMALS = new Gender(_ANIMALS);

	/**
	 * 
	 */
	public static final Gender EXTENSION = new Gender(_EXTENSION);

	/**
	 * 
	 */
	public static final Gender ABSTRACTION = new Gender(_ABSTRACTION);

	//
	private int gender;

	//
	private Gender(int x) {
		gender = x;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isMusculine() {
		return (gender & _MUSCULINE) != 0;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isFeminine() {
		return (gender & _FEMININE) != 0;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isNeuter() {
		return (gender & _NEUTER) != 0;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isCommon() {
		return (gender & _COMMON) != 0;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isAnimated() {
		return (gender & _ANIMATED) != 0;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isInanimated() {
		return (gender & _INANIMATED) != 0;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isPersonal() {
		return (gender & _PERSONAL) != 0;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isPersons() {
		return (gender & 0x700) == _PERSONS;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isPlants() {
		return (gender & 0x700) == _PLANTS;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isGroups() {
		return (gender & 0x700) == _GROUPS;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isArtefacts() {
		return (gender & 0x700) == _ARTEFACTS;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isAnimals() {
		return (gender & 0x700) == _ANIMALS;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isExtension() {
		return (gender & 0x700) == _EXTENSION;
	}

	/**
	 * 
	 * @return
	 */
	public boolean isAbstraction() {
		return (gender & 0x700) == _ABSTRACTION;
	}

}
