/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.lib.srfi001;

import java.util.HashSet;
import java.util.Set;

import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.subr.UnaryArgs;

public class IsDottedList extends UnaryArgs {

	@Override
	protected Datum execute(
			Datum c1a, Environment env, LispMessage mesg) {
		Datum dd = c1a;
		Set<Datum> jn = new HashSet<Datum>();
		
		while(dd != Nil.NIL) {
			if(dd instanceof Cons) {
				if(jn.contains(dd)) {
					// circular list
					return LispBoolean.FALSE;
				}
				jn.add(dd);
				dd = ((Cons)dd).getCdr();
			} else {
				return LispBoolean.TRUE;
			}
		}
		return LispBoolean.FALSE;
	}

}
