/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.morilib.util.primitive.AbstractDoubleCollection;
import net.morilib.util.primitive.AbstractDoubleVector;
import net.morilib.util.primitive.DoubleCollection;
import net.morilib.util.primitive.DoubleList;
import net.morilib.util.primitive.DoubleSet;
import net.morilib.util.primitive.DoubleSortedSet;
import net.morilib.util.primitive.DoubleVector;
import net.morilib.util.primitive.iterator.DoubleIterator;
import net.morilib.util.primitive.iterator.DoubleIterators;
import net.morilib.util.primitive.iterator.DoubleVectorIterator;

public final class DoubleCollections {
    public static final DoubleSet EMPTY_SET = new _EmptyS();
    public static final DoubleSortedSet EMPTY_SORTED_SET = new _EmptyS();
    public static final DoubleVector EMPTY_VECTOR = new _EmptyV();

    private DoubleCollections() {
    }

    public static DoubleCollection unmodifiableCollection(DoubleCollection c) {
        return c instanceof UnmodifiableCol ? c : new UnmodifiableCol(c);
    }

    public static DoubleSet unmodifiableSet(DoubleSet set) {
        return set instanceof UnmodifiableSet ? set : new UnmodifiableSet(set);
    }

    public static DoubleSortedSet unmodifiableSortedSet(DoubleSortedSet set) {
        return set instanceof UnmodifiableSSet ? set : new UnmodifiableSSet(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableCol
    extends AbstractDoubleCollection {
        DoubleCollection wrapee;

        UnmodifiableCol(DoubleCollection s) {
            this.wrapee = s;
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllDouble(DoubleCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllDouble(DoubleCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllDouble(Collection<? extends DoubleCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsDouble(double v) {
            return this.wrapee.contains(v);
        }

        @Override
        public boolean containsAllDouble(DoubleCollection a) {
            return this.wrapee.containsAllDouble(a);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapee.isEmpty();
        }

        @Override
        public DoubleIterator doubleIterator() {
            return new Itr(this.wrapee.doubleIterator());
        }

        @Override
        public boolean removeDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllDouble(DoubleCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllDouble(DoubleCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.wrapee.size();
        }

        @Override
        public double[] toDoubleArray() {
            return this.wrapee.toDoubleArray();
        }

        @Override
        public double[] toDoubleArray(double[] a) {
            return this.wrapee.toDoubleArray(a);
        }

        @Override
        public boolean isInfinite() {
            return this.wrapee.isInfinite();
        }

        @Override
        public DoubleSet toSet() {
            return this.wrapee.toSet();
        }

        private static class Itr
        implements DoubleIterator {
            private DoubleIterator itr;

            private Itr(DoubleIterator itr) {
                this.itr = itr;
            }

            public boolean hasNext() {
                return this.itr.hasNext();
            }

            public double next() {
                return this.itr.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class UnmodifiableSSet
    extends UnmodifiableSet
    implements DoubleSortedSet {
        UnmodifiableSSet(DoubleCollection s) {
            super(s);
        }

        public DoubleSortedSet collect(DoubleSortedSet set) {
            return ((DoubleSortedSet)this.wrapee).collect(set);
        }

        public double first() {
            return ((DoubleSortedSet)this.wrapee).first();
        }

        public DoubleSortedSet headSet(double v) {
            return DoubleCollections.unmodifiableSortedSet(((DoubleSortedSet)this.wrapee).headSet(v));
        }

        public DoubleSortedSet subSet(double s, double e) {
            return DoubleCollections.unmodifiableSortedSet(((DoubleSortedSet)this.wrapee).subSet(s, e));
        }

        public DoubleSortedSet tailSet(double v) {
            return DoubleCollections.unmodifiableSortedSet(((DoubleSortedSet)this.wrapee).tailSet(v));
        }

        public double last() {
            return ((DoubleSortedSet)this.wrapee).last();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCol
    implements DoubleSet {
        UnmodifiableSet(DoubleCollection s) {
            super(s);
        }

        public DoubleSet collect(DoubleSet set) {
            return ((DoubleSet)this.wrapee).collect(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _Empty
    extends AbstractDoubleCollection {
        private _Empty() {
        }

        @Override
        public boolean addDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllDouble(DoubleCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllDouble(DoubleCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllDouble(Collection<? extends DoubleCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsDouble(double v) {
            return false;
        }

        @Override
        public boolean containsAllDouble(DoubleCollection a) {
            return a.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean removeDouble(double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllDouble(DoubleCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllDouble(DoubleCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DoubleIterator doubleIterator() {
            return new DoubleIterator(){

                public boolean hasNext() {
                    return false;
                }

                public double next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isInfinite() {
            return true;
        }
    }

    private static class _EmptyS
    extends _Empty
    implements DoubleSortedSet {
        private _EmptyS() {
        }

        public DoubleSet collect(DoubleSet set) {
            return this;
        }

        public DoubleSortedSet collect(DoubleSortedSet set) {
            return this;
        }

        public double first() {
            throw new NoSuchElementException();
        }

        public DoubleSortedSet headSet(double v) {
            return this;
        }

        public DoubleSortedSet subSet(double s, double e) {
            return this;
        }

        public DoubleSortedSet tailSet(double v) {
            return this;
        }

        public double last() {
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _EmptyV
    extends AbstractDoubleVector
    implements Serializable {
        private static final long serialVersionUID = 1540238742681016912L;
        private static final _Itr ITR = new _Itr();

        private _EmptyV() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public double first() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Double> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Double set(int index, Double element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Double element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public ListIterator<Double> listIterator() {
            return ITR;
        }

        @Override
        public ListIterator<Double> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.listIterator();
        }

        @Override
        public List<Double> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public void addDouble(int index, double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllDouble(int index, DoubleCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double getDouble(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOfDouble(double v) {
            return -1;
        }

        @Override
        public int indexOf(int v) {
            return -1;
        }

        @Override
        public double removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DoubleList rest() {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public DoubleList rest(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public double setDouble(int index, double v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public double set(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOfDouble(double v) {
            return -1;
        }

        @Override
        public DoubleVectorIterator doubleVectorIterator() {
            return DoubleIterators.NULL_ITERATOR;
        }

        @Override
        public DoubleVectorIterator doubleVectorIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.doubleVectorIterator();
        }

        @Override
        public DoubleVector subVector(int start, int end) {
            if (start != 0 || end != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class _Itr
        implements ListIterator<Double> {
            private _Itr() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Double next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            @Override
            public Double previous() {
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Double e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Double e) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

