/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.morilib.util.primitive.AbstractByteCollection;
import net.morilib.util.primitive.AbstractByteSet;
import net.morilib.util.primitive.AbstractByteVector;
import net.morilib.util.primitive.ByteBitSet;
import net.morilib.util.primitive.ByteCollection;
import net.morilib.util.primitive.ByteList;
import net.morilib.util.primitive.ByteSet;
import net.morilib.util.primitive.ByteSortedSet;
import net.morilib.util.primitive.ByteVector;
import net.morilib.util.primitive.iterator.ByteIterator;
import net.morilib.util.primitive.iterator.ByteIterators;
import net.morilib.util.primitive.iterator.ByteVectorIterator;

public final class ByteCollections {
    public static final ByteSet EMPTY_SET = new _EmptyS();
    public static final ByteSortedSet EMPTY_SORTED_SET = new _EmptyS();
    public static final ByteVector EMPTY_VECTOR = new _EmptyV();

    private ByteCollections() {
    }

    public static ByteCollection unmodifiableCollection(ByteCollection c) {
        return c instanceof UnmodifiableCol ? c : new UnmodifiableCol(c);
    }

    public static ByteSet unmodifiableSet(ByteSet set) {
        return set instanceof UnmodifiableSet ? set : new UnmodifiableSet(set);
    }

    public static ByteSortedSet unmodifiableSortedSet(ByteSortedSet set) {
        return set instanceof UnmodifiableSSet ? set : new UnmodifiableSSet(set);
    }

    public static ByteSortedSet interval(byte f, byte t) {
        if (f > t) {
            throw new IllegalArgumentException();
        }
        return new Intv(f, t);
    }

    private static class Intv
    extends AbstractByteSet
    implements ByteSortedSet {
        private byte f;
        private byte t;

        private Intv(byte f, byte t) {
            this.f = f;
            this.t = t;
        }

        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        public boolean addAllByte(ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        public boolean removeByte(byte v) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAllByte(ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAllByte(ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        public ByteIterator byteIterator() {
            return new ByteIterator(){
                private byte ptr;
                {
                    this.ptr = Intv.this.f;
                }

                public boolean hasNext() {
                    return this.ptr <= Intv.this.t;
                }

                public byte next() {
                    byte by = this.ptr;
                    this.ptr = (byte)(by + 1);
                    return by;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int size() {
            return this.t - this.f + 1;
        }

        public ByteSortedSet collect(ByteSortedSet set) {
            ByteBitSet r = new ByteBitSet(this);
            r.removeAllByte(set);
            return ByteCollections.unmodifiableSortedSet(r);
        }

        public byte first() {
            return this.f;
        }

        public ByteSortedSet headSet(byte v) {
            if (v <= this.f) {
                return EMPTY_SORTED_SET;
            }
            if (v <= this.t) {
                v = (byte)(v - 1);
                return new Intv(this.f, v);
            }
            return this;
        }

        public ByteSortedSet subSet(byte s, byte e) {
            byte e2;
            if (s > e) {
                throw new IllegalArgumentException();
            }
            if (e == -128) {
                return EMPTY_SORTED_SET;
            }
            e = (byte)(e - 1);
            byte s2 = s < this.f ? this.f : s;
            byte by = e2 = e > this.t ? this.t : e;
            if (s > this.t || e < this.f) {
                return EMPTY_SORTED_SET;
            }
            return new Intv(s2, e2);
        }

        public ByteSortedSet tailSet(byte v) {
            if (v > this.t) {
                return EMPTY_SORTED_SET;
            }
            if (v > this.f) {
                return new Intv(v, this.t);
            }
            return this;
        }

        public byte last() {
            return this.t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnmodifiableCol
    extends AbstractByteCollection {
        ByteCollection wrapee;

        UnmodifiableCol(ByteCollection s) {
            this.wrapee = s;
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllByte(ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllByte(ByteCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllByte(Collection<? extends ByteCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsByte(byte v) {
            return this.wrapee.contains(v);
        }

        @Override
        public boolean containsAllByte(ByteCollection a) {
            return this.wrapee.containsAllByte(a);
        }

        @Override
        public boolean isEmpty() {
            return this.wrapee.isEmpty();
        }

        @Override
        public ByteIterator byteIterator() {
            return new Itr(this.wrapee.byteIterator());
        }

        @Override
        public boolean removeByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllByte(ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllByte(ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.wrapee.size();
        }

        @Override
        public byte[] toByteArray() {
            return this.wrapee.toByteArray();
        }

        @Override
        public byte[] toByteArray(byte[] a) {
            return this.wrapee.toByteArray(a);
        }

        @Override
        public boolean isInfinite() {
            return this.wrapee.isInfinite();
        }

        @Override
        public ByteSet toSet() {
            return this.wrapee.toSet();
        }

        private static class Itr
        implements ByteIterator {
            private ByteIterator itr;

            private Itr(ByteIterator itr) {
                this.itr = itr;
            }

            public boolean hasNext() {
                return this.itr.hasNext();
            }

            public byte next() {
                return this.itr.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class UnmodifiableSSet
    extends UnmodifiableSet
    implements ByteSortedSet {
        UnmodifiableSSet(ByteCollection s) {
            super(s);
        }

        public ByteSortedSet collect(ByteSortedSet set) {
            return ((ByteSortedSet)this.wrapee).collect(set);
        }

        public byte first() {
            return ((ByteSortedSet)this.wrapee).first();
        }

        public ByteSortedSet headSet(byte v) {
            return ByteCollections.unmodifiableSortedSet(((ByteSortedSet)this.wrapee).headSet(v));
        }

        public ByteSortedSet subSet(byte s, byte e) {
            return ByteCollections.unmodifiableSortedSet(((ByteSortedSet)this.wrapee).subSet(s, e));
        }

        public ByteSortedSet tailSet(byte v) {
            return ByteCollections.unmodifiableSortedSet(((ByteSortedSet)this.wrapee).tailSet(v));
        }

        public byte last() {
            return ((ByteSortedSet)this.wrapee).last();
        }
    }

    static class UnmodifiableSet
    extends UnmodifiableCol
    implements ByteSet {
        UnmodifiableSet(ByteCollection s) {
            super(s);
        }

        public ByteSet collect(ByteSet set) {
            return ((ByteSet)this.wrapee).collect(set);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _Empty
    extends AbstractByteCollection {
        private _Empty() {
        }

        @Override
        public boolean addByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllByte(ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllByte(ByteCollection ... as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllByte(Collection<? extends ByteCollection> as) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsByte(byte v) {
            return false;
        }

        @Override
        public boolean containsAllByte(ByteCollection a) {
            return a.isEmpty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean removeByte(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAllByte(ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAllByte(ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteIterator byteIterator() {
            return new ByteIterator(){

                public boolean hasNext() {
                    return false;
                }

                public byte next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isInfinite() {
            return true;
        }
    }

    private static class _EmptyS
    extends _Empty
    implements ByteSortedSet {
        private _EmptyS() {
        }

        public ByteSet collect(ByteSet set) {
            return this;
        }

        public ByteSortedSet collect(ByteSortedSet set) {
            return this;
        }

        public byte first() {
            throw new NoSuchElementException();
        }

        public ByteSortedSet headSet(byte v) {
            return this;
        }

        public ByteSortedSet subSet(byte s, byte e) {
            return this;
        }

        public ByteSortedSet tailSet(byte v) {
            return this;
        }

        public byte last() {
            throw new NoSuchElementException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _EmptyV
    extends AbstractByteVector
    implements Serializable {
        private static final long serialVersionUID = 1540238742681016912L;
        private static final _Itr ITR = new _Itr();

        private _EmptyV() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public byte first() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends Byte> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Byte get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Byte set(int index, Byte element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, Byte element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Byte remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return -1;
        }

        @Override
        public ListIterator<Byte> listIterator() {
            return ITR;
        }

        @Override
        public ListIterator<Byte> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.listIterator();
        }

        @Override
        public List<Byte> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public void addByte(int index, byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAllByte(int index, ByteCollection a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte getByte(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOfByte(byte v) {
            return -1;
        }

        @Override
        public int indexOf(int v) {
            return -1;
        }

        @Override
        public byte removeAt(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteList rest() {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public ByteList rest(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public byte setByte(int index, byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte set(int index, int v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOfByte(byte v) {
            return -1;
        }

        @Override
        public ByteVectorIterator byteVectorIterator() {
            return ByteIterators.NULL_ITERATOR;
        }

        @Override
        public ByteVectorIterator byteVectorIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.byteVectorIterator();
        }

        @Override
        public ByteVector subVector(int start, int end) {
            if (start != 0 || end != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class _Itr
        implements ListIterator<Byte> {
            private _Itr() {
            }

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Byte next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            @Override
            public Byte previous() {
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Byte e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Byte e) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

