/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.mapset;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.util.Pair;
import net.morilib.util.Tuple2;
import net.morilib.util.datafactory.DataFactories;
import net.morilib.util.datafactory.SetFactory;
import net.morilib.util.mapset.ManyToManySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedManyToManySet<K, V>
extends AbstractSet<Pair<K, V>>
implements ManyToManySet<K, V> {
    private SetFactory factory;
    private Map<K, Set<V>> keyindex = new HashMap<K, Set<V>>();
    private transient Map<V, Set<K>> valueindex = new HashMap<V, Set<K>>();
    private volatile transient int modCount = 0;

    public IndexedManyToManySet() {
        this.factory = DataFactories.HASH_SET;
    }

    @Override
    public boolean contains(Object k, Object v) {
        return this.keyindex.containsKey(k) && this.keyindex.get(k).contains(v);
    }

    @Override
    public boolean containsKey(Object k) {
        return this.keyindex.containsKey(k);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.valueindex.containsKey(v);
    }

    @Override
    public Set<V> getValues(Object k) {
        Set<V> r = this.keyindex.get(k);
        if (r == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(r);
    }

    @Override
    public Set<K> getKeys(Object v) {
        Set<K> r = this.valueindex.get(v);
        if (r == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(r);
    }

    @Override
    public Set<K> keySet() {
        return this.keyindex.keySet();
    }

    @Override
    public Set<V> valueSet() {
        return this.valueindex.keySet();
    }

    @Override
    public Pair<K, V> put(K k, V v) {
        Set<Object> vs = this.keyindex.get(k);
        ++this.modCount;
        if (vs == null) {
            vs = this.factory.newInstance();
            this.keyindex.put(k, vs);
        }
        Tuple2<K, V> res = vs.add(v) ? new Tuple2<K, V>(k, v) : null;
        Set<Object> ks = this.valueindex.get(v);
        if (ks == null) {
            ks = this.factory.newInstance();
            this.valueindex.put((Set<K>)v, (Set<V>)ks);
        }
        ks.add(k);
        return res;
    }

    @Override
    public boolean put(Set<K> ks, Set<V> vs) {
        boolean r = false;
        for (K k : ks) {
            for (V v : vs) {
                r = this.put(k, v) != null | r;
            }
        }
        return r;
    }

    @Override
    public boolean remove(Object k, Object v) {
        Set<V> vs = this.keyindex.get(k);
        if (vs != null && vs.contains(v)) {
            vs.remove(v);
            if (vs.isEmpty()) {
                this.keyindex.remove(k);
                this.valueindex.get(v).remove(k);
                if (this.valueindex.get(v).isEmpty()) {
                    this.valueindex.remove(v);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeKey(Object k) {
        Set<V> vs = this.keyindex.get(k);
        ++this.modCount;
        if (this.keyindex.containsKey(k)) {
            this.keyindex.remove(k);
            for (V v : vs) {
                Set<K> ks = this.valueindex.get(v);
                ks.remove(k);
                if (!ks.isEmpty()) continue;
                this.valueindex.remove(v);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeValue(Object v) {
        Set<K> ks = this.valueindex.get(v);
        ++this.modCount;
        if (this.valueindex.containsKey(v)) {
            this.valueindex.remove(v);
            for (K k : ks) {
                Set<V> vs = this.keyindex.get(k);
                vs.remove(k);
                if (!vs.isEmpty()) continue;
                this.keyindex.remove(k);
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int res = 0;
        for (Set<V> vs : this.keyindex.values()) {
            res += vs.size();
        }
        return res;
    }

    @Override
    public boolean isEmpty() {
        return this.keyindex.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Pair) {
            this.contains(((Pair)o).getA(), ((Pair)o).getB());
        }
        return false;
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return new Iterator<Pair<K, V>>(){
            private Iterator<Map.Entry<K, Set<V>>> iter;
            private Iterator<V> iter2;
            private K curK;
            private V curV;
            private int expectedModCount;
            {
                this.iter = IndexedManyToManySet.this.keyindex.entrySet().iterator();
                this.iter2 = null;
                this.curK = null;
                this.curV = null;
                this.expectedModCount = IndexedManyToManySet.this.modCount;
            }

            @Override
            public boolean hasNext() {
                return this.iter2 != null && this.iter2.hasNext() || this.iter.hasNext();
            }

            @Override
            public Pair<K, V> next() {
                if (this.expectedModCount != IndexedManyToManySet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.iter2 == null || !this.iter2.hasNext()) {
                    Map.Entry e0 = this.iter.next();
                    this.curK = e0.getKey();
                    this.iter2 = e0.getValue().iterator();
                }
                Object n = this.iter2.next();
                this.curV = n;
                return new Tuple2(this.curK, n);
            }

            @Override
            public void remove() {
                if (this.curV == null) {
                    throw new IllegalStateException();
                }
                if (this.expectedModCount != IndexedManyToManySet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                IndexedManyToManySet.this.remove(this.curK, this.curV);
                this.expectedModCount = IndexedManyToManySet.this.modCount;
            }
        };
    }

    @Override
    public boolean add(Pair<K, V> e) {
        ++this.modCount;
        return this.put(e.getA(), e.getB()) != null;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Pair) {
            return this.remove(((Pair)o).getA(), ((Pair)o).getB());
        }
        return false;
    }

    @Override
    public void clear() {
        this.keyindex.clear();
        this.valueindex.clear();
        ++this.modCount;
    }
}

