/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util;

public final class BitUtils {
    private BitUtils() {
    }

    private static int _countBit(long x, int s, int e) {
        if (s == e) {
            return (x & (long)(1 << s)) != 0L ? 1 : 0;
        }
        int c = (e - s) / 2 + s;
        return BitUtils._countBit(x, s, c) + BitUtils._countBit(x, c + 1, e);
    }

    public static int countBit(int x) {
        return BitUtils._countBit(x, 0, 31);
    }

    public static int countBit(long x) {
        return BitUtils._countBit(x, 0, 63);
    }

    private static int _getMsb(long x, int s, int e) {
        if (s == e) {
            return s;
        }
        int c = (e - s >> 1) + s;
        int m = (1 << (e - s >> 1) + 1) - 1 << c;
        if ((x & (long)m) != 0L) {
            return BitUtils._getMsb(x, c + 1, e);
        }
        return BitUtils._getMsb(x, s, c);
    }

    public static int getMsb(int x) {
        return x == 0 ? 0 : BitUtils._getMsb(x, 0, 31);
    }

    public static int getMsb(long x) {
        return x == 0L ? 0 : BitUtils._getMsb(x, 0, 63);
    }

    private static int _getLsb(long x, int s, int e) {
        if (s == e) {
            return s + 1;
        }
        int c = (e - s >> 1) + s;
        int m = (1 << (e - s >> 1) + 1) - 1 << s;
        if ((x & (long)m) != 0L) {
            return BitUtils._getLsb(x, s, c);
        }
        return BitUtils._getLsb(x, c + 1, e);
    }

    public static int getLsb(int x) {
        return x == 0 ? 0 : BitUtils._getLsb(x, 0, 31);
    }

    public static int getLsb(long x) {
        return x == 0L ? 0 : BitUtils._getLsb(x, 0, 63);
    }

    public static long getMask(int bits) {
        if (bits < 0 || bits > 64) {
            throw new IllegalArgumentException();
        }
        if (bits == 0) {
            return 0L;
        }
        if (bits == 64) {
            return -1L;
        }
        if (bits == 63) {
            return Long.MAX_VALUE;
        }
        return (1L << bits + 1) - 1L;
    }

    public static int getIntMask(int bits) {
        if (bits < 0 || bits > 32) {
            throw new IllegalArgumentException();
        }
        if (bits == 0) {
            return 0;
        }
        if (bits == 32) {
            return -1;
        }
        if (bits == 31) {
            return Integer.MAX_VALUE;
        }
        return (1 << bits + 1) - 1;
    }

    public static short getShortMask(int bits) {
        if (bits < 0 || bits > 16) {
            throw new IllegalArgumentException();
        }
        if (bits == 0) {
            return 0;
        }
        if (bits == 16) {
            return -1;
        }
        if (bits == 15) {
            return Short.MAX_VALUE;
        }
        return (short)((1 << bits + 1) - 1);
    }

    public static byte getByteMask(int bits) {
        if (bits < 0 || bits > 8) {
            throw new IllegalArgumentException();
        }
        if (bits == 0) {
            return 0;
        }
        if (bits == 8) {
            return -1;
        }
        if (bits == 7) {
            return 127;
        }
        return (byte)((1 << bits + 1) - 1);
    }
}

