/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.awt.event.AdjustmentListener;
import java.util.List;
import javax.swing.JComponent;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.swing.AdjustmentListenable;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.lisp.swing.LispComponent;
import net.morilib.util.swing.JScrollBar2;

public class LispScrollBar
extends GUIElement
implements LispComponent,
AdjustmentListenable {
    private JScrollBar2 scrollbar;

    public LispScrollBar(JScrollBar2 bar) {
        this.scrollbar = bar;
    }

    public Component getAWTComponent() {
        return this.scrollbar;
    }

    public JComponent getComponent() {
        return this.scrollbar;
    }

    public void addAdjustmentListener(AdjustmentListener l) {
        this.scrollbar.addAdjustmentListener(l);
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<scroll-bar>");
    }

    public static class GetScrollBarRelativeValue
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispScrollBar) {
                return new LispDouble(((LispScrollBar)c1a).scrollbar.getRelativeValue());
            }
            throw mesg.getError("err.swing.require.scrollbar", c1a);
        }
    }

    public static class GetScrollBarValue
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispScrollBar) {
                JScrollBar2 b = ((LispScrollBar)c1a).scrollbar;
                if (b.isRealValued()) {
                    return new LispDouble(b.getRealValue());
                }
                return LispInteger.valueOf(b.getValue());
            }
            throw mesg.getError("err.swing.require.scrollbar", c1a);
        }
    }

    public static class MakeHorizontalScrollBar
    extends MakeScrollBar {
        protected int getOrientation() {
            return 0;
        }
    }

    public static abstract class MakeScrollBar
    extends Subr {
        protected abstract int getOrientation();

        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            double dmin = Double.NaN;
            double dmax = Double.NaN;
            if (l.size() == 6) {
                dmin = SubrUtils.getDouble(l.get(4), mesg);
                dmax = SubrUtils.getDouble(l.get(5), mesg);
            } else if (l.size() != 4) {
                throw mesg.getError("err.argument", body);
            }
            int value = SubrUtils.getSmallIntegerExact(l.get(0), mesg);
            int extent = SubrUtils.getSmallIntegerExact(l.get(1), mesg);
            int min = SubrUtils.getSmallIntegerExact(l.get(2), mesg);
            int max = SubrUtils.getSmallIntegerExact(l.get(3), mesg);
            if (max <= min) {
                throw mesg.getError("err.range.invalid");
            }
            return new LispScrollBar(new JScrollBar2(this.getOrientation(), value, extent, min, max, dmin, dmax));
        }
    }

    public static class MakeVerticalScrollBar
    extends MakeScrollBar {
        protected int getOrientation() {
            return 1;
        }
    }
}

