/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.swing;

import java.awt.Component;
import java.util.List;
import javax.swing.JOptionPane;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.swing.GUIElement;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;

public class LispOptionPane {
    private static final OneToOneSet<Symbol, Integer> _MESSAGETYPE = new HashOneToOneSet<Symbol, Integer>({Symbol.getSymbol("error"), 0}, {Symbol.getSymbol("information"), 1}, {Symbol.getSymbol("warning"), 2}, {Symbol.getSymbol("question"), 3}, {Symbol.getSymbol("plain"), -1});

    private static Datum toYesNoCancel(int res) {
        switch (res) {
            case 0: {
                return LispBoolean.TRUE;
            }
            case 1: {
                return LispBoolean.FALSE;
            }
            case 2: {
                return Symbol.getSymbol("canceled");
            }
        }
        throw new RuntimeException();
    }

    public static abstract class ShowConfirmDialog
    extends Subr {
        protected abstract Datum show(Component var1, Object var2, String var3, int var4, int var5);

        public Datum eval(Datum body, Environment env, LispMessage mesg, int optionType) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() != 4) {
                throw mesg.getError("err.argument", body);
            }
            if (!(l.get(0) instanceof GUIElement) && l.get(0).isTrue()) {
                throw mesg.getError("err.swing.require.component", l.get(0));
            }
            if (!(l.get(2) instanceof LispString)) {
                throw mesg.getError("err.require.string", l.get(2));
            }
            Integer op = (Integer)_MESSAGETYPE.getValue(l.get(3));
            if (op == null) {
                throw mesg.getError("err.swing.invalidmessagetype", l.get(3));
            }
            Component cm = l.get(0).isTrue() ? ((GUIElement)l.get(0)).getAWTComponent() : null;
            return this.show(cm, LispUtils.print(l.get(1)), l.get(2).getString(), optionType, op);
        }
    }

    public static class ShowInputDialog
    extends ShowConfirmDialog {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return this.eval(body, env, mesg, 0);
        }

        protected Datum show(Component cm, Object mes, String title, int optionType, int type) {
            String res = JOptionPane.showInputDialog(cm, mes, title, type);
            return res == null ? LispBoolean.FALSE : new LispString(res);
        }
    }

    public static class ShowMessageDialog
    extends ShowConfirmDialog {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return this.eval(body, env, mesg, 0);
        }

        protected Datum show(Component cm, Object mes, String title, int optionType, int type) {
            JOptionPane.showMessageDialog(cm, mes, title, type);
            return Undef.UNDEF;
        }
    }

    public static class ShowYesNoCancelDialog
    extends ShowConfirmDialog {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return this.eval(body, env, mesg, 1);
        }

        protected Datum show(Component cm, Object mes, String title, int optionType, int type) {
            return LispOptionPane.toYesNoCancel(JOptionPane.showConfirmDialog(cm, mes, title, optionType, type));
        }
    }

    public static class ShowYesNoDialog
    extends ShowConfirmDialog {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return this.eval(body, env, mesg, 0);
        }

        protected Datum show(Component cm, Object mes, String title, int optionType, int type) {
            return LispOptionPane.toYesNoCancel(JOptionPane.showConfirmDialog(cm, mes, title, optionType, type));
        }
    }
}

