/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sos;

import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Keyword;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.sos.LispObject;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.sos.SOS;
import net.morilib.lisp.sos.SlotDatum;
import net.morilib.lisp.util.WeakValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LispClass
extends SlotDatum {
    private static final EnumMap<SlotType, Keyword> KEYWORDS;
    private LispObject metacls;
    private LispType type;
    private Map<Symbol, SlotType> slotinfo = new HashMap<Symbol, SlotType>();
    private Map<Symbol, Datum> slotval = new HashMap<Symbol, Datum>();
    private WeakValues<LispObject> instances = new WeakValues();
    private SOS nsos;
    private int version = 0;
    private LispClass nwklass = null;
    private LispClass oldcls = null;

    static {
        EnumMap<SlotType, Keyword> kw = new EnumMap<SlotType, Keyword>(SlotType.class);
        kw.put(SlotType.SINSTNACE, Keyword.getKeyword("instance"));
        kw.put(SlotType.SCLASS, Keyword.getKeyword("class"));
        kw.put(SlotType.SEACHCLASS, Keyword.getKeyword("each-subclass"));
        KEYWORDS = kw;
    }

    LispClass(SOS nsos, LispType t) {
        super(null);
        if (nsos == null || t == null) {
            throw new NullPointerException();
        }
        this.type = t;
        this.nsos = nsos;
        this.metacls = null;
        this.eachcls();
    }

    LispClass(String name, SOS nsos, LispType t, Collection<Symbol> ins, Collection<Symbol> cls, Collection<Symbol> ecl, LispObject meta) {
        super(name);
        if (nsos == null || t == null) {
            throw new NullPointerException();
        }
        if (ins == null || cls == null || ecl == null) {
            throw new NullPointerException();
        }
        if (meta == null) {
            throw new NullPointerException();
        }
        this.type = t;
        this.nsos = nsos;
        this.metacls = meta;
        for (Symbol e : ins) {
            this.slotinfo.put(e, SlotType.SINSTNACE);
        }
        for (Symbol e : cls) {
            this.slotinfo.put(e, SlotType.SCLASS);
            this.slotval.put(e, Undef.UNDEF);
        }
        for (Symbol e : ecl) {
            this.slotinfo.put(e, SlotType.SEACHCLASS);
            this.slotval.put(e, Undef.UNDEF);
        }
        this.eachcls();
    }

    private void eachcls() {
        HashSet<Symbol> cl = new HashSet<Symbol>();
        List<LispType> cpl = this.type.getCPL();
        for (LispType t : cpl) {
            Map<Symbol, SlotType> inf = t.equals(this.type) ? this.slotinfo : this.nsos.getLispClass((LispType)t).slotinfo;
            for (Map.Entry<Symbol, SlotType> e : inf.entrySet()) {
                if (e.getValue() == SlotType.SEACHCLASS && !cl.contains(e.getKey())) {
                    if (t.equals(this.type)) {
                        this.slotinfo.put(e.getKey(), SlotType.SEACHCLASS);
                    }
                    this.slotval.put(e.getKey(), Undef.UNDEF);
                    continue;
                }
                if (e.getValue() != SlotType.SCLASS && e.getValue() != SlotType.SINSTNACE) continue;
                cl.add(e.getKey());
            }
        }
    }

    public LispType getObjectType() {
        return this.type;
    }

    LispObject getMetaClass() {
        if (this.nsos.cClass == null) {
            throw new IllegalStateException();
        }
        if (this.metacls == null) {
            this.metacls = this.nsos.cClass.instantiate();
        }
        return this.metacls;
    }

    @Override
    public LispType getType() {
        return this.getMetaClass().getType();
    }

    void refreshClass() {
        if (this.nwklass != null) {
            this.metacls = this.nwklass.metacls;
            this.slotinfo = this.nwklass.slotinfo;
            this.slotval = this.nwklass.slotval;
            this.nsos = this.nwklass.nsos;
            this.type = this.nwklass.type;
            this.instances = this.nwklass.instances;
            this.version = this.nwklass.version;
            this.nwklass = null;
        }
    }

    void reinstantiateAll() {
        for (LispObject iss : this.instances.values()) {
            iss.reinstantiate();
        }
    }

    Datum getSlot0(Symbol name) {
        this.refreshClass();
        SlotType t = this.slotinfo.get(name);
        if (t == SlotType.SINSTNACE) {
            return null;
        }
        if (t == SlotType.SCLASS || t == SlotType.SEACHCLASS) {
            return this.slotval.get(name);
        }
        List<LispType> cpl = this.type.getCPL();
        for (LispType e : cpl) {
            Datum v2;
            if (e.equals(this.type)) continue;
            LispClass k = this.nsos.getLispClass(e);
            SlotType t2 = k.slotinfo.get(name);
            if (t2 == SlotType.SCLASS) {
                v2 = k.slotval.get(name);
                if (v2 == null) continue;
                return v2;
            }
            if (t2 == SlotType.SEACHCLASS) {
                v2 = this.slotval.get(name);
                if (v2 == null) continue;
                return v2;
            }
            if (t2 == null) continue;
            return null;
        }
        return null;
    }

    @Override
    public Datum getSlot(Symbol name) {
        Datum res = this.getSlot0(name);
        return res == null ? this.metacls.getSlot(name) : res;
    }

    boolean setSlot0(Symbol name, Datum val) {
        this.refreshClass();
        SlotType t = this.slotinfo.get(name);
        if (t == SlotType.SINSTNACE) {
            return false;
        }
        if (t == SlotType.SCLASS || t == SlotType.SEACHCLASS) {
            this.slotval.put(name, val);
            return true;
        }
        List<LispType> cpl = this.type.getCPL();
        for (LispType e : cpl) {
            if (e.equals(this.type)) continue;
            LispClass k = this.nsos.getLispClass(e);
            SlotType t2 = k.slotinfo.get(name);
            if (t2 == SlotType.SCLASS) {
                if (!k.slotval.containsKey(name)) continue;
                k.slotval.put(name, val);
                return true;
            }
            if (t2 == SlotType.SEACHCLASS) {
                if (!this.slotval.containsKey(name)) continue;
                this.slotval.put(name, val);
                return true;
            }
            if (t2 == null) continue;
            return false;
        }
        return false;
    }

    @Override
    boolean setSlot(Symbol name, Datum val) {
        return this.setSlot0(name, val) ? true : this.metacls.setSlot(name, val);
    }

    public Keyword getSlotKeyword(Symbol name) {
        this.refreshClass();
        SlotType t = this.slotinfo.get(name);
        if (t != null) {
            return KEYWORDS.get((Object)t);
        }
        List<LispType> cpl = this.type.getCPL();
        for (LispType e : cpl) {
            if (e.equals(this.type)) continue;
            LispClass k = this.nsos.getLispClass(e);
            SlotType t2 = k.slotinfo.get(name);
            if (t2 == null) continue;
            return KEYWORDS.get((Object)t2);
        }
        return null;
    }

    private Collection<Symbol> getSlotTypeSlots(SlotType sltp) {
        this.refreshClass();
        HashSet<Symbol> res = new HashSet<Symbol>();
        for (Map.Entry<Symbol, SlotType> e : this.slotinfo.entrySet()) {
            if (e.getValue() != sltp) continue;
            res.add(e.getKey());
        }
        return res;
    }

    public Collection<Symbol> getInstanceSlots() {
        return this.getSlotTypeSlots(SlotType.SINSTNACE);
    }

    public Collection<Symbol> getClassSlots() {
        return this.getSlotTypeSlots(SlotType.SCLASS);
    }

    public Collection<Symbol> getEachClassSlots() {
        return this.getSlotTypeSlots(SlotType.SEACHCLASS);
    }

    LispObject instantiate() {
        this.refreshClass();
        HashMap<Symbol, Datum> in = new HashMap<Symbol, Datum>();
        HashSet<Symbol> cl = new HashSet<Symbol>();
        List<LispType> cpl = this.type.getCPL();
        for (LispType t : cpl) {
            Map<Symbol, SlotType> inf = this.nsos.getLispClass((LispType)t).slotinfo;
            for (Map.Entry<Symbol, SlotType> e : inf.entrySet()) {
                if (e.getValue() == SlotType.SINSTNACE && !cl.contains(e.getKey())) {
                    in.put(e.getKey(), Undef.UNDEF);
                    continue;
                }
                if (e.getValue() != SlotType.SCLASS && e.getValue() != SlotType.SEACHCLASS) continue;
                cl.add(e.getKey());
            }
        }
        LispObject res = new LispObject(this, in);
        this.instances.add(res);
        return res;
    }

    private void eachclsRedef(LispClass rdf) {
        HashSet<Symbol> cl = new HashSet<Symbol>();
        List<LispType> cpl = rdf.type.getCPL();
        for (LispType t : cpl) {
            Map<Symbol, SlotType> inf = t.equals(rdf.type) ? rdf.slotinfo : rdf.nsos.getLispClass((LispType)t).slotinfo;
            for (Map.Entry<Symbol, SlotType> e : inf.entrySet()) {
                if (e.getValue() == SlotType.SEACHCLASS && !cl.contains(e.getKey())) {
                    Datum r2 = this.slotval.get(e.getKey());
                    if (this.slotinfo.get(e.getKey()) != SlotType.SCLASS && r2 != null) {
                        rdf.slotval.put(e.getKey(), r2);
                        continue;
                    }
                    rdf.slotval.put(e.getKey(), Undef.UNDEF);
                    continue;
                }
                if (e.getValue() == SlotType.SCLASS && t.equals(rdf.type)) {
                    if (this.slotinfo.get(e.getKey()) == SlotType.SCLASS) {
                        rdf.slotval.put(e.getKey(), this.slotval.get(e.getKey()));
                    } else {
                        rdf.slotval.put(e.getKey(), Undef.UNDEF);
                    }
                    cl.add(e.getKey());
                    continue;
                }
                if (e.getValue() != SlotType.SINSTNACE) continue;
                cl.add(e.getKey());
            }
        }
    }

    LispClass redefine(LispType t, Collection<Symbol> ins, Collection<Symbol> cls, Collection<Symbol> ecl, Map<Symbol, Datum> vals, LispObject meta) {
        LispClass nwc = new LispClass(this.getName(), this.nsos, t, ins, cls, ecl, meta);
        this.eachclsRedef(nwc);
        for (Symbol e : cls) {
            if (this.slotinfo.get(e) == SlotType.SCLASS) {
                nwc.slotval.put(e, this.slotval.get(e));
                continue;
            }
            if (vals.get(e) == null) continue;
            nwc.slotval.put(e, vals.get(e));
        }
        for (Symbol e : ecl) {
            if (this.slotinfo.get(e) == SlotType.SEACHCLASS) {
                nwc.slotval.put(e, this.slotval.get(e));
                continue;
            }
            if (vals.get(e) == null) continue;
            nwc.slotval.put(e, vals.get(e));
        }
        for (LispObject iss : this.instances.values()) {
            iss.setNewClass(nwc, vals);
        }
        nwc.instances = this.instances;
        ++nwc.version;
        if (this.oldcls == null) {
            this.nwklass = nwc;
        } else {
            this.oldcls.nwklass = nwc;
        }
        nwc.oldcls = this;
        return nwc;
    }

    private boolean isslotinfo(LispClass old, Symbol s) {
        HashSet<Symbol> cl = new HashSet<Symbol>();
        List<LispType> cpl = old.type.getCPL();
        for (LispType t : cpl) {
            Map<Symbol, SlotType> inf = old.nsos.getLispClass((LispType)t).slotinfo;
            for (Map.Entry<Symbol, SlotType> e : inf.entrySet()) {
                if (s.equals(e.getKey()) && e.getValue() == SlotType.SINSTNACE && !cl.contains(e.getKey())) {
                    return true;
                }
                if (e.getValue() != SlotType.SCLASS && e.getValue() != SlotType.SEACHCLASS) continue;
                cl.add(e.getKey());
            }
        }
        return false;
    }

    Map<Symbol, Datum> reinstantiate(Map<Symbol, Datum> oin, Map<Symbol, Datum> vals, LispClass old) {
        HashMap<Symbol, Datum> in = new HashMap<Symbol, Datum>();
        HashSet<Symbol> cl = new HashSet<Symbol>();
        List<LispType> cpl = this.type.getCPL();
        for (LispType t : cpl) {
            Map<Symbol, SlotType> inf = this.nsos.getLispClass((LispType)t).slotinfo;
            for (Map.Entry<Symbol, SlotType> e : inf.entrySet()) {
                if (e.getValue() == SlotType.SINSTNACE && !cl.contains(e.getKey())) {
                    if (this.isslotinfo(old, e.getKey())) {
                        in.put(e.getKey(), oin.get(e.getKey()));
                        continue;
                    }
                    if (vals.get(e.getKey()) != null) {
                        in.put(e.getKey(), vals.get(e.getKey()));
                        continue;
                    }
                    in.put(e.getKey(), Undef.UNDEF);
                    continue;
                }
                if (e.getValue() != SlotType.SCLASS && e.getValue() != SlotType.SEACHCLASS) continue;
                cl.add(e.getKey());
            }
        }
        return in;
    }

    @Override
    public String display() {
        if (this.version > 0) {
            return "#<class " + this.printName() + ">";
        }
        return "#<class " + this.printName() + ">";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SlotType {
        SINSTNACE,
        SCLASS,
        SEACHCLASS;

    }
}

