/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.painter;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import net.morilib.lisp.painter.SchlushFrame;
import net.morilib.lisp.painter.SchlushJPanelFrame;
import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;

public class SchlushWindowFrame
extends SchlushJPanelFrame {
    JFrame frame = new JFrame();
    private boolean disposed = false;

    public SchlushWindowFrame(int x, int y, CoordinateMap coordinate) {
        super(coordinate);
        this.frame.setDefaultCloseOperation(2);
        this.frame.setSize(x, y);
        this.frame.add(this.createPanel());
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
            }

            public void windowClosed(WindowEvent e) {
                SchlushWindowFrame.this.disposed = true;
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
    }

    public SchlushWindowFrame(int x, int y) {
        this(x, y, null);
    }

    protected void loadImage(Image img) throws InterruptedException {
        MediaTracker mt = new MediaTracker(this.frame);
        mt.addImage(img, 1);
        mt.waitForAll();
    }

    public int getHeight() {
        return this.frame.getHeight();
    }

    public int getWidth() {
        return this.frame.getWidth();
    }

    public int getImageWidth(Image img) {
        return img.getWidth(this.frame);
    }

    public int getImageHeight(Image img) {
        return img.getHeight(this.frame);
    }

    public void addImage(SchlushFrame.ImageInfo img) throws InterruptedException {
        if (!this.disposed) {
            super.addImage(img);
        }
    }

    public void addDrawer(Drawer drawer) {
        if (!this.disposed) {
            super.addDrawer(drawer);
        }
    }

    public void clearScreen() {
        if (!this.disposed) {
            super.clearScreen();
        }
    }

    public void repaint() {
        this.frame.repaint();
    }

    public Component getAWTComponent() {
        return this.frame;
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<window-frame>");
    }
}

