/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.morilib.lisp.Closure;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CodeExecutorFactory;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Syntax;
import net.morilib.lisp.SyntaxUtils;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

public class LispFeature {
    private static final BinaryArgs _ADD_FEATURE = new _AddFeature();
    private static ConcurrentHashMap<Datum, CompiledCode> features = new ConcurrentHashMap();

    public static class ApplyFeature
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            CompiledCode cd = (CompiledCode)features.get(c1a);
            if (cd != null) {
                CodeExecutor exe = CodeExecutorFactory.getInstance(mesg);
                exe.exec(cd, env, exe.newMemento());
                return LispBoolean.TRUE;
            }
            return LispBoolean.FALSE;
        }
    }

    public static class IsFeatureExist
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(features.containsKey(c1a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SynDefineFeature
    extends Syntax {
        @Override
        void compile(Datum body, Environment env, LispCompiler comp, CompiledCode.Builder build, boolean toplevel, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
            CompiledCode.Builder nbuild = new CompiledCode.Builder();
            Environment nenv = new Environment(env);
            ClosureClass cl = new ClosureClass();
            ConsIterator itr = new ConsIterator(body);
            Datum sym = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            if (!toplevel) {
                throw mesg.getError("err.nottoplevel");
            }
            if (!(sym instanceof Symbol)) {
                throw mesg.getError("err.require.symbol", sym);
            }
            SyntaxUtils.compileList(itr.rest(), nenv, comp, nbuild, callsym, false, mesg, symlist, exec, memento, syncased);
            cl.setParameterList(Nil.NIL);
            cl.setCode(nbuild.getCodeRef());
            build.addPush(_ADD_FEATURE);
            build.addBeginList();
            build.addPush(sym);
            build.addAppendList();
            build.addPush(cl);
            build.addAppendList();
            build.addEndList();
            build.addCall();
        }

        @Override
        Datum replaceLocalVals(Datum body, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
            throw mesg.getError("err.define.definesyntax");
        }
    }

    private static class _AddFeature
    extends BinaryArgs {
        private _AddFeature() {
        }

        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            features.put(c1a, ((Closure)c2a).getCode());
            return Undef.UNDEF;
        }
    }
}

