/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata.nfa;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.nfa.NFAClosure;
import net.morilib.automata.nfa.NFAObject;
import net.morilib.automata.nfa.NFAState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NFAParenthesis<T, A, B>
extends NFAClosure<T, A, B> {
    private B tag;

    public NFAParenthesis(NFAObject<T, A, B> wrapee, B tag) {
        super(wrapee, false, false);
        this.tag = tag;
    }

    public static <T, A, B> NFAParenthesis<T, A, B> newInstance(NFAObject<T, A, B> wrapee, B tag) {
        return new NFAParenthesis<T, A, B>(wrapee, tag);
    }

    @Override
    public Set<B> getMatchTag(NFAState state) {
        HashSet res = new HashSet();
        res.add(this.tag);
        if (this.wrapee.isState(state)) {
            res.addAll(this.wrapee.getMatchTag(state));
        }
        return Collections.unmodifiableSet(res);
    }

    @Override
    public Set<B> getMatchTagEnd(NFAState state) {
        HashSet res = new HashSet();
        if (this.wrapee.isState(state)) {
            if (this.wrapee.isFinal(state)) {
                res.add(this.tag);
            }
            res.addAll(this.wrapee.getMatchTagEnd(state));
        }
        return Collections.unmodifiableSet(res);
    }
}

