/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.uvector;

import java.util.Arrays;
import net.morilib.lang.Hashes;
import net.morilib.util.Arrays2;
import net.morilib.util.Bytes;
import net.morilib.util.uvector.AbstractUniformArray;
import net.morilib.util.uvector.Endianness;
import net.morilib.util.uvector.UniformArray;

public class ShortArray
extends AbstractUniformArray {
    private short[] array;
    private UniformArray.TypeAttr signed;

    private ShortArray(short[] arr, UniformArray.TypeAttr attr) {
        if (!attr.isExact()) {
            throw new IllegalArgumentException(attr.toString());
        }
        if (arr == null) {
            throw new NullPointerException();
        }
        this.array = new short[arr.length];
        this.signed = attr;
        System.arraycopy(arr, 0, this.array, 0, arr.length);
    }

    public ShortArray(ShortArray a) {
        this.array = Arrays2.copy(a.array);
        this.signed = a.signed;
    }

    public static ShortArray newArray(short[] arr) {
        return new ShortArray(arr, UniformArray.TypeAttr.SIGNED_INT);
    }

    public static ShortArray newuArray(short[] arr) {
        return new ShortArray(arr, UniformArray.TypeAttr.UNSIGNED_INT);
    }

    public static ShortArray malloc(int size) {
        return new ShortArray(new short[size], UniformArray.TypeAttr.SIGNED_INT);
    }

    public static ShortArray mallocu(int size) {
        return new ShortArray(new short[size], UniformArray.TypeAttr.UNSIGNED_INT);
    }

    public byte getByte(int i) {
        short r = this.getShort(i);
        return (byte)r;
    }

    public double getDouble(int i) {
        return this.getInt(i);
    }

    public float getFloat(int i) {
        return this.getInt(i);
    }

    public int getInt(int i) {
        int r = this.getShort(i);
        return this.signed.isSigned() ? r : Bytes.ushortToInt((short)r);
    }

    public long getLong(int i) {
        short r = this.getShort(i);
        return this.signed.isSigned() ? (long)r : Bytes.ushortToLong(r);
    }

    public short getShort(int i) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        return this.array[i];
    }

    public void setByte(int i, byte x) {
        this.setShort(i, this.signed.isSigned() ? x : Bytes.ubyteToShort((byte)x));
    }

    public void setDouble(int i, double x) {
        this.setLong(i, (long)x);
    }

    public void setFloat(int i, float x) {
        this.setDouble(i, x);
    }

    public void setInt(int i, int x) {
        this.setShort(i, (short)x);
    }

    public void setLong(int i, long x) {
        this.setShort(i, (short)x);
    }

    public void setShort(int i, short x) {
        if (i < 0 || i >= this.array.length) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        this.array[i] = x;
    }

    public int size() {
        return this.array.length;
    }

    public byte[] toByteArray(Endianness e) {
        byte[] res = new byte[this.array.length << 1];
        int i = 0;
        while (i < this.array.length) {
            e.writeShort(res, i << 1, this.array[i]);
            ++i;
        }
        return res;
    }

    public short[] toArray() {
        return Arrays2.copy(this.array);
    }

    public int hashCode() {
        return Hashes.sumHashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShortArray) {
            return Arrays.equals(this.array, ((ShortArray)obj).array);
        }
        return false;
    }
}

