/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.mapset;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.util.Objects;
import net.morilib.util.Pair;
import net.morilib.util.Tuple2;
import net.morilib.util.mapset.OneToOneSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashOneToOneSet<K, V>
extends AbstractSet<Pair<K, V>>
implements OneToOneSet<K, V>,
Serializable {
    private static final long serialVersionUID = -336189056797863107L;
    private HashMap<K, V> keyMap = new HashMap();
    private transient HashMap<V, K> valueMap = new HashMap();
    private volatile transient int modCount = 0;

    public HashOneToOneSet() {
    }

    public HashOneToOneSet(Map<K, V> map) {
        for (Map.Entry<K, V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public HashOneToOneSet(Object[] ... objects) {
        int i = 0;
        while (i < objects.length) {
            Object[] os = objects[i];
            if (os.length != 2) {
                throw new IllegalArgumentException();
            }
            this.put(os[0], os[1]);
            ++i;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.keyMap.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Pair) {
            return this.keyMap.containsKey(((Pair)o).getA()) || this.valueMap.containsKey(((Pair)o).getB());
        }
        return false;
    }

    @Override
    public boolean add(Pair<K, V> e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.put(e.getA(), e.getB()) != null;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Pair) {
            return this.remove(((Pair)o).getA(), ((Pair)o).getB());
        }
        return false;
    }

    @Override
    public void clear() {
        this.keyMap.clear();
        this.valueMap.clear();
        ++this.modCount;
    }

    @Override
    public boolean containsKey(Object k) {
        return this.keyMap.containsKey(k);
    }

    @Override
    public boolean containsValue(Object v) {
        return this.valueMap.containsKey(v);
    }

    @Override
    public V getValue(Object k) {
        return this.keyMap.get(k);
    }

    @Override
    public K getKey(Object v) {
        return this.valueMap.get(v);
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.keyMap.keySet());
    }

    @Override
    public Set<V> valueSet() {
        return Collections.unmodifiableSet(this.valueMap.keySet());
    }

    @Override
    public Pair<K, V> put(K k, V v) {
        ++this.modCount;
        V vb = this.keyMap.remove(k);
        K kb = this.valueMap.remove(v);
        this.keyMap.put(k, v);
        this.valueMap.put(v, k);
        if (vb != null) {
            return new Tuple2<K, V>(k, vb);
        }
        if (kb != null) {
            return new Tuple2<K, V>(kb, v);
        }
        return null;
    }

    @Override
    public boolean put(Set<K> ks, Set<V> vs) {
        boolean r = false;
        for (K k : ks) {
            for (V v : vs) {
                r = this.put(k, v) != null | r;
            }
        }
        return r;
    }

    @Override
    public boolean remove(Object k, Object v) {
        V v2;
        ++this.modCount;
        if (this.keyMap.containsKey(k) && Objects.equals(v, v2 = this.keyMap.get(k))) {
            this.keyMap.remove(v);
            this.valueMap.remove(k);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeKey(Object k) {
        boolean r = this.keyMap.containsKey(k);
        V v = this.keyMap.remove(k);
        if (v != null) {
            this.valueMap.remove(v);
        }
        ++this.modCount;
        return r;
    }

    @Override
    public boolean removeValue(Object v) {
        boolean r = this.valueMap.containsKey(v);
        K k = this.valueMap.remove(v);
        if (k != null) {
            this.keyMap.remove(k);
        }
        ++this.modCount;
        return r;
    }

    @Override
    public Iterator<Pair<K, V>> iterator() {
        return new Iterator<Pair<K, V>>(){
            private Iterator<Map.Entry<K, V>> iter;
            private Map.Entry<K, V> cur;
            private int expectedModCount;
            {
                this.iter = HashOneToOneSet.this.keyMap.entrySet().iterator();
                this.cur = null;
                this.expectedModCount = HashOneToOneSet.this.modCount;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Pair<K, V> next() {
                Map.Entry n = this.iter.next();
                if (this.expectedModCount != HashOneToOneSet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                this.cur = n;
                return new Tuple2(n.getKey(), n.getValue());
            }

            @Override
            public void remove() {
                if (this.cur == null) {
                    throw new IllegalStateException();
                }
                if (this.expectedModCount != HashOneToOneSet.this.modCount) {
                    throw new ConcurrentModificationException();
                }
                HashOneToOneSet.this.removeKey(this.cur.getKey());
                this.expectedModCount = HashOneToOneSet.this.modCount;
            }
        };
    }

    @Override
    public int size() {
        return this.keyMap.size();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.valueMap = new HashMap();
        for (Map.Entry<K, V> e : this.keyMap.entrySet()) {
            this.valueMap.put(e.getValue(), e.getKey());
        }
    }

    @Override
    public boolean contains(Object k, Object v) {
        return this.containsKey(k) && this.containsValue(v);
    }

    @Override
    public Set<V> getValues(Object k) {
        return Collections.singleton(this.getValue(k));
    }

    @Override
    public Set<K> getKeys(Object v) {
        return Collections.singleton(this.getKey(v));
    }
}

