/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.datafactory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import net.morilib.util.datafactory.ListFactory;
import net.morilib.util.datafactory.MapFactory;
import net.morilib.util.datafactory.SetFactory;
import net.morilib.util.datafactory.SortedMapFactory;
import net.morilib.util.datafactory.SortedSetFactory;

public final class DataFactories {
    public static final SetFactory HASH_SET = new SetFactory(){

        @Override
        public <E> Set<E> newInstance() {
            return new HashSet();
        }

        @Override
        public <E> Set<E> clone(Collection<E> c) {
            return new HashSet<E>(c);
        }
    };
    public static final SortedSetFactory TREE_SET = new SortedSetFactory(){

        @Override
        public <E> SortedSet<E> newInstance() {
            return new TreeSet();
        }

        @Override
        public <E> SortedSet<E> clone(Collection<E> c) {
            return new TreeSet<E>(c);
        }
    };
    public static final ListFactory ARRAY_LIST = new ListFactory(){

        @Override
        public <E> List<E> newInstance() {
            return new ArrayList();
        }

        @Override
        public <E> List<E> clone(Collection<E> c) {
            return new ArrayList<E>(c);
        }
    };
    public static final ListFactory LINKED_LIST = new ListFactory(){

        @Override
        public <E> List<E> newInstance() {
            return new LinkedList();
        }

        @Override
        public <E> List<E> clone(Collection<E> c) {
            return new LinkedList<E>(c);
        }
    };
    public static final MapFactory HASH_MAP = new MapFactory(){

        @Override
        public <K, V> Map<K, V> newInstance() {
            return new HashMap();
        }

        @Override
        public <K, V> Map<K, V> clone(Map<K, V> c) {
            return new HashMap<K, V>(c);
        }
    };
    public static final MapFactory IDENTITY_HASH_MAP = new MapFactory(){

        @Override
        public <K, V> Map<K, V> newInstance() {
            return new IdentityHashMap();
        }

        @Override
        public <K, V> Map<K, V> clone(Map<K, V> c) {
            return new IdentityHashMap<K, V>(c);
        }
    };
    public static final SortedMapFactory TREE_MAP = new SortedMapFactory(){

        @Override
        public <K, V> SortedMap<K, V> newInstance() {
            return new TreeMap();
        }

        @Override
        public <K, V> SortedMap<K, V> clone(Map<K, V> c) {
            return new TreeMap<K, V>(c);
        }
    };

    private DataFactories() {
    }
}

