/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.util.bit;

import java.io.Serializable;
import net.morilib.util.BitUtils;
import net.morilib.util.bit.AbstractBitVector;
import net.morilib.util.primitive.IntegerArrayVector;
import net.morilib.util.primitive.IntegerCollection;

public class PackedBitVector
extends AbstractBitVector
implements Serializable {
    private static final long serialVersionUID = -8401650979234951542L;
    IntegerArrayVector vector;
    int size;

    public PackedBitVector() {
        this.vector = new IntegerArrayVector();
        this.size = 0;
    }

    public PackedBitVector(int mask) {
        this.vector = new IntegerArrayVector();
        this.size = 32;
        this.vector.add(mask);
    }

    public PackedBitVector(PackedBitVector vec) {
        this.vector = new IntegerArrayVector((IntegerCollection)vec.vector);
        this.size = vec.size;
    }

    public boolean getBoolean(int index) {
        int i = index >> 5;
        int y = index & 0x1F;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        return (this.vector.getInt(i) & 1 << y) != 0;
    }

    public int size() {
        return this.size;
    }

    public boolean add(boolean x) {
        int a;
        int i = this.size >> 5;
        int y = this.size & 0x1F;
        if (y == 0) {
            this.vector.add(0);
            a = 0;
        } else {
            a = this.vector.getInt(i);
        }
        a = x ? a | 1 << y : a & ~(1 << y);
        this.vector.set(i, a);
        ++this.size;
        ++this.modcount;
        return true;
    }

    public void clear() {
        this.vector.clear();
        this.size = 0;
    }

    public boolean any(boolean x) {
        int g;
        int s = this.size & 0x1F;
        int z = s > 0 ? 1 : 0;
        int i = 0;
        while (i < this.vector.size() - z) {
            g = this.vector.getInt(i);
            if (x && g != 0 || !x && g != -1) {
                return true;
            }
            ++i;
        }
        if (s > 0) {
            g = this.vector.get(i);
            return x && g != 0 || !x && g != BitUtils.getIntMask(s - 1);
        }
        return false;
    }

    public boolean every(boolean x) {
        int g;
        int s = this.size & 0x1F;
        int z = s > 0 ? 1 : 0;
        int i = 0;
        while (i < this.vector.size() - z) {
            g = this.vector.getInt(i);
            if (!x && g != 0 || x && g != -1) {
                return false;
            }
            ++i;
        }
        if (s > 0) {
            g = this.vector.get(i);
            return !x && g == 0 || x && g == BitUtils.getIntMask(s - 1);
        }
        return true;
    }

    public boolean add(int index, boolean x) {
        int z;
        boolean b;
        int i = index >> 5;
        int y = index & 0x1F;
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        if ((this.size & 0x1F) == 0) {
            this.vector.add(0);
        }
        boolean bl = b = ((z = this.vector.getInt(i)) & Integer.MIN_VALUE) != 0;
        z = y > 0 ? z & BitUtils.getIntMask(y - 1) | z << 1 & ~BitUtils.getIntMask(y - 1) : (z <<= 1);
        this.vector.set(i, z);
        int j = i + 1;
        while (j <= this.size >> 5) {
            z = this.vector.getInt(j);
            this.vector.set(j, z << 1 | (b ? 1 : 0));
            b = (z & Integer.MIN_VALUE) != 0;
            ++j;
        }
        ++this.size;
        this.set(index, x);
        ++this.modcount;
        return true;
    }

    public boolean removeAt(int index) {
        int z;
        int i = index >> 5;
        int y = index & 0x1F;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        boolean r = this.getBoolean(index);
        boolean b = false;
        int j = this.size - 1 >> 5;
        while (j > i) {
            z = this.vector.getInt(j);
            this.vector.set(j, z >>> 1 | (b ? Integer.MIN_VALUE : 0));
            b = (z & 1) != 0;
            --j;
        }
        z = this.vector.getInt(i);
        z = y > 0 ? z & BitUtils.getIntMask(y - 1) | z >>> 1 & ~BitUtils.getIntMask(y - 1) | (b ? Integer.MIN_VALUE : 0) : z >>> 1 | (b ? Integer.MIN_VALUE : 0);
        this.vector.set(i, z);
        if ((this.size & 0x1F) == 1) {
            this.vector.remove(this.vector.size() - 1);
        }
        --this.size;
        ++this.modcount;
        return r;
    }

    public boolean set(int index, boolean x) {
        int i = index >> 5;
        int y = index & 0x1F;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("" + index);
        }
        boolean r = this.getBoolean(index);
        int a = this.vector.getInt(i);
        a = x ? a | 1 << y : a & ~(1 << y);
        this.vector.set(i, a);
        ++this.modcount;
        return r;
    }

    public void negate() {
        int s = this.size & 0x1F;
        int z = s > 0 ? 1 : 0;
        int i = 0;
        while (i < this.vector.size() - z) {
            this.vector.set(i, ~this.vector.getInt(i));
            ++i;
        }
        if (s > 0) {
            this.vector.set(i, this.vector.get(i) ^ BitUtils.getIntMask(s - 1));
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PackedBitVector) {
            PackedBitVector v = (PackedBitVector)o;
            return this.vector.equals(v.vector) && this.size == v.size;
        }
        return super.equals(o);
    }

    public int hashCode() {
        if (this.size == 0) {
            return 0;
        }
        return (17 * this.vector.get(0) + this.size()) * 37;
    }
}

