/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.range;

import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.util.Iterators;
import net.morilib.util.Sets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergedRange
extends Range {
    SortedSet<Interval> sets;

    MergedRange() {
        this.sets = new TreeSet<Interval>();
    }

    private MergedRange(SortedSet<Interval> sets) {
        this.sets = sets;
    }

    MergedRange(Range t) {
        if (t instanceof MergedRange) {
            this.sets = new TreeSet<Interval>(((MergedRange)t).sets);
        } else {
            this.sets = new TreeSet<Interval>();
            this.sets.add((Interval)t);
        }
    }

    void addAll(Collection<Interval> intervals) {
        for (Interval o : intervals) {
            this.add(o);
        }
    }

    private SortedSet<Interval> optimizeInterval(SortedSet<Interval> s) {
        TreeSet<Interval> r = new TreeSet<Interval>();
        Interval k = null;
        for (Interval j : s) {
            if (k == null) {
                k = j;
                continue;
            }
            if (k.contactSupremumBound(j)) {
                if (k.isSupremumOpen() && j.isInfimumClosed()) {
                    k = k.cloneInterval(Interval.FROM_INFIMUM, j);
                    continue;
                }
                if (k.isSupremumClosed() && j.isInfimumOpen()) {
                    k = k.cloneInterval(Interval.FROM_INFIMUM, j);
                    continue;
                }
                r.add(k);
                k = j;
                continue;
            }
            r.add(k);
            k = j;
        }
        if (k != null) {
            r.add(k);
        }
        return r;
    }

    void add(Interval t) {
        TreeSet<Interval> r = new TreeSet<Interval>();
        Interval k = null;
        Interval l = t;
        for (Interval j : this.sets) {
            if (j.independentOf(l)) {
                r.add(k == null ? j : k);
                k = null;
                continue;
            }
            l = k = l.coveredInterval(j);
        }
        r.add(l);
        this.sets.clear();
        this.sets = this.optimizeInterval(r);
    }

    @Override
    boolean isInfimumAbove(Object o) {
        for (Range range : this.sets) {
            if (range.isInfimumAbove(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isInfimumBelow(Object o) {
        for (Range range : this.sets) {
            if (!range.isInfimumBelow(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isInfimumEqualTo(Object o) {
        return !this.isInfimumAbove(o) && !this.isInfimumBelow(o);
    }

    @Override
    boolean isSupremumAbove(Object o) {
        for (Range range : this.sets) {
            if (!range.isSupremumAbove(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isSupremumBelow(Object o) {
        for (Range range : this.sets) {
            if (range.isSupremumBelow(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isSupremumEqualTo(Object o) {
        return !this.isSupremumAbove(o) && !this.isSupremumBelow(o);
    }

    @Override
    boolean isInfimumBoundAbove(Object o) {
        for (Range range : this.sets) {
            if (range.isInfimumBoundAbove(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isInfimumBoundBelow(Object o) {
        for (Range range : this.sets) {
            if (!range.isInfimumBoundBelow(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isInfimumBoundEqualTo(Object o) {
        return !this.isInfimumBoundAbove(o) && !this.isInfimumBoundBelow(o);
    }

    @Override
    boolean isSupremumBoundAbove(Object o) {
        for (Range range : this.sets) {
            if (!range.isSupremumBoundAbove(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isSupremumBoundBelow(Object o) {
        for (Range range : this.sets) {
            if (range.isSupremumBoundBelow(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isSupremumBoundEqualTo(Object o) {
        return !this.isSupremumBoundAbove(o) && !this.isSupremumBoundBelow(o);
    }

    @Override
    boolean isInfimumBoundAboveAllClosureOf(Range r) {
        for (Range range : this.sets) {
            if (range.isInfimumBoundAboveAllClosureOf(r)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isInfimumBoundBelowAllClosureOf(Range r) {
        for (Range range : this.sets) {
            if (!range.isInfimumBoundBelowAllClosureOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isInfimumBoundAboveAnyClosureOf(Range r) {
        for (Range range : this.sets) {
            if (range.isInfimumBoundAboveAnyClosureOf(r)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isInfimumBoundBelowAnyClosureOf(Range r) {
        for (Range range : this.sets) {
            if (!range.isInfimumBoundBelowAnyClosureOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean contactInfimumBound(Range r) {
        return !this.isInfimumBoundAboveAllClosureOf(r) && !this.isInfimumBoundBelowAnyClosureOf(r);
    }

    @Override
    boolean commonInfimumBoundTo(Range r) {
        return !this.isInfimumBoundAboveAnyClosureOf(r) && !this.isInfimumBoundBelowAllClosureOf(r);
    }

    @Override
    boolean isSupremumBoundAboveAllClosureOf(Range r) {
        for (Range range : this.sets) {
            if (!range.isSupremumBoundAboveAllClosureOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isSupremumBoundBelowAllClosureOf(Range r) {
        for (Range range : this.sets) {
            if (range.isSupremumBoundBelowAllClosureOf(r)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isSupremumBoundAboveAnyClosureOf(Range r) {
        for (Range range : this.sets) {
            if (!range.isSupremumBoundAboveAnyClosureOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isSupremumBoundBelowAnyClosureOf(Range r) {
        for (Range range : this.sets) {
            if (range.isSupremumBoundBelowAnyClosureOf(r)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean contactSupremumBound(Range r) {
        return !this.isSupremumBoundAboveAnyClosureOf(r) && !this.isSupremumBoundBelowAllClosureOf(r);
    }

    @Override
    boolean commonSupremumBoundTo(Range r) {
        return !this.isSupremumBoundAboveAllClosureOf(r) && !this.isSupremumBoundBelowAnyClosureOf(r);
    }

    @Override
    public boolean contains(Object o) {
        for (Range range : this.sets) {
            if (!range.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean in(Range t) {
        for (Range range : this.sets) {
            if (range.in(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean independentOf(Range t) {
        for (Range range : this.sets) {
            if (range.independentOf(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean interiorIndependentOf(Range t) {
        for (Range range : this.sets) {
            if (range.interiorIndependentOf(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        for (Range range : this.sets) {
            if (range.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInfimumFinite() {
        for (Range range : this.sets) {
            if (range.isInfimumFinite()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSupremumFinite() {
        for (Range range : this.sets) {
            if (range.isSupremumFinite()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInfimumOpen() {
        return this.getInfimumRange().isInfimumOpen();
    }

    @Override
    public boolean isSupremumOpen() {
        return this.getSupremumRange().isSupremumOpen();
    }

    @Override
    public boolean isInfimumClosed() {
        return this.getInfimumRange().isInfimumClosed();
    }

    @Override
    public boolean isSupremumClosed() {
        return this.getSupremumRange().isSupremumClosed();
    }

    @Override
    public Range bound() {
        RangeAdder res = new RangeAdder();
        for (Interval b : this.sets) {
            for (Object s : b.boundElements()) {
                if (this.isNeighborhoodOf(s)) continue;
                res.add(Interval.newPoint(s));
            }
        }
        return res.toRange();
    }

    @Override
    public boolean isNeighborhoodOf(Object o) {
        for (Range range : this.sets) {
            if (!range.isNeighborhoodOf(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsClosure(Object o) {
        for (Range range : this.sets) {
            if (!range.containsClosure(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsBound(Object o) {
        for (Range range : this.sets) {
            if (!range.containsBound(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean boundsIn(Range t) {
        for (Range range : this.sets) {
            if (range.boundsIn(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean closureContains(Range t) {
        for (Range range : this.sets) {
            if (!range.closureContains(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean interiorContains(Range t) {
        for (Range range : this.sets) {
            if (!range.interiorContains(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Range t) {
        for (Range range : this.sets) {
            if (!range.containsAll(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public SortedSet<?> boundElements() {
        TreeSet res = new TreeSet();
        for (Range range : this.sets) {
            res.addAll(range.boundElements());
        }
        return Sets.sortedUnmodifiable(res);
    }

    @Override
    public boolean boundsIndependentOf(Range t) {
        for (Range range : this.sets) {
            if (range.boundsIndependentOf(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isOpen() {
        for (Range range : this.sets) {
            if (range.isOpen()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isClosed() {
        for (Range range : this.sets) {
            if (range.isClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean infimumBoundIn(Range r) {
        return this.getInfimumRange().infimumBoundIn(r);
    }

    @Override
    public boolean supremumBoundIn(Range r) {
        return this.getSupremumRange().supremumBoundIn(r);
    }

    @Override
    public Range closure() {
        TreeSet<Interval> s = new TreeSet<Interval>();
        for (Interval t : this.sets) {
            s.add(t.closureInterval());
        }
        return new MergedRange(s);
    }

    @Override
    public Range interior() {
        TreeSet<Interval> s = new TreeSet<Interval>();
        for (Interval t : this.sets) {
            s.add(t.interiorInterval());
        }
        return new MergedRange(s);
    }

    @Override
    public SortedSet<Interval> intervals() {
        return Sets.sortedUnmodifiable(this.sets);
    }

    @Override
    public int hashCode() {
        return this.sets.hashCode();
    }

    public String toString() {
        return Iterators.toString(this.sets.iterator(), "+");
    }
}

