/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.uvector;

import java.util.Iterator;
import java.util.List;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.lisp.uvector.HomogeneousArray;
import net.morilib.util.Bytes;
import net.morilib.util.primitive.ByteArrayVector;
import net.morilib.util.uvector.ByteArray;

public class LispU8Vector
extends Atom
implements HomogeneousArray {
    private ByteArray vector;

    private LispU8Vector() {
    }

    public LispU8Vector(byte ... bs) {
        this.vector = ByteArray.newArray(bs);
    }

    public LispU8Vector(ByteArray bs) {
        this.vector = new ByteArray(bs);
    }

    public static LispU8Vector malloc(int size) {
        LispU8Vector res = new LispU8Vector();
        res.vector = ByteArray.malloc(size);
        return res;
    }

    private static boolean checkRange(Datum d) {
        if (!(d instanceof LispReal)) {
            return false;
        }
        return ((LispReal)d).inUnsignedByteRange();
    }

    private static byte[] toByteList(Datum body, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        ByteArrayVector v = new ByteArrayVector();
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (!LispU8Vector.checkRange(d)) {
                throw mesg.getError("err.uvector.outofrange.u8", d);
            }
            v.add((byte)d.getInt());
        }
        if (!itr.getTerminal().equals(Nil.NIL)) {
            throw mesg.getError("err.list", body);
        }
        return v.toByteArray();
    }

    public String print() {
        StringBuilder b = new StringBuilder();
        String d = "";
        b.append("#u8(");
        int i = 0;
        while (i < this.vector.size()) {
            b.append(d);
            b.append(Bytes.ubyteToInt(this.vector.getByte(i)));
            d = " ";
            ++i;
        }
        b.append(")");
        return b.toString();
    }

    public String getResult() {
        return this.print();
    }

    public LispString toLispString() {
        return new LispString(this.print());
    }

    public boolean equalsArray(Datum d1, Datum d2) {
        if (!(d1 instanceof LispU8Vector)) {
            return false;
        }
        if (!(d2 instanceof LispU8Vector)) {
            return false;
        }
        return ((LispU8Vector)d1).vector.equals(((LispU8Vector)d2).vector);
    }

    public LispReal get(int index) {
        return LispInteger.valueOf(Bytes.ubyteToInt(this.vector.getByte(index)));
    }

    public void set(int index, LispReal x) {
        this.vector.setByte(index, (byte)x.getInt());
    }

    public int size() {
        return this.vector.size();
    }

    public void checkRange(LispReal x, LispMessage mesg) {
        if (!LispU8Vector.checkRange(x)) {
            throw mesg.getError("err.uvector.outofrange.u8", x);
        }
    }

    public void set(int index, int x) {
        this.vector.setInt(index, x);
    }

    public void set(int index, long x) {
        this.vector.setLong(index, x);
    }

    public void set(int index, double x) {
        this.vector.setDouble(index, x);
    }

    public void arraycopy(int sd, LispU8Vector s, int ss, int l) {
        this.vector.arraycopy(sd, s.vector, ss, l);
    }

    public Datum duplicate() {
        return new LispU8Vector(this.vector);
    }

    public static class EqualU8Vector
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispU8Vector)) {
                throw mesg.getError("err.uvector.require.u8", c1a);
            }
            if (!(c2a instanceof LispU8Vector)) {
                throw mesg.getError("err.uvector.require.u8", c2a);
            }
            return LispBoolean.getInstance(((LispU8Vector)c1a).vector.equals(((LispU8Vector)c2a).vector));
        }
    }

    public static class IsU8Vector
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispU8Vector);
        }
    }

    public static class ListToU8Vector
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Cons || c1a.equals(Nil.NIL)) {
                return new LispU8Vector(LispU8Vector.toByteList(c1a, mesg));
            }
            throw mesg.getError("err.require.list", c1a);
        }
    }

    public static class MakeU8Vector
    extends Subr {
        private byte[] makeVector(int len, int d) {
            ByteArrayVector b = new ByteArrayVector();
            int i = 0;
            while (i < len) {
                b.add((byte)d);
                ++i;
            }
            return b.toByteArray();
        }

        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> lst = LispUtils.consToList(body, mesg);
            if (lst.size() == 1) {
                int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                return new LispU8Vector(this.makeVector(t, 0));
            }
            if (lst.size() == 2) {
                int t = SubrUtils.getSmallIntegerExact(lst.get(0), mesg);
                if (t < 0) {
                    throw mesg.getError("err.require.int.nonnegative", lst.get(0));
                }
                if (!LispU8Vector.checkRange(lst.get(1))) {
                    throw mesg.getError("err.uvector.outofrange.u8", lst.get(1));
                }
                return new LispU8Vector(this.makeVector(t, lst.get(1).getInt()));
            }
            throw mesg.getError("err.argument", this.symbolName);
        }
    }

    public static class U8Vector
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            return new LispU8Vector(LispU8Vector.toByteList(body, mesg));
        }
    }

    public static class U8VectorCopy
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispU8Vector) {
                return ((LispU8Vector)c1a).duplicate();
            }
            throw mesg.getError("err.uvector.outofrange.u8", c1a);
        }
    }

    public static class U8VectorCopyS
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum s0 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            int ss = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            Datum d0 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            int sd = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            int l = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(s0 instanceof LispU8Vector)) {
                throw mesg.getError("err.uvector.require.u8", s0);
            }
            if (!(d0 instanceof LispU8Vector)) {
                throw mesg.getError("err.uvector.require.u8", d0);
            }
            LispU8Vector s = (LispU8Vector)s0;
            LispU8Vector d = (LispU8Vector)d0;
            if (ss < 0 || ss > s.size()) {
                throw mesg.getError("err.vector.outofrange", LispInteger.valueOf(ss));
            }
            if (sd < 0 || sd >= d.size()) {
                throw mesg.getError("err.vector.outofrange", LispInteger.valueOf(sd));
            }
            if (l < 0 || l + ss > s.size() || l + sd > d.size()) {
                throw mesg.getError("err.vector.outofrange", LispInteger.valueOf(l));
            }
            d.arraycopy(sd, s, ss, l);
            return Undef.UNDEF;
        }
    }

    public static class U8VectorToList
    extends UnaryArgs {
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispU8Vector) {
                ConsListBuilder b = new ConsListBuilder();
                LispU8Vector v = (LispU8Vector)c1a;
                int i = 0;
                while (i < v.vector.size()) {
                    b.append(LispInteger.valueOf(Bytes.ubyteToInt(v.vector.getByte(i))));
                    ++i;
                }
                return b.get();
            }
            throw mesg.getError("err.uvector.outofrange.u8", c1a);
        }
    }

    public static class VectorCompare
    extends BinaryArgs {
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispU8Vector)) {
                throw mesg.getError("err.uvector.require.u8", c1a);
            }
            if (!(c2a instanceof LispU8Vector)) {
                throw mesg.getError("err.uvector.require.u8", c2a);
            }
            LispU8Vector a = (LispU8Vector)c1a;
            LispU8Vector b = (LispU8Vector)c2a;
            if (a.size() == b.size()) {
                int i = 0;
                while (i < a.size()) {
                    if (a.get(i).compareTo(b.get(i)) < 0) {
                        return LispInteger.valueOf(-1);
                    }
                    if (a.get(i).compareTo(b.get(i)) > 0) {
                        return LispInteger.valueOf(1);
                    }
                    ++i;
                }
                return LispInteger.ZERO;
            }
            if (a.size() < b.size()) {
                return LispInteger.valueOf(-1);
            }
            return LispInteger.valueOf(1);
        }
    }
}

