/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.sound;

import java.util.List;
import javax.sound.sampled.AudioFormat;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;

public class LispAudioFormat
extends Datum2 {
    private static final OneToOneSet<Symbol, AudioFormat.Encoding> ENCODINGS = new HashOneToOneSet<Symbol, AudioFormat.Encoding>({Symbol.getSymbol("alaw"), AudioFormat.Encoding.ALAW}, {Symbol.getSymbol("pcm-signed"), AudioFormat.Encoding.PCM_SIGNED}, {Symbol.getSymbol("pcm-unsigned"), AudioFormat.Encoding.PCM_UNSIGNED}, {Symbol.getSymbol("ulaw"), AudioFormat.Encoding.ULAW});
    private static final OneToOneSet<Symbol, Boolean> ENDIAN = new HashOneToOneSet<Symbol, Boolean>({Symbol.getSymbol("big-endian"), Boolean.TRUE}, {Symbol.getSymbol("little-endian"), Boolean.FALSE});
    AudioFormat audioFormat;

    public LispAudioFormat(AudioFormat.Encoding encoding, float sampleRate, int sampleSizeInBits, int channels, int frameSize, float frameRate, boolean bigEndian) {
        this.audioFormat = new AudioFormat(encoding, sampleRate, sampleSizeInBits, channels, frameSize, frameRate, bigEndian);
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<audio-format ").append(this.audioFormat.toString()).append(">");
    }

    public static class MakeAudioFormat
    extends Subr {
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() != 7) {
                throw mesg.getError("err.argument", body);
            }
            AudioFormat.Encoding e = (AudioFormat.Encoding)ENCODINGS.getValue(l.get(0));
            if (e == null) {
                throw mesg.getError("err.sound.invalidencoding", l.get(0));
            }
            if (!(l.get(1) instanceof LispReal)) {
                throw mesg.getError("err.require.real", l.get(1));
            }
            if (!(l.get(2) instanceof LispSmallInt)) {
                throw mesg.getError("err.require.smallint", l.get(2));
            }
            if (l.get(2).getInt() <= 0 || l.get(2).getInt() > 32) {
                throw mesg.getError("err.sound.invalidsamplingbits", l.get(2));
            }
            if (!(l.get(3) instanceof LispSmallInt)) {
                throw mesg.getError("err.require.smallint", l.get(3));
            }
            if (!(l.get(4) instanceof LispSmallInt)) {
                throw mesg.getError("err.require.smallint", l.get(4));
            }
            if (!(l.get(5) instanceof LispReal)) {
                throw mesg.getError("err.require.real", l.get(5));
            }
            Boolean b = (Boolean)ENDIAN.getValue(l.get(6));
            if (b == null) {
                throw mesg.getError("err.sound.invalidendian", l.get(6));
            }
            return new LispAudioFormat(e, (float)l.get(1).getRealDouble(), l.get(2).getInt(), l.get(3).getInt(), l.get(4).getInt(), (float)l.get(5).getRealDouble(), b);
        }
    }
}

