/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.geometry.g2d;

import java.awt.geom.AffineTransform;
import net.morilib.geometry.g2d.VectorTransformer2D;
import net.morilib.lang.number.NumericalField;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.geometry.g2d.LispVector2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LispAffineTransformer2D
extends Datum
implements VectorTransformer2D<LispVector2D, LispReal> {
    private LispReal scaleX;
    private LispReal scaleY;
    private LispReal shearX;
    private LispReal shearY;
    private LispReal transformX;
    private LispReal transformY;

    public LispAffineTransformer2D(LispReal scaleX, LispReal scaleY, LispReal shearX, LispReal shearY, LispReal transformX, LispReal transformY) {
        if (scaleX == null || scaleY == null) {
            throw new NullPointerException();
        }
        if (shearX == null || shearY == null) {
            throw new NullPointerException();
        }
        if (transformX == null || transformY == null) {
            throw new NullPointerException();
        }
        this.scaleX = scaleX;
        this.shearX = shearX;
        this.transformX = transformX;
        this.scaleY = scaleY;
        this.shearY = shearY;
        this.transformY = transformY;
    }

    public static LispAffineTransformer2D getRotator(double theta) {
        NumericalField<LispReal> ff = LispDouble.FIELD;
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        return new LispAffineTransformer2D(ff.valueOf(cos), ff.valueOf(cos), ff.valueOf(-sin), ff.valueOf(sin), (LispReal)ff.getZero(), (LispReal)ff.getZero());
    }

    public static LispAffineTransformer2D getRotator(LispVector2D anchor, double theta) {
        NumericalField<LispReal> ff = LispDouble.FIELD;
        double x = anchor.getX().doubleValue();
        double y = anchor.getY().doubleValue();
        double sin = Math.sin(theta);
        double cos = Math.cos(theta);
        return new LispAffineTransformer2D(ff.valueOf(cos), ff.valueOf(cos), ff.valueOf(-sin), ff.valueOf(sin), ff.valueOf(x - x * cos + y * sin), ff.valueOf(y - x * sin - y * cos));
    }

    public LispReal getScaleX() {
        return this.scaleX;
    }

    public LispReal getScaleY() {
        return this.scaleY;
    }

    public LispReal getShearX() {
        return this.shearX;
    }

    public LispReal getShearY() {
        return this.shearY;
    }

    public LispReal getTransformX() {
        return this.transformX;
    }

    public LispReal getTransformY() {
        return this.transformY;
    }

    @Override
    public LispVector2D transform(LispVector2D p) {
        LispReal x = this.scaleX.multiply(p.getX());
        x = x.add(this.shearX).multiply(p.getY());
        x = x.add(this.transformX);
        LispReal y = this.scaleY.multiply(p.getY());
        y = y.add(this.shearY).multiply(p.getX());
        y = y.add(this.transformY);
        return p.getFactory().create(x, y);
    }

    public AffineTransform toAWTTransform() {
        return new AffineTransform(this.scaleX.doubleValue(), this.shearY.doubleValue(), this.scaleX.doubleValue(), this.scaleY.doubleValue(), this.transformX.doubleValue(), this.transformY.doubleValue());
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("\n");
        buf.append("[ ").append(this.scaleX.toString());
        buf.append(" ").append(this.shearX.toString());
        buf.append(" ").append(this.transformX.toString()).append("]\n");
        buf.append("[ ").append(this.shearY.toString());
        buf.append(" ").append(this.scaleY.toString());
        buf.append(" ").append(this.transformY.toString()).append("]\n");
        buf.append("[0 0 1]\n");
    }

    public int hashCode() {
        int r = 17;
        r = (r + this.scaleX.hashCode()) * 37;
        r = (r + this.scaleY.hashCode()) * 37;
        r = (r + this.shearX.hashCode()) * 37;
        r = (r + this.shearY.hashCode()) * 37;
        r = (r + this.transformX.hashCode()) * 37;
        r = (r + this.transformY.hashCode()) * 37;
        return r;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispAffineTransformer2D) {
            LispAffineTransformer2D t = (LispAffineTransformer2D)obj;
            return this.scaleX.equals(t.scaleX) && this.scaleY.equals(t.scaleY) && this.shearX.equals(t.shearX) && this.shearY.equals(t.shearY) && this.transformX.equals(t.transformX) && this.transformY.equals(t.transformY);
        }
        return false;
    }
}

