/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.format;

import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.format.FormatArguments;
import net.morilib.lisp.format.FormatArgumentsException;
import net.morilib.lisp.format.LispFormatException;

public class DatumFormatArguments
implements FormatArguments {
    private Datum lst;

    public DatumFormatArguments(Datum lst) {
        this.lst = lst;
    }

    public char shiftChar() throws LispFormatException {
        Datum dtm = (Datum)this.shift();
        if (dtm instanceof LispCharacter) {
            return dtm.getCharacter();
        }
        throw new FormatArgumentsException();
    }

    public int shiftInt() throws LispFormatException {
        Datum dtm = (Datum)this.shift();
        if (dtm instanceof LispInteger) {
            return dtm.getInt();
        }
        throw new FormatArgumentsException();
    }

    public double shiftDouble() throws LispFormatException {
        Datum dtm = (Datum)this.shift();
        if (dtm instanceof LispReal) {
            return dtm.getRealDouble();
        }
        throw new FormatArgumentsException();
    }

    public String shiftString() throws LispFormatException {
        Datum dtm = (Datum)this.shift();
        return LispUtils.print(dtm);
    }

    public String shiftStringWrite() throws LispFormatException {
        Datum dtm = (Datum)this.shift();
        return LispUtils.getResult(dtm);
    }

    public Object shift() throws LispFormatException {
        if (!(this.lst instanceof Cons)) {
            throw new FormatArgumentsException();
        }
        Cons c = (Cons)this.lst;
        Datum res = c.getCar();
        this.lst = c.getCdr();
        return res;
    }
}

