/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.compare;

import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ILispVector;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Symbol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SRFI67 {
    private static final Symbol DYNFLG = Symbol.getSymbol("*refer-default-compare-dynamic*");
    private static final Symbol DEFCMP = Symbol.getSymbol("default-compare");
    public static final LispInteger GREATER = LispInteger.ONE;
    public static final LispInteger EQUAL = LispInteger.ZERO;
    public static final LispInteger LESS = LispInteger.valueOf(-1);

    private static boolean isDynamic(Environment env) {
        Datum d = env.findDatum(DYNFLG);
        return d == null ? false : d.isTrue();
    }

    public static int getValue(Datum d, LispMessage mesg) {
        if (!(d instanceof LispSmallInt)) {
            throw mesg.getError("err.srfi67.return.value3", d);
        }
        if (d.getInt() > 1 || d.getInt() < -1) {
            throw mesg.getError("err.srfi67.return.value3", d);
        }
        return d.getInt();
    }

    public static LispInteger getInstance(int x) {
        return x > 0 ? GREATER : (x < 0 ? LESS : EQUAL);
    }

    public static LispInteger compareChar(char x1, char x2) {
        return x1 > x2 ? GREATER : (x1 < x2 ? LESS : EQUAL);
    }

    public static LispInteger compareInt(int x1, int x2) {
        return x1 > x2 ? GREATER : (x1 < x2 ? LESS : EQUAL);
    }

    public static <T extends Comparable<T>> LispInteger compareTo(T x1, T x2) {
        return SRFI67.getInstance(x1.compareTo(x2));
    }

    public static LispInteger compareReal(LispReal x1, LispReal x2) {
        return SRFI67.getInstance(x1.subtract(x2).signum());
    }

    public static LispInteger callCompareDefault(Datum x1, Datum x2, Environment env, LispMessage mesg) {
        boolean d = SRFI67.isDynamic(env);
        Datum f = d ? env.findDatum(DEFCMP) : env.getDatumTop(DEFCMP);
        return SRFI67.callCompare(f, x1, x2, env, mesg);
    }

    public static LispInteger callCompare(Datum f, Datum x1, Datum x2, Environment env, LispMessage mesg) {
        if (f != null) {
            Datum r = Scheme.callva(f, env, mesg, x1, x2);
            if (!(r instanceof LispSmallInt)) {
                throw mesg.getError("err.srfi67.return.value3", r);
            }
            if (r.getInt() < -1 || r.getInt() > 1) {
                throw mesg.getError("err.srfi67.return.value3", r);
            }
            return (LispInteger)r;
        }
        return SRFI67.callCompareDefault(x1, x2, env, mesg);
    }

    static int callSize(Datum f, ILispVector x, Environment env, LispMessage mesg) {
        if (f == null) {
            return x.size();
        }
        Datum r = Scheme.callva(f, env, mesg, (Datum)((Object)x));
        if (!(r instanceof LispSmallInt)) {
            throw mesg.getError("err.srfi67.return.nonnegative", r);
        }
        if (r.getInt() < 0) {
            throw mesg.getError("err.srfi67.return.nonnegative", r);
        }
        return r.getInt();
    }

    static Datum callRef(Datum f, ILispVector x, int i, Environment env, LispMessage mesg) {
        if (f == null) {
            return x.get(i);
        }
        return Scheme.callva(f, env, mesg, (Datum)((Object)x), LispInteger.valueOf(i));
    }

    static boolean callIsNull(Datum f, Datum x, Environment env, LispMessage mesg) {
        if (f == null) {
            return x.isNil();
        }
        return Scheme.callva(f, env, mesg, x).isTrue();
    }

    static Datum callCar(Datum f, Datum x, Environment env, LispMessage mesg) {
        if (f != null) {
            return Scheme.callva(f, env, mesg, x);
        }
        if (x instanceof Cons) {
            return ((Cons)x).getCar();
        }
        throw mesg.getError("err.require.pair", x);
    }

    static Datum callCdr(Datum f, Datum x, Environment env, LispMessage mesg) {
        if (f != null) {
            return Scheme.callva(f, env, mesg, x);
        }
        if (x instanceof Cons) {
            return ((Cons)x).getCdr();
        }
        throw mesg.getError("err.require.pair", x);
    }
}

