/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.bits;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;

public class CopyBitField
extends QuaternaryArgs {
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a, Environment env, LispMessage mesg) {
        int s = SubrUtils.getSmallIntegerExact(c3a, mesg);
        int e = SubrUtils.getSmallIntegerExact(c4a, mesg);
        if (s < 0) {
            throw mesg.getError("err.require.int.nonnegative", c3a);
        }
        if (e < 0) {
            throw mesg.getError("err.require.int.nonnegative", c4a);
        }
        if (s > e) {
            throw mesg.getError("err.srfi60.index.invalid");
        }
        if (s == e) {
            return LispInteger.ZERO;
        }
        if (!(c1a instanceof LispInteger)) {
            throw mesg.getError("err.require.int", c1a);
        }
        if (!(c2a instanceof LispInteger)) {
            throw mesg.getError("err.require.int", c2a);
        }
        BigInteger b = c1a.getBigInteger();
        BigInteger c = c2a.getBigInteger();
        BigInteger m = BigInteger.valueOf(-1L).shiftLeft(e - s);
        m = m.not().shiftLeft(s);
        return LispInteger.valueOf(b.andNot(m).or(c.and(m)));
    }
}

