/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.ReadException;

public final class LispMessage {
    private static final String CLSNAME = "net.morilib.lisp.init.messages";
    private static Map<Locale, LispMessage> instances = new HashMap<Locale, LispMessage>();
    private static List<String> pluggedName = new ArrayList<String>();
    private static List<ClassLoader> pluggedLoader = new ArrayList<ClassLoader>();
    private ResourceBundle messages;
    private List<ResourceBundle> pluggable = new ArrayList<ResourceBundle>();

    private LispMessage(Locale lc) {
        this.messages = ResourceBundle.getBundle(CLSNAME, lc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static LispMessage getInstance(Locale lc) {
        LispMessage res = instances.get(lc);
        if (res == null) {
            Class<LispMessage> clazz = LispMessage.class;
            // MONITORENTER : net.morilib.lisp.LispMessage.class
            res = new LispMessage(lc);
            instances.put(lc, res);
            // MONITOREXIT : clazz
        }
        res.loadplugin();
        return res;
    }

    public static LispMessage getInstance() {
        return LispMessage.getInstance(Locale.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPlugin(String name, ClassLoader loader) {
        List<String> list = pluggedName;
        synchronized (list) {
            pluggedName.add(name);
            pluggedLoader.add(loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadplugin() {
        if (this.pluggable.size() < pluggedName.size()) {
            List<String> list = pluggedName;
            synchronized (list) {
                int i = this.pluggable.size();
                while (i < pluggedName.size()) {
                    this.pluggable.add(ResourceBundle.getBundle(pluggedName.get(i), this.messages.getLocale(), pluggedLoader.get(i)));
                    ++i;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public String get(String prop) {
        this.loadplugin();
        try {
            return this.messages.getString(prop);
        }
        catch (MissingResourceException e) {
            ** for (rb : this.pluggable)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return rb.getString(prop);
            }
            catch (MissingResourceException var5_5) {
                // empty catch block
            }
            continue;
        }
lbl11:
        // 1 sources

        return String.valueOf(this.messages.getString("err.unknown")) + "(" + e.getKey() + ")";
    }

    public String get(String prop, String msg2) {
        return String.valueOf(this.get(prop)) + ":" + msg2;
    }

    public String get(String prop, Datum d) {
        return String.valueOf(this.get(prop)) + ":" + LispUtils.getResult(d);
    }

    public LispException getError(String prop) {
        return new LispException(prop, this.get(prop));
    }

    public LispException getError(String prop, String msg2) {
        return new LispException(prop, this.get(prop, msg2));
    }

    public LispException getError(String prop, Datum d) {
        return new LispException(prop, this.get(prop, d));
    }

    public LispException getError(String prop, Throwable th) {
        return new LispException(prop, this.get(prop), th);
    }

    public LispException getError(String prop, String msg2, Throwable th) {
        return new LispException(prop, this.get(prop, msg2), th);
    }

    public LispException getError(String prop, Datum d, Throwable th) {
        return new LispException(prop, this.get(prop, d), th);
    }

    public ReadException getReadError(String prop) {
        return new ReadException(prop, this.get(prop));
    }

    public ReadException getReadError(String prop, String msg2) {
        return new ReadException(prop, this.get(prop, msg2));
    }

    public ReadException getReadError(String prop, Datum d) {
        return new ReadException(prop, this.get(prop, d));
    }

    public LispException getUncaughtException(LispException e) {
        return new LispException("err.srfi18.uncaught", this.get("err.srfi18.uncaught"), e);
    }
}

