/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.ClosureClassMethod;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Settable;

public final class Closure
extends Settable
implements Procedure {
    private Datum params;
    private CompiledCode body;
    private Environment env;

    Closure(ClosureClass cl, Environment env) {
        if (cl == null || env == null) {
            throw new NullPointerException();
        }
        this.params = cl.getParameterList();
        this.body = cl.getCode();
        this.env = env;
    }

    Closure(ClosureClassMethod cl, Environment env) {
        if (cl == null || env == null) {
            throw new NullPointerException();
        }
        this.params = cl.getParameterList();
        this.body = cl.getCode();
        this.env = env;
    }

    Datum getParameterList() {
        return this.params;
    }

    CompiledCode getCode() {
        return this.body;
    }

    Environment getEnvironment() {
        return this.env;
    }

    public int getArity() {
        ConsIterator itr = new ConsIterator(this.params);
        int ary = 0;
        while (itr.hasNext()) {
            itr.next();
            ++ary;
        }
        return itr.getTerminal().isNil() ? ary : -1;
    }

    public boolean isTypeProcedure() {
        return true;
    }

    public String toString() {
        return "Closure:" + this.printName();
    }

    public String display() {
        return "#<closure " + this.printName() + ">";
    }

    public void toDisplayString(StringBuilder buf) {
        buf.append("#<closure " + this.printName() + ">");
    }
}

