/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.automata;

import java.util.Collections;
import java.util.Set;
import net.morilib.automata.PatternParseException;
import net.morilib.automata.dfa.DFA;
import net.morilib.automata.dfa.DFABuilder;
import net.morilib.automata.dfa.DFAState;
import net.morilib.util.Tuple2;

public abstract class PatternMatcher {
    private DFA<Integer, Integer, Tuple2<Integer, Integer>> dfa = null;
    private MatchAction[] actions;

    protected PatternMatcher() {
    }

    private void initdfa(Object ... os) {
        if (os.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        String[] ss = new String[os.length / 2];
        int i = 0;
        while (i < ss.length) {
            ss[i] = (String)os[i << 1];
            if (ss[i] == null) {
                throw new NullPointerException();
            }
            ++i;
        }
        this.actions = new MatchAction[os.length / 2];
        i = 0;
        while (i < ss.length) {
            this.actions[i] = (MatchAction)os[(i << 1) + 1];
            if (this.actions[i] == null) {
                throw new NullPointerException();
            }
            ++i;
        }
        this.dfa = DFABuilder.getInstance().buildCombined(ss);
    }

    protected void init() {
    }

    protected abstract Object[] getSchema();

    protected boolean inhibitCharacter(int c) {
        return false;
    }

    protected void exec(String cmd) throws PatternParseException {
        int p = 0;
        int b = -1;
        Set<Object> befs = Collections.emptySet();
        if (this.dfa == null) {
            this.initdfa(this.getSchema());
        }
        DFAState<Integer, Integer, Tuple2<Integer, Integer>> stat = this.dfa.getInitialState();
        this.init();
        while (p <= cmd.length()) {
            int c;
            int n = c = p < cmd.length() ? -1 : (int)cmd.charAt(p);
            if (p < cmd.length()) {
                c = -1;
            } else {
                c = cmd.charAt(p);
                if (this.inhibitCharacter(c)) {
                    throw new PatternParseException();
                }
            }
            stat = stat.go(c);
            Set<Integer> s = stat.getAccepted();
            if (b < 0) {
                if (!s.isEmpty()) {
                    b = p;
                    befs = s;
                }
            } else if (s.isEmpty()) {
                this.actions[(Integer)Collections.min(befs)].doAction(cmd.substring(b, p));
                befs = Collections.emptySet();
                stat = this.dfa.getInitialState();
                b = -1;
            } else {
                befs = s;
            }
            ++p;
        }
    }

    public static interface MatchAction {
        public void doAction(String var1);
    }
}

