/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.painter;

import java.awt.Image;
import java.awt.geom.Rectangle2D;

import net.morilib.lisp.painter.drawer.CoordinateMap;
import net.morilib.lisp.painter.drawer.Drawer;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2010/12/19
 */
public interface SchlushFrame {

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2010/12/19
	 */
	public static class ImageInfo {

		//
		/*package*/ Image img;
		/*package*/ double x, y;
		/*package*/ double sx, sy;

		public ImageInfo(
				Image img, double x, double y, double sx, double sy) {
			this.img = img;
			this.x   = x;
			this.y   = y;
			this.sx  = sx;
			this.sy  = sy;
		}

	}

	/**
	 * 
	 * @param img
	 * @throws InterruptedException 
	 */
	public void addImage(ImageInfo img) throws InterruptedException;

	/**
	 * 
	 * @param drawer
	 */
	public void addDrawer(Drawer drawer);

	/**
	 * 
	 * @return
	 */
	public int getImageWidth(Image img);

	/**
	 * 
	 * @return
	 */
	public int getImageHeight(Image img);

	/**
	 * 
	 */
	public void clearScreen();

	/**
	 * 
	 * @return
	 */
	public CoordinateMap getCoordinate();

	/**
	 * 
	 * @return
	 */
	public int getHeight();

	/**
	 * 
	 * @return
	 */
	public int getWidth();

	/**
	 * 
	 * @param str
	 * @param font
	 * @return
	 */
	public Rectangle2D calculateFontBounds(
			String str, SchlushFont font);

	/**
	 * 
	 */
	public void repaint();

}
