/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.applet;

import java.awt.Image;
import java.awt.MediaTracker;

import javax.swing.JApplet;

import net.morilib.lisp.painter.SchlushJPanelFrame;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/02/03
 */
/*package*/ class SchlushAppletFrame extends SchlushJPanelFrame {

	//
	private JApplet applet;

	//
	/*package*/ SchlushAppletFrame(JApplet applet) {
		this.applet = applet;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#getImageWidth(java.awt.Image)
	 */
	@Override
	public int getImageWidth(Image img) {
		return img.getWidth(applet);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#getImageHeight(java.awt.Image)
	 */
	@Override
	public int getImageHeight(Image img) {
		return img.getHeight(applet);
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#getHeight()
	 */
	@Override
	public int getHeight() {
		return applet.getHeight();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#getWidth()
	 */
	@Override
	public int getWidth() {
		return applet.getWidth();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushJPanelFrame#loadImage(java.awt.Image)
	 */
	@Override
	protected void loadImage(Image img) throws InterruptedException {
		MediaTracker mt = new MediaTracker(applet);

		mt.addImage(img, 1);
		mt.waitForAll();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.painter.SchlushFrame#repaint()
	 */
	@Override
	public void repaint() {
		applet.repaint();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum#toDisplayString(java.lang.StringBuilder)
	 */
	@Override
	public void toDisplayString(StringBuilder buf) {
		buf.append("#<applet-frame>");
	}

}
