/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

import java.util.Comparator;

/**
 * <i>USEful Implements</i> for general objects.<br>
 * <p>֥Ȥ˴ؤʴؿǤ.
 * 
 * @author MORIGUCHI, Yuichiro 2004/12/11
 */
public final class Objects {
	
	/**
	 * The mark means the maximum of all objects.<br>
	 * <p>ֺΥ֥ȡפ򼨤ޡǤ.
	 */
	public static final Object MAXIMUM = new MarkerEnum("maximum");
	
	/**
	 * The mark means the minimum of all objects.<br>
	 * <p>ֺǾΥ֥ȡפ򼨤ޡǤ.
	 */
	public static final Object MINIMUM = new MarkerEnum("MINIMUM");
	
	/**
	 * An empty array of Object.
	 * <p>ObjectǤ.
	 */
	public static final Object[] OBJECT_EMPTY = new Object[0];
	
	
	/**
	 * Returns the second argument if the first argument is null,
	 * otherwise returns the first one.<br>
	 * <p>1nullΤȤ2ǤʤȤ1֤.
	 * 
	 * @param ifnull  return value in case that o is null
	 * @return return ifnull if o is null, otherwise returns o
	 */
	public static /*inline*/ Object nvl(Object o, Object ifnull) {
		return (o != null) ? o : ifnull;
	}

	/**
	 * Returns true if the given objects are equal.<br>
	 * <p>Ϳ줿Ȥtrue.
	 * 
	 * @return  true if obj1 equals obj2, otherwise false
	 */
	public static /*inline*/ boolean equals(Object obj1, Object obj2) {
		return (obj1 == null) ? obj2 == null : obj1.equals(obj2);
	}
	
	/**
	 * Transform an object to its string representation:
	 * If the object is null, returns an empty string.<br>
	 * <p>Ϳ줿֥Ȥʸɽ֤.֥Ȥnull
	 * Ȥ϶ʸ֤.
	 * 
	 * @param attr  an object to transform
	 * @return  string representation
	 * @see  java.lang.Object
	 */
	public static /*inline*/ String toString(Object attr) {
		return (attr == null) ? "" : attr.toString();
	}

	/**
	 * gets the maximum value of given arguments.
	 * <p>ΤΥ֥Ȥ֤.
	 * 
	 * @return  the maximum value of the given arguments
	 */
	public static<T extends Comparable<? super T>> T max(T i1, T i2) {
		return (i1.compareTo(i2) > 0) ? i1 : i2;
	}

	/**
	 * gets the minimum value of the arguments.
	 * <p>ΤǾΥ֥Ȥ֤.
	 * 
	 * @return  the minimum value of the given arguments
	 */
	public static<T extends Comparable<? super T>> T min(T i1, T i2) {
		return (i1.compareTo(i2) > 0) ? i2 : i1;
	}

	/**
	 * gets the maximum value of given arguments.
	 * <p>ΤΥ֥Ȥ֤.
	 * 
	 * @return  the maximum value of the given arguments
	 */
	/*public static Object max(Object[] objs) {
		Object res = null;
		
		for(int i = 0; i < objs.length; i++) {
			res = maxNull(res, objs[i]);
		}
		return res;
	}*/

	/**
	 * get the minimum value of the arguments.
	 * <p>ΤǾΥ֥Ȥ֤.
	 * 
	 * @return  the minimum value of the given arguments
	 */
	/*public static Object min(Object[] objs) {
		Object res = null;
		
		for(int i = 0; i < objs.length; i++) {
			res = minNull(res, objs[i]);
		}
		return res;
	}*/

	/**
	 * gets the maximum value of the given arguments.
	 * <p>ΤΥ֥Ȥ֤.
	 * 
	 * @return  the maximum value of the given arguments
	 */
	public static<T> T max(T i1, T i2, Comparator<T> cp) {
		return (compare(i1, i2, cp) > 0) ? i1 : i2;
	}

	/**
	 * get the minimum value of the arguments.
	 * <p>ΤǾΥ֥Ȥ֤.
	 * 
	 * @return  the minimum value of the given arguments
	 */
	public static<T> T min(T i1, T i2, Comparator<T> cp) {
		return (compare(i1, i2, cp) > 0) ? i2 : i1;
	}

	/**
	 * get the maximum value of the given arguments.
	 * <p>ΤΥ֥Ȥ֤.nullϡֺǾ͡פȲᤵ.
	 * 
	 * @return  the maximum value of the given arguments
	 */
	public static<T extends Comparable<? super T>> T maxNull(
			T i1, T i2) {
		return (i1 == null) ? i2 : ((i2 == null) ? i1 : max(i1, i2));
	}

	/**
	 * get the minimum value of the arguments.
	 * <p>ΤǾΥ֥Ȥ֤.nullϡֺ͡פȲᤵ.
	 * 
	 * @return  the minimum value of the given arguments
	 */
	public static<T extends Comparable<? super T>> T minNull(
			T i1, T i2) {
		return (i1 == null) ? i2 : ((i2 == null) ? i1 : min(i1, i2));
	}

	/**
	 * compares the given objects;
	 * returns 1 if the first object is larger than the second object,
	 * returns 0 if the first is equal to the second,
	 * and returns -1 if the first is smaller than the second.
	 * <p>Ӥ.
	 * 1ΰ2ΰ礭Ȥ줾
	 * 1, 0, -1֤.
	 * 
	 * @see java.lang.Comparable
	 */
	@SuppressWarnings("unchecked")
	public static int compareBound(Object o, Object p) {
		if(o == null || o == MINIMUM) {
			return (p == null || p == MINIMUM) ? 0 : -1;
		} else if(o == MAXIMUM) {
			return (p == MAXIMUM) ? 0 : 1;
		} else if(p == null || p == MINIMUM) {
			return 1;
		} else if(p == MAXIMUM) {
			return -1;
		} else {
			return ((Comparable<Object>)o).compareTo(p);
		}
	}

	/**
	 * compares the given objects each other with the given Comparator.
	 * <p>Ϳ줿ComparatorѤƥ֥ȤӤ.
	 * 
	 * @param c  a comparator
	 * @see java.lang.Comparable
	 * @see java.util.Comparator
	 */
	public static<T> int compare(T o, T p, Comparator<T> c) {
		//return (c == null) ? compare(o, p) : c.compare(o, p);
		return c.compare(o, p);
	}
	
	/**
	 * returns true if the first argument is between the second
	 * argument and the third.
	 * <p>1ΰ2ΰ3ΰδ֤ˤtrueȤ.
	 * 
	 * @param src   the first argument
	 * @param from  the second argument
	 * @param to    the third argument
	 */
	public static boolean betweenBound(
			Object src, Object from, Object to) {
		return (compareBound(src, from) >= 0 &&
				compareBound(src, to)   <= 0);
	}
	
	/**
	 * returns true if the first argument is between the second
	 * argument and the third; the given comparator is used for compare.
	 * <p>1ΰ2ΰ3ΰδ֤ˤtrueȤ.
	 * ӤˤϰComparatorѤ.
	 * 
	 * @param src   the first argument
	 * @param from  the second argument
	 * @param to    the third argument
	 * @param comp  the comparator to be used
	 */
	public static<T> boolean between(
			T src, T from, T to, Comparator<T> comp) {
		return (compare(src, from, comp) >= 0 &&
				compare(src, to,   comp) <= 0);
	}
	
}
