/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.range;

import java.util.Collection;

/**
 * This is the builder class for constructing an instance of
 * {@link MergedRange}.
 * <p>{@link MergedRange}ۤ뤿Υӥ饹Ǥ.
 * 
 * @author MORIGUCHI, Yuichiro 2008/01/01
 */
public final class RangeAdder {
	
	//
	private MergedRange range;
	
	/**
	 * constructs a new RangeAdder.
	 * <p>RangeAdderۤ.
	 */
	public RangeAdder() {
		range = new MergedRange();
	}

	/**
	 * adds a {@link Range} object to this instance.
	 * <p>{@link Range}֥Ȥ򤳤Υ󥹥󥹤ɲä.
	 * 
	 * @param r  a {@link Range} object to be added
	 * @return  this instance
	 */
	public RangeAdder add(Range r) {
		range.addAll(r.intervals());
		return this;
	}
	
	/**
	 * adds all {@link Range} objects in the given collection
	 * to this instance.
	 * <p>Ϳ줿쥯ˤƤ{@link Range}֥Ȥ
	 * Υ󥹥󥹤ɲä.
	 * 
	 * @param c  a collection of {@link Range} objects to be added
	 * @return  this instance
	 */
	public RangeAdder addAll(Collection<Interval> c) {
		range.addAll(c);
		return this;
	}
	
	/**
	 * adds a {@link Interval} object to this instance.
	 * <p>{@link Range}֥Ȥ򤳤Υ󥹥󥹤ɲä.
	 * 
	 * @param c  a {@link Interval} object to be added
	 * @return  this instance
	 */
	public RangeAdder addInterval(Interval c) {
		range.add(c);
		return this;
	}

	/**
	 * gets the {@link Range} object builded by this class.
	 * <p>Υ饹ˤ깽ۤ줿{@link Range}֥Ȥ.
	 */
	public MergedRange toRange() {
		return range;
	}

}
