/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

import java.util.Collection;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * Implimentation of stack by LinkedList.
 * <p>LinkedListѤåμǤ.
 * 
 * @author MORIGUCHI, Yuichiro 2005/03/03
 */
public class LinkedListStack<E> implements Stack2<E> {
	
	//
	/*package*/ List<E> list;
	
	/**
	 * constructs a new ListStack.
	 * <p>å.
	 */
	public LinkedListStack() {
		list = new LinkedList<E>();
	}
	
	/**
	 * constructs a new ListStack and initializes the given collection.
	 * <p>åͿ줿쥯ǽ.
	 * 
	 * @param col  a collection
	 */
	public LinkedListStack(Collection<E> col) {
		list = new LinkedList<E>();
		
		Iterator<E> i = col.iterator();
		while(i.hasNext()) {
			list.add(i.next());
		}
	}
	
	/**
	 * pushs the object.
	 * <p>֥Ȥץå夹.
	 * 
	 * @param o  the object to be pushed
	 * @return   the pushed object
	 */
	public E push(E o) {
		list.add(o);
		return o;
	}

	/**
	 * pops the object from this stack,
	 * the popped object is removed from this stack.
	 * <p>֥Ȥݥåפ.
	 * ݥåפ줿֥ȤϺ.
	 * 
	 * @return  the popped object
	 */
	public E pop() {
		if(list.size() <= 0) {
			throw new EmptyStackException();
		}
		return list.remove(list.size() - 1);
	}

	/**
	 * gets the top object of this stack,
	 * the object is not removed from this.
	 * <p>åƬˤ륪֥Ȥ.
	 * 
	 * @return  the top object of this stack
	 */
	public E peek() {
		if(list.size() <= 0) {
			throw new EmptyStackException();
		}
		return list.get(list.size() - 1);
	}

	/**
	 * returns true if this stack is empty.
	 * <p>åΤȤtrue.
	 */
	public boolean isEmpty() {
		return (list.size() <= 0);
	}

	/**
	 * pops n objects from this stack and removes the objects
	 * from this stack.
	 * <p>ånĤΥ֥Ȥݥåפ.
	 * 
	 * @param n
	 */
	public void pop(int n) {
		if(list.size() < n) {
			throw new IndexOutOfBoundsException();
		}
		
		for(; n > 0; n--) {
			pop();
		}
	}

	/**
	 * returns the size of this stack.
	 * <p>֤.
	 * 
	 * @return  the size of this stack
	 */
	public int size() {
		return list.size();
	}

	/**
	 * clears all elements in this stack.
	 * <p>åˤǤ򥯥ꥢ.
	 */
	public void clear() {
		list.clear();
	}

	/**
	 * returns true if the given object is in this stack.
	 * <p>Ϳ줿֥ȤåˤȤtrue.
	 * 
	 * @param o  the object
	 * @return  true if the given object is in this stack
	 */
	public boolean contains(E o) {
		return list.contains(o);
	}

	/**
	 * gets the object which was pushed.
	 * <p>n+1ܤ˥ץå夷֥Ȥ.
	 * 
	 * @return  the distance from the top of this stack
	 */
	public E get(int n) {
		if(list.size() <= n) {
			throw new IndexOutOfBoundsException();
		}
		return list.get(n);
	}
	
	
	public List<E> toList() {
		return Collections.unmodifiableList(list);
	}
	
	
	public boolean add(E o) {
		return list.add(o);
	}
	
	
	public void addAll(Stack2<E> s) {
		list.addAll(s.toList());
	}
	
	/**
	 * returns the string representation.
	 * <p>Υ֥Ȥʸɽ.
	 * 
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		Iterator<E> itr = list.iterator();
		StringBuffer buf = new StringBuffer();
		
		while(itr.hasNext()) {
			buf.append(itr.next()).append(" ");
		}
		return buf.toString();
	}

}
