/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.subr;

import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;

public class NumGreaterThanEq extends NumCompare {

	@Override
	protected boolean compare(
			LispNumber c1a, LispNumber c2a, LispMessage mesg) {
		if((c1a instanceof LispReal) && (c2a instanceof LispReal)) {
			LispReal r1 = (LispReal)c1a;
			LispReal r2 = (LispReal)c2a;
			
			return !(r1.isNaN() || r2.isNaN()) && !r1.isLessThan(r2);
		} else {
			//throw new LispException("real number required");
			throw mesg.getError("err.require.real", c2a);
		}
	}
	
	
	public String toString() {
		return "Subr:>=";
	}
	
}
