/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

/**
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2005/08/06
 */
public final class IntInclimentor implements Inclimentor<Integer> {
	
	//
	private int index;
	
	/**
	 * 
	 *
	 */
	public IntInclimentor() {
		index = 0;
	}
	
	/**
	 * 
	 * @param i
	 */
	public IntInclimentor(int i) {
		index = i;
	}

	/* (non-Javadoc)
	 * @see org.usei.math.Inclimental#isZero()
	 */
	public boolean isZero() {
		return index == 0;
	}

	/* (non-Javadoc)
	 * @see org.usei.math.Inclimental#suc()
	 */
	public Inclimentor<Integer> suc() {
		index++;
		return this;
	}

	/* (non-Javadoc)
	 * @see org.usei.math.Inclimental#suc(int)
	 */
	public Inclimentor<Integer> suc(int step) {
		index += step;
		return this;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	public boolean equals(Object o) {
		if(o instanceof IntInclimentor) {
			return index == ((IntInclimentor)o).index;
		}
		return false;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return index;
	}

	public boolean equalIncliment(Inclimentor<?> i) {
		return index == ((Inclimentor<?>)i).toInt();
	}

	public boolean equalInt(int i) {
		return index == i;
	}

	public int toInt() {
		return index;
	}

	public Integer getObject() {
		return new Integer(index);
	}

}
