/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.util;

/**
 * <i>USEful Implements</i> for Object.hashCode().
 * <p>ϥå女ɴϢʴؿǤ.
 * 
 * <p>Ū褤ϥå女ɤ뵬§ȤưʲΤ褦ˡ
 * (: Joshua Bloch. The Effective Java).ˡܥɥȤǤ
 * &quot; EJˡ(EJ method) &quot; ȵҤ.
 * 
 * <ol>
 * <li>ѿrr˥ϥå女ɤν{@link #INIT}
 * .
 * <li>֥Ȥ̤롢Ĥޤequals᥽åɤˤɾ
 * եfˤĤƼν򤹤.
 * 
 * <ol>
 * <li>եɤhashCode(ͤhȤ).
 * ᥽åɤϰʲ̤Ǥ.
 * <table>
 * <tr><th>fη  </th><th>hashCodeˡ</th></tr>
 * <tr><td>byte, short, char, int</td><td>fͤΤ</td></tr>
 * <tr><td>long   </td><td>{@link #hashCode(long)}  </td></tr>
 * <tr><td>float  </td><td>{@link #hashCode(float)} </td></tr>
 * <tr><td>double </td><td>{@link #hashCode(double)}</td></tr>
 * <tr><td>boolean</td><td>{@link #hashCode(double)}</td></tr>
 * <tr><td>Object </td><td>Object.hashCode()</td></tr>
 * <tr><td>   </td>
 * <td>sumHashCode᥽åɷ<br/>
 *     {@link #sumHashCode(boolean[])}<br/>
 *     {@link #sumHashCode(byte[])}<br/>
 *     {@link #sumHashCode(short[])}<br/>
 *     {@link #sumHashCode(char[])}<br/>
 *     {@link #sumHashCode(int[])}<br/>
 *     {@link #sumHashCode(long[])}<br/>
 *     {@link #sumHashCode(float[])}<br/>
 *     {@link #sumHashCode(double[])}<br/>
 *     {@link #sumHashCode(boolean[])}<br/>
 *     {@link #sumHashCode(Object[])}<br/>
 * </td></tr>
 * </table>
 * <li>{@link #A}*h + r׻r.
 * </ol>
 * </ol>
 * 
 * @author MORIGUCHI, Yuichiro 2005/04/09
 */
public final class Hashes {
	
	/**
	 *  A initial hash code for the EJ method.
	 * <p>EJˡˤϥå女ɤνͤǤ.
	 */
	public static final int INIT = 17;
	
	/**
	 *  A multiplication coefficient for the EJ method.
	 * <p>EJˡˤϥå女ɤξǤ.
	 */
	public static final int A = 37;
	
	/**
	 * calculates the hash code of the given argument.
	 * <p>бhashCode֤.
	 * 
	 * @param b the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(boolean b) {
		return b ? 0 : 1;
	}
	
	/**
	 * calculates the hash code of the given argument.
	 * <p>бhashCode֤.
	 * 
	 * @param l the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(long l) {
		return (int)(l ^ (l >>> 32));
	}
	
	/**
	 * calculates the hash code of the given argument.
	 * <p>бhashCode֤.
	 * 
	 * @param d the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(double d) {
		long l;
		l = Double.doubleToLongBits(d);
		return (int)(l ^ (l >>> 32));
	}
	
	/**
	 * calculates the hash code of the given argument.
	 * <p>бhashCode֤.
	 * 
	 * @param f the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(float f) {
		return Float.floatToIntBits(f);
	}
	
	/**
	 * calculates the hash code of the given argument.
	 * <p>бhashCode֤.
	 * 
	 * @param o the value to be calculated
	 * @return  the hash code
	 */
	public static int hashCode(Object o) {
		return (o == null) ? 0 : o.hashCode();
	}
	
	
	/**
	 * calculates the hash code of the given array.
	 * <p>бhashCode֤.
	 * 
	 * @param arr the array to be calculated
	 * @return    the hash code
	 */
	public static int sumHashCode(int[] arr) {
		if(arr == null) {
			return 0;
		}
		
		int res = 0;
		for(int i = 0; i < arr.length; i++) {
			res = A * res + arr[i];
		}
		return res;
	}
	
	/**
	 * calculates the hash code of the given array.
	 * <p>бhashCode֤.
	 * 
	 * @param arr the array to be calculated
	 * @return    the hash code
	 */
	public static int sumHashCode(boolean[] arr) {
		if(arr == null) {
			return 0;
		}
		
		int res = 0;
		for(int i = 0; i < arr.length; i++) {
			res = A * res + hashCode(arr[i]);
		}
		return res;
	}
	
	/**
	 * calculates the hash code of the given array.
	 * <p>бhashCode֤.
	 * 
	 * @param arr the array to be calculated
	 * @return    the hash code
	 */
	public static int sumHashCode(byte[] arr) {
		if(arr == null) {
			return 0;
		}
		
		int res = 0;
		for(int i = 0; i < arr.length; i++) {
			res = A * res + arr[i];
		}
		return res;
	}
	
	/**
	 * calculates the hash code of the given array.
	 * <p>бhashCode֤.
	 * 
	 * @param arr the array to be calculated
	 * @return    the hash code
	 */
	public static int sumHashCode(short[] arr) {
		if(arr == null) {
			return 0;
		}
		
		int res = 0;
		for(int i = 0; i < arr.length; i++) {
			res = A * res + arr[i];
		}
		return res;
	}
	
	/**
	 * calculates the hash code of the given array.
	 * <p>бhashCode֤.
	 * 
	 * @param arr the array to be calculated
	 * @return    the hash code
	 */
	public static int sumHashCode(char[] arr) {
		if(arr == null) {
			return 0;
		}
		
		int res = 0;
		for(int i = 0; i < arr.length; i++) {
			res = A * res + arr[i];
		}
		return res;
	}
	
	/**
	 * calculates the hash code of the given array.
	 * <p>бhashCode֤.
	 * 
	 * @param arr the array to be calculated
	 * @return    the hash code
	 */
	public static int sumHashCode(long[] arr) {
		if(arr == null) {
			return 0;
		}
		
		int res = 0;
		for(int i = 0; i < arr.length; i++) {
			res = A * res + hashCode(arr[i]);
		}
		return res;
	}
	
	/**
	 * calculates the hash code of the given array.
	 * <p>бhashCode֤.
	 * 
	 * @param arr the array to be calculated
	 * @return    the hash code
	 */
	public static int sumHashCode(float[] arr) {
		if(arr == null) {
			return 0;
		}
		
		int res = 0;
		for(int i = 0; i < arr.length; i++) {
			res = A * res + hashCode(arr[i]);
		}
		return res;
	}
	
	/**
	 * calculates the hash code of the given array.
	 * <p>бhashCode֤.
	 * 
	 * @param arr the array to be calculated
	 * @return    the hash code
	 */
	public static int sumHashCode(double[] arr) {
		if(arr == null) {
			return 0;
		}
		
		int res = 0;
		for(int i = 0; i < arr.length; i++) {
			res = A * res + hashCode(arr[i]);
		}
		return res;
	}
	
	/**
	 * calculates the hash code of the given array.
	 * <p>бhashCode֤.
	 * 
	 * @param arr the array to be calculated
	 * @return    the hash code
	 */
	public static int sumHashCode(Object[] arr) {
		if(arr == null) {
			return 0;
		}
		
		int res = 0;
		for(int i = 0; i < arr.length; i++) {
			res = A * res + hashCode(arr[i]);
		}
		return res;
	}

}
