/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.List;

/*package*/ abstract class LispCompiler {
	
	
	public abstract void compileArgs(
			Datum bcdr,
			Environment env,
			CompiledCode.Builder builder,
			Cons callsym,
			List<Cons> symlist);
	
	
	public abstract void compile(
			Datum body,
			Environment env,
			CompiledCode.Builder builder,
			boolean toplevel,
			Cons callsym,
			boolean istail,
			List<Cons> symlist);
	
	
	public void compile(
			Datum body,
			Environment env,
			CompiledCode.Builder builder,
			Cons callsym,
			boolean istail,
			List<Cons> symlist) {
		compile(body, env, builder, false, callsym, istail, symlist);
	}
	
	
	public abstract Datum replaceLocalValsArgs(
			Datum bcdr,
			Environment env,
			Environment ienv);
	
	
	// ienvϥޥˤѿδĶ
	// Υ᥽åɤbody˲Ū˽񤭴Τ
	public abstract Datum replaceLocalVals(
			Datum body,
			Environment env,
			Environment ienv, boolean toplv);
	
	
	public abstract Datum expandMacro1(
			Datum body,
			Environment env,
			CodeExecutor exec,
			IntStack memento);
	
	
	public abstract Datum expandMacro(
			Datum body,
			Environment env,
			CodeExecutor exec,
			IntStack memento);
	
}
