/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import net.morilib.lisp.subr.Car;

public class ExSubrStreamCar extends Subr {

	@Override
	public Datum eval(Datum body, Environment env, LispMessage mesg) {
		throw new RuntimeException();
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Subr#getClosureClass(net.morilib.lisp.Environment)
	 */
	@Override
	/*package*/ ClosureClass createClosureClass(Environment env) {
		CompiledCode.Builder bld = new CompiledCode.Builder();
		ClosureClass cl1 = new ClosureClass();
		Symbol stream = Symbol.getSymbol("stream");
		
		bld.addPush(new Car());
		bld.addBeginList();
		bld.addReferSymbol(stream);
		bld.addAppendList();
		bld.addEndList();
		bld.addCall();
		//bld.addForce();
		bld.addReturnOp();
		
		cl1.setParameterList(new Cons(stream, Nil.NIL));
		cl1.setCode(bld.getCodeRef());
		
		return cl1;
	}

}
