/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public abstract class Datum {
	
	
	public boolean isEqv(Datum a) {
		return equals(a);
	}
	
	
	public boolean isTypeNumber() {
		return false;
	}
	
	
	public boolean isTypeString() {
		return false;
	}
	
	
	public boolean isTypeCharacter() {
		return false;
	}
	
	
	public boolean isTypePort() {
		return false;
	}
	
	
	public boolean isTypeBoolean() {
		return false;
	}
	
	
	public boolean isTypeSymbol() {
		return false;
	}
	
	
	public boolean isTypeList() {
		return false;
	}
	
	
	public boolean isTypeVector() {
		return false;
	}
	
	
	public boolean isTypeProcedure() {
		return false;
	}
	
	
	public boolean isNil() {
		return false;
	}
	
	
	public boolean isDottedList() {
		return false;
	}
	
	
	public int getInt() {
		throw new UnsupportedOperationException();
	}
	
	
	public long getLong() {
		throw new UnsupportedOperationException();
	}
	
	
	public BigInteger getBigInteger() {
		throw new UnsupportedOperationException();
	}
	
	
	public BigDecimal getBigDecimal() {
		throw new UnsupportedOperationException();
	}
	
	
	public LispReal getReal() {
		throw new UnsupportedOperationException();
	}
	
	
	public LispReal getImag() {
		throw new UnsupportedOperationException();
	}
	
	
	public double getRealDouble() {
		throw new UnsupportedOperationException();
	}
	
	
	public double getImagDouble() {
		throw new UnsupportedOperationException();
	}
	
	
	public String getString() {
		throw new UnsupportedOperationException();
	}
	
	
	public List<Datum> getList() {
		throw new UnsupportedOperationException();
	}
	
	
	public Datum getDottedDatum() {
		throw new UnsupportedOperationException();
	}
	
	
	public char getCharacter() {
		throw new UnsupportedOperationException();
	}
	
	
	public boolean isTrue() {
		return true;
	}
	
}
