Summary: A document formatting system.
Summary(ja): GNU groff ܸб
Name: groff
Version: 1.17.2
Release: 0vl4
License: GPL
Group: Applications/Publishing
Source0: ftp://prep.ai.mit.edu/pub/gnu/groff-%{version}.tar.gz
Source1: troff-to-ps.fpi
Source2: groff-tmac-ja.tar.gz
Patch1: groff-1.16-safer.patch
Patch2: groff-1.17.2-13.patch
Patch3: groff-1.17.2-sec.patch
Requires: mktemp
Obsoletes: groff-tools
Buildroot: %{_tmppath}/%{name}-root
Vendor: Project Vine
Distribution: Vine Linux

%description
Groff is a document formatting system.  Groff takes standard text and
formatting commands as input and produces formatted output.  The
created documents can be shown on a display or printed on a printer. 
Groff's formatting commands allow you to specify font type and size, bold
type, italic type, the number and size of columns on a page, and more.

You should install groff if you want to use it as a document formatting
system.  Groff can also be used to format man pages. If you are going
to use groff with the X Window System, you'll also need to install the
groff-gxditview package.

%description -l ja
GNU roff (groff) ܸбǤǤܸǽ񤫤줿ޥ˥奢ɽ
ΤɬפǤ. 

%package perl
Summary: Parts of the groff formatting system that require Perl.
Group: Applications/Publishing

%description perl
The groff-perl package contains the parts of the groff text processor
package that require Perl. These include the afmtodit font processor
for creating PostScript font files, the grog utility that can be used
to automatically determine groff command-line options, and the
troff-to-ps print filter.

%package gxditview
Summary: An X previewer for groff text processor output.
Group: Applications/Publishing

%description gxditview
Gxditview displays the groff text processor's output on an X Window
System display.

If you are going to use groff as a text processor, you should install
gxditview so that you preview your processed text files in X.  You'll also
need to install the groff package and the X Window System.

%prep
%setup -q -n groff-%{version}
%patch1 -p1 -b .safer
%patch2 -p1 -b .ja
%patch3 -p1 -b .security

%build
PATH=$PATH:/usr/X11R6/bin
#autoconf
%configure --enable-japanese
make

cd src/xditview
xmkmf
make
cd ../..

%install
[ "%{buildroot}" != "/" ] && rm -rf %{buildroot}
PATH=$PATH:/usr/X11R6/bin
mkdir -p %{buildroot}%{_prefix}
mkdir -p %{buildroot}%{_mandir}
%makeinstall manroot=%{buildroot}%{_mandir}

# install xditview
cd src/xditview
%makeinstall DESTDIR=$RPM_BUILD_ROOT INSTMANFLAGS="-m 0644" install.man
cd ../..

# for gorff-ja
tar xzf %{SOURCE2} -C %{buildroot}%{_datadir}/groff/%{version}

ln -s s.tmac	%{buildroot}%{_datadir}/groff/%{version}/tmac/tmac.gs
ln -s mse.tmac  %{buildroot}%{_datadir}/groff/%{version}/tmac/tmac.gmse
ln -s m.tmac	%{buildroot}%{_datadir}/groff/%{version}/tmac/tmac.gm
ln -s troff	%{buildroot}%{_bindir}/gtroff
ln -s tbl	%{buildroot}%{_bindir}/gtbl
ln -s pic	%{buildroot}%{_bindir}/gpic
ln -s eqn	%{buildroot}%{_bindir}/geqn
ln -s neqn	%{buildroot}%{_bindir}/gneqn
ln -s refer	%{buildroot}%{_bindir}/grefer
ln -s lookbib	%{buildroot}%{_bindir}/glookbib
ln -s indxbib	%{buildroot}%{_bindir}/gindxbib
ln -s soelim	%{buildroot}%{_bindir}/gsoelim
ln -s soelim    %{buildroot}%{_bindir}/zsoelim
ln -s nroff	%{buildroot}%{_bindir}/gnroff

# whether or not build system is compressing man-pages
ln -s eqn.1	%{buildroot}%{_mandir}/man1/geqn.1
ln -s indxbib.1 %{buildroot}%{_mandir}/man1/gindxbib.1
ln -s lookbib.1 %{buildroot}%{_mandir}/man1/glookbib.1
ln -s nroff.1 %{buildroot}%{_mandir}/man1/gnroff.1
ln -s pic.1 	%{buildroot}%{_mandir}/man1/gpic.1
ln -s refer.1 %{buildroot}%{_mandir}/man1/grefer.1
ln -s soelim.1 %{buildroot}%{_mandir}/man1/gsoelim.1
ln -s soelim.1 %{buildroot}%{_mandir}/man1/zsoelim.1
ln -s tbl.1 	%{buildroot}%{_mandir}/man1/gtbl.1
ln -s troff.1 %{buildroot}%{_mandir}/man1/gtroff.1

mkdir -p %{buildroot}%{_libdir}/rhs/rhs-printfilters
install -m755 %{_sourcedir}/troff-to-ps.fpi \
	%{buildroot}%{_libdir}/rhs/rhs-printfilters

find %{buildroot}%{_bindir} %{buildroot}%{_mandir} -type f -o -type l | \
	grep -v afmtodit | grep -v grog | grep -v mdoc.samples |\
	grep -v mmroff |\
	sed "s|%{buildroot}||g" | sed "s|\.[0-9]|\.*|g" > groff-files

%clean
[ "%{buildroot}" != "/" ] && rm -rf %{buildroot}

%files -f groff-files
%defattr(-,root,root)
%doc BUG-REPORT COPYING ChangeLog NEWS PROBLEMS README TODO
# %doc README.jp ChangeLog.jp
%{_datadir}/groff
%{_libdir}/rhs/*/*

%files perl
%defattr(-,root,root)
%{_prefix}/bin/grog
%{_prefix}/bin/mmroff
%{_prefix}/bin/afmtodit
%{_mandir}/man1/afmtodit.*
%{_mandir}/man1/grog.*
%{_mandir}/man7/mmroff*

%files gxditview
%defattr(-,root,root)
/usr/X11R6/bin/gxditview
%config /usr/X11R6/lib/X11/app-defaults/GXditview
/usr/X11R6/man/man1/gxditview.*

%changelog
* Wed Mar 06 2002 Toru Sagami <sagami@vinelinux.org> 1.17.2-0vl4
- corrected zsoelim.1 symlink in %%{_mandir}

* Mon Feb 11 2002 Satoshi MACHINO <machino@vinelinux.org> 1.17.2-0vl3
- fixed symlink of *.tmac

* Mon Jan 21 2002 Satoshi MACHINO <machino@vinelinux.org> 1.17.2-0vl2
- build on VineSeed

* Mon Jan 21 2002 Satoshi MACHINO <machino@vinelinux.org> 1.17.2-0vl1
- updated groff-1.17.2
    -- security fixed of CAN-2002-0003
    -- changed japanese patch to debian patch
    -- modified spec file

* Mon Sep 10 2001 Toru Sagami <sagami@vinelinux.org>
- 1.16.1-0vl1: split perl components into separate subpackage

* Tue Jul 17 2001 <sagami@vinelinux.org>
- 1.16.1: version up to 1.16.1
- add groff-1.16.1-japanese.patch originally taken from Kondara
- use %%configure after autoconf, %%makeinstall

* Tue Jan 23 2001 Toru Sagami <czs14350@mb.infoweb.ne.jp>
- 1.15_jp-7
- built on egcs-1.1/libstdc++2_9-2.9.0
- fixed: whether or not build system compress man pages

* Tue Dec 26 2000 Tomoya TAKA <tomoya@olive.plala.or.jp> 1.15_jp-6
- some fixes to handle man pages correctly

* Sat Nov 11 2000 MACHINO, Satoshi <machino@vinelinux.org> 1.15_jp-5
- build on gcc-2.95.3
- partially used macros

* Mon Aug  7 2000 Jun Nishii <jun@vinelinux.org>
- 1.15_jp-4
- follow up to RHL62 (1.15-8)

* Thu Feb 24 2000 MATSUBAYASHI 'Shaolin' Kohji <shaolin@rhythmaning.org>
- 1.15_jp-3
- modified ja patch, namely lib.h

* Sun Jan  9 2000 Jun Nishii <jun@vinelinux.org>
- groff-tmac-ja was lacked in Source entry(;_;) fixed!

* Tue Jan  4 2000 Jun Nishii <jun@vinelinux.org>
- build for Vine Linux 2.0 with ja patch

* Wed Dec 29 1999 Bill Nottingham <notting@redhat.com>
- update to 1.15

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 9)

* Tue Feb 16 1999 Cristian Gafton <gafton@redhat.com>
- glibc 2.1 patch for xditview (#992)

* Thu Oct 22 1998 Bill Nottingham <notting@redhat.com>
- build for Raw Hide

* Thu Sep 10 1998 Cristian Gafton <gafton@redhat.com>
- fix makefiles to work with bash2

* Fri May 08 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Thu Apr 30 1998 Cristian Gafton <gafton@redhat.com>
- use g++ for C++ code

* Wed Apr 08 1998 Cristian Gafton <gafton@redhat.com>
- manhattan and buildroot

* Mon Nov  3 1997 Michael Fulbright <msf@redhat.com>
- made xdefaults file a config file

* Thu Oct 23 1997 Erik Troan <ewt@redhat.com>
- split perl components into separate subpackage

* Tue Oct 21 1997 Michael Fulbright <msf@redhat.com>
- updated to 1.11a
- added safe troff-to-ps.fpi

* Tue Oct 14 1997 Michael Fulbright <msf@redhat.com>
- removed troff-to-ps.fpi for security reasons.

* Fri Jun 13 1997 Erik Troan <ewt@redhat.com>
- built against glibc

