# Slackware Add-on Package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#   2002.07.06
#
# Package: 
#   XFree86-truetype.1.0-noarch-1.tgz
#
# Files:
#   http://www.on.cs.keio.ac.jp/~yasu/linux/fonts/kochi-mincho-0.2.20020326.tar.bz2
#   http://www.on.cs.keio.ac.jp/~yasu/linux/fonts/kochi-gothic-0.2.20020326.tar.bz2
#
# Patches:
#   None.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
#!/bin/sh
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=XFree86-truetype
VERSION=1.0
PKGROOT=`pwd`
bunzip2 kochi-mincho-0.2.20020326.tar.bz2
tar -xvf kochi-mincho-0.2.20020326.tar
bunzip2 kochi-gothic-0.2.20020326.tar.bz2
tar -xvf kochi-gothic-0.2.20020326.tar

#make

#makepkg
echo 'Creating package now ...'
if [ ! -d ${PKGROOT}/${PACKAGE}-${VERSION}-root ]; then
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/lib/X11/fonts/truetype
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-mincho
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-gothic
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
fi
mv ${PKGROOT}/kochi-mincho/fonts/kochi-mincho.ttf ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/lib/X11/fonts/truetype
mv ${PKGROOT}/kochi-gothic/fonts/kochi-gothic.ttf ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/lib/X11/fonts/truetype
if [ ! -f /usr/X11R6/lib/X11/fonts/truetype/fonts.dir ]; then
  cp ${PKGROOT}/fonts.dir ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/lib/X11/fonts/truetype
fi
if [ ! -f /usr/X11R6/lib/X11/fonts/truetype/fonts.alias ]; then
  cp ${PKGROOT}/fonts.alias ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/X11R6/lib/X11/fonts/truetype
fi
cp ${PKGROOT}/kochi-mincho/AUTHORS ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-mincho
cp ${PKGROOT}/kochi-mincho/Changelog ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-mincho
cp ${PKGROOT}/kochi-mincho/INSTALL ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-mincho
cp ${PKGROOT}/kochi-mincho/README ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-mincho
cp ${PKGROOT}/kochi-mincho/THANKS ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-mincho
cp ${PKGROOT}/kochi-mincho/TODO ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-mincho
cp -R ${PKGROOT}/kochi-mincho/docs ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-mincho
cp -R ${PKGROOT}/kochi-mincho/examples ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-mincho
cp ${PKGROOT}/kochi-gothic/AUTHORS ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-gothic
cp ${PKGROOT}/kochi-gothic/Changelog ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-gothic
cp ${PKGROOT}/kochi-gothic/INSTALL ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-gothic
cp ${PKGROOT}/kochi-gothic/README ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-gothic
cp ${PKGROOT}/kochi-gothic/THANKS ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-gothic
cp ${PKGROOT}/kochi-gothic/TODO ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-gothic
cp -R ${PKGROOT}/kochi-gothic/docs ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-gothic
cp -R ${PKGROOT}/kochi-gothic/examples ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}/kochi-gothic
cp ${PKGROOT}/doinst.sh  ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-noarch-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-noarch-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

