#!/bin/sh
#
# Slackware Add-on package Project
# <http://www.asahi-net.or.jp/~wp7s-mrn/>
#
# Date:
#  2002.11.02
#
# Package: 
#  Mixer.app-1.4.0-i386-1.tgz
#
# Files:
#   
#  http://www.cs.mun.ca/~gstarkes/wmaker/dockapps/files/Mixer.app-1.4.0.tar.gz
#
# Patches:
#   None.
#
# Author:
#   Shinji Morino <peace24@blue.email.ne.jp>
#
PATH=$PATH:/usr/X11R6/bin
PACKAGE=Mixer.app
VERSION=1.4.0
PKGROOT=`pwd`
tar -zxvf ${PACKAGE}-${VERSION}.tar.gz
cd ${PACKAGE}-${VERSION}

#Change Imakefile
cat Imakefile | sed 's/GNUstep\/Apps\/Mixer.app/bin/g' > Imakefile.tmp
mv Imakefile.tmp Imakefile

#make
xmkmf
make
make install

#makepkg
cd ..
echo 'Creating package now ...'
if [ ! -d ${PKGROOT}/${PACKAGE}-${VERSION}-root ]; then
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/bin
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
  mkdir -p ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
fi
mv /usr/local/bin/Mixer    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/local/bin
cp ./${PACKAGE}-${VERSION}/COPYING    ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./${PACKAGE}-${VERSION}/ChangeLog ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./${PACKAGE}-${VERSION}/INSTALL ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ./${PACKAGE}-${VERSION}/README  ${PKGROOT}/${PACKAGE}-${VERSION}-root/usr/share/doc/${PACKAGE}-${VERSION}
cp ${PKGROOT}/doinst.sh  ${PKGROOT}/${PACKAGE}-${VERSION}-root/install
cd ${PKGROOT}/${PACKAGE}-${VERSION}-root
yes | makepkg ${PACKAGE}-${VERSION}-i386-1.tgz
mv ${PKGROOT}/${PACKAGE}-${VERSION}-root/${PACKAGE}-${VERSION}-i386-1.tgz ${PKGROOT}

#remove temporary files
rm -R ${PKGROOT}/${PACKAGE}-${VERSION}-root

