/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex.style;

import java.util.Hashtable;
import writer2latex.latex.Context;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.style.BeforeAfter;
import writer2latex.latex.style.StyleConverter;
import writer2latex.latex.style.StyleMap;
import writer2latex.office.FontDeclaration;
import writer2latex.office.StyleWithProperties;
import writer2latex.office.WriterStyleCollection;
import writer2latex.util.Config;
import writer2latex.util.Misc;

public class CharStyleConverter
extends StyleConverter {
    private Hashtable fontDecls = new Hashtable();
    private boolean bUseColor;
    private boolean bIgnoreHardFontsize;
    private boolean bIgnoreFontsize;
    private boolean bIgnoreFont;
    private boolean bIgnoreAll;
    private boolean bUseUlem;
    private boolean bNeedUlem = false;
    private boolean bNeedSubscript = false;

    public CharStyleConverter(WriterStyleCollection writerStyleCollection, Config config, ConverterPalette converterPalette) {
        super(writerStyleCollection, config, converterPalette);
        this.bUseColor = config.useColor();
        this.bUseUlem = config.useUlem();
        this.bIgnoreAll = config.formatting() == 0;
        this.bIgnoreFont = config.formatting() <= 1;
        this.bIgnoreFontsize = config.formatting() <= 2;
        this.bIgnoreHardFontsize = config.formatting() <= 3;
    }

    public void appendDeclarations(LaTeXDocumentPortion laTeXDocumentPortion, LaTeXDocumentPortion laTeXDocumentPortion2) {
        if (this.bUseColor) {
            laTeXDocumentPortion.append("\\usepackage{color}").nl();
        }
        if (this.bNeedUlem) {
            laTeXDocumentPortion.append("\\usepackage[normalem]{ulem}").nl();
        }
        if (this.bNeedSubscript) {
            laTeXDocumentPortion2.append("\\newcommand\\textsubscript[1]{\\ensuremath{{}_{\\text{#1}}}}").nl();
        }
        if (!this.styleNames.isEmpty()) {
            laTeXDocumentPortion2.append("% Text styles").nl().append(this.declarations);
        }
    }

    public void applyTextStyle(String string, BeforeAfter beforeAfter, Context context) {
        if (string == null || this.bIgnoreAll) {
            return;
        }
        if (this.styleMap.contains(string)) {
            beforeAfter.add(this.styleMap.getBefore(string), this.styleMap.getAfter(string));
            context.updateFormattingFromStyle(this.wsc.getTextStyle(string));
            StyleMap styleMap = this.config.getTextStyleMap();
            context.setVerbatim(styleMap.contains(string) && styleMap.getVerbatim(string));
            return;
        }
        StyleMap styleMap = this.config.getTextStyleMap();
        if (styleMap.contains(string)) {
            this.styleMap.put(string, styleMap.getBefore(string), styleMap.getAfter(string));
            this.applyTextStyle(string, beforeAfter, context);
            return;
        }
        StyleWithProperties styleWithProperties = this.wsc.getTextStyle(string);
        if (styleWithProperties == null) {
            this.styleMap.put(string, "", "");
            this.applyTextStyle(string, beforeAfter, context);
            return;
        }
        if (styleWithProperties.isAutomatic()) {
            this.palette.getI18n().applyLanguage(styleWithProperties, false, true, beforeAfter);
            this.applyFont(styleWithProperties, false, true, beforeAfter, context);
            this.applyFontEffects(styleWithProperties, true, beforeAfter);
            context.updateFormattingFromStyle(this.wsc.getTextStyle(string));
            return;
        }
        BeforeAfter beforeAfter2 = new BeforeAfter();
        this.palette.getI18n().applyLanguage(styleWithProperties, false, true, beforeAfter2);
        this.applyFont(styleWithProperties, false, true, beforeAfter2, new Context());
        this.applyFontEffects(styleWithProperties, true, beforeAfter2);
        String string2 = this.styleNames.getExportName(string);
        this.styleMap.put(string, "\\textstyle" + string2 + "{", "}");
        this.declarations.append("\\newcommand\\textstyle").append(string2).append("[1]{").append(beforeAfter2.getBefore()).append("#1").append(beforeAfter2.getAfter()).append("}").nl();
        this.applyTextStyle(string, beforeAfter, context);
    }

    public String getFontName(String string) {
        StyleWithProperties styleWithProperties = this.wsc.getTextStyle(string);
        if (styleWithProperties == null) {
            return null;
        }
        String string2 = styleWithProperties.getProperty("style:font-name");
        if (string2 == null) {
            return null;
        }
        FontDeclaration fontDeclaration = this.wsc.getFontDeclaration(string2);
        if (fontDeclaration == null) {
            return null;
        }
        return fontDeclaration.getProperty("fo:font-family");
    }

    public void applyHardCharFormatting(StyleWithProperties styleWithProperties, BeforeAfter beforeAfter) {
        this.palette.getI18n().applyLanguage(styleWithProperties, true, false, beforeAfter);
        this.applyFont(styleWithProperties, true, false, beforeAfter, new Context());
        if (!beforeAfter.isEmpty()) {
            beforeAfter.add(" ", "");
        }
    }

    public void applyFont(StyleWithProperties styleWithProperties, boolean bl, boolean bl2, BeforeAfter beforeAfter, Context context) {
        if (styleWithProperties == null) {
            return;
        }
        this.applyNfssSize(styleWithProperties, bl, bl2, beforeAfter, context);
        this.applyNfssFamily(styleWithProperties, bl, bl2, beforeAfter, context);
        this.applyNfssSeries(styleWithProperties, bl, bl2, beforeAfter, context);
        this.applyNfssShape(styleWithProperties, bl, bl2, beforeAfter, context);
        this.applyColor(styleWithProperties, bl, bl2, beforeAfter, context);
    }

    public void applyNormalFont(BeforeAfter beforeAfter) {
        if (this.bUseColor) {
            beforeAfter.add("\\normalfont\\normalsize\\normalcolor", "");
        } else {
            beforeAfter.add("\\normalfont\\normalsize", "");
        }
    }

    public void applyDefaultFont(StyleWithProperties styleWithProperties, LaTeXDocumentPortion laTeXDocumentPortion) {
        if (styleWithProperties == null) {
            return;
        }
        String string = this.convertFontDeclaration(styleWithProperties.getProperty("style:font-name"));
        if (string != null) {
            laTeXDocumentPortion.append("\\renewcommand\\familydefault{\\").append(string).append("default}").nl();
        }
        if ((string = CharStyleConverter.nfssSeries(styleWithProperties.getProperty("fo:font-weight"))) != null) {
            laTeXDocumentPortion.append("\\renewcommand\\seriesdefault{\\").append(string).append("default}").nl();
        }
        if ((string = CharStyleConverter.nfssShape(styleWithProperties.getProperty("fo:font-variant"), styleWithProperties.getProperty("fo:font-style"))) != null) {
            laTeXDocumentPortion.append("\\renewcommand\\shapedefault{\\").append(string).append("default}").nl();
        }
        if (this.bUseColor && (string = CharStyleConverter.color(styleWithProperties.getProperty("fo:color"))) != null) {
            laTeXDocumentPortion.append("\\renewcommand\\normalcolor{\\color").append(string).append("}").nl();
        }
    }

    public void applyFontEffects(StyleWithProperties styleWithProperties, boolean bl, BeforeAfter beforeAfter) {
        if (styleWithProperties == null) {
            return;
        }
        this.applyTextPosition(styleWithProperties, bl, beforeAfter);
        this.applyUnderline(styleWithProperties, bl, beforeAfter);
        this.applyCrossout(styleWithProperties, bl, beforeAfter);
        this.applyChangeCase(styleWithProperties, bl, beforeAfter);
    }

    public void applyColor(StyleWithProperties styleWithProperties, boolean bl, boolean bl2, BeforeAfter beforeAfter, Context context) {
        if (styleWithProperties == null || !this.bUseColor || this.bIgnoreAll) {
            return;
        }
        String string = CharStyleConverter.color(styleWithProperties.getProperty("fo:color", bl2));
        if (string == null) {
            return;
        }
        if (string.equals(CharStyleConverter.color(context.getFontColor()))) {
            return;
        }
        if (bl) {
            beforeAfter.add("\\color" + string, "");
        } else {
            beforeAfter.add("\\textcolor" + string + "{", "}");
        }
    }

    public void applyThisColor(String string, boolean bl, BeforeAfter beforeAfter) {
        if (string == null || !this.bUseColor || this.bIgnoreAll) {
            return;
        }
        String string2 = CharStyleConverter.color(string);
        if (string2 == null) {
            return;
        }
        if (bl) {
            beforeAfter.add("\\color" + string2, "");
        } else {
            beforeAfter.add("\\textcolor" + string2 + "{", "}");
        }
    }

    private void applyNfssFamily(StyleWithProperties styleWithProperties, boolean bl, boolean bl2, BeforeAfter beforeAfter, Context context) {
        if (styleWithProperties == null || this.bIgnoreFont) {
            return;
        }
        String string = styleWithProperties.getProperty("style:font-name", bl2);
        if (string != null) {
            String string2 = this.convertFontDeclaration(string);
            if (string2 == null) {
                return;
            }
            if (string2.equals(this.convertFontDeclaration(context.getFontName()))) {
                return;
            }
            if (bl) {
                beforeAfter.add("\\" + string2 + "family", "");
            } else {
                beforeAfter.add("\\text" + string2 + "{", "}");
            }
        }
    }

    private void applyNfssSeries(StyleWithProperties styleWithProperties, boolean bl, boolean bl2, BeforeAfter beforeAfter, Context context) {
        if (styleWithProperties == null) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String string = CharStyleConverter.nfssSeries(styleWithProperties.getProperty("fo:font-weight", bl2));
        if (string == null) {
            return;
        }
        if (string.equals(CharStyleConverter.nfssSeries(context.getFontWeight()))) {
            return;
        }
        if (bl) {
            beforeAfter.add("\\" + string + "series", "");
        } else {
            beforeAfter.add("\\text" + string + "{", "}");
        }
    }

    private void applyNfssShape(StyleWithProperties styleWithProperties, boolean bl, boolean bl2, BeforeAfter beforeAfter, Context context) {
        if (styleWithProperties == null) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String string = CharStyleConverter.nfssShape(styleWithProperties.getProperty("fo:font-variant", bl2), styleWithProperties.getProperty("fo:font-style", bl2));
        if (string == null) {
            return;
        }
        if (string.equals(CharStyleConverter.nfssShape(context.getFontVariant(), context.getFontStyle()))) {
            return;
        }
        if (bl) {
            beforeAfter.add("\\" + string + "shape", "");
        } else {
            beforeAfter.add("\\text" + string + "{", "}");
        }
    }

    private void applyNfssSize(StyleWithProperties styleWithProperties, boolean bl, boolean bl2, BeforeAfter beforeAfter, Context context) {
        if (styleWithProperties == null || this.bIgnoreFontsize || this.bIgnoreHardFontsize && styleWithProperties.isAutomatic()) {
            return;
        }
        if (styleWithProperties.getProperty("fo:font-size", bl2) == null) {
            return;
        }
        String string = CharStyleConverter.nfssSize(styleWithProperties.getAbsoluteProperty("fo:font-size"));
        if (string == null) {
            return;
        }
        if (string.equals(CharStyleConverter.nfssSize(context.getFontSize()))) {
            return;
        }
        if (bl) {
            beforeAfter.add(string, "");
        } else {
            beforeAfter.add("{" + string + " ", "}");
        }
    }

    private void applyTextPosition(StyleWithProperties styleWithProperties, boolean bl, BeforeAfter beforeAfter) {
        if (styleWithProperties == null) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String string = this.textPosition(styleWithProperties.getProperty("style:text-position", bl));
        if (string != null) {
            beforeAfter.add(string + "{", "}");
        }
    }

    private void applyUnderline(StyleWithProperties styleWithProperties, boolean bl, BeforeAfter beforeAfter) {
        if (styleWithProperties == null || !this.bUseUlem) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String string = CharStyleConverter.underline(styleWithProperties.getProperty("style:text-underline", bl));
        if (string != null) {
            this.bNeedUlem = true;
            beforeAfter.add(string + "{", "}");
        }
    }

    private void applyCrossout(StyleWithProperties styleWithProperties, boolean bl, BeforeAfter beforeAfter) {
        if (styleWithProperties == null || !this.bUseUlem) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String string = CharStyleConverter.crossout(styleWithProperties.getProperty("style:text-crossing-out", bl));
        if (string != null) {
            this.bNeedUlem = true;
            beforeAfter.add(string + "{", "}");
        }
    }

    private void applyChangeCase(StyleWithProperties styleWithProperties, boolean bl, BeforeAfter beforeAfter) {
        if (styleWithProperties == null) {
            return;
        }
        if (this.bIgnoreAll) {
            return;
        }
        String string = CharStyleConverter.changeCase(styleWithProperties.getProperty("fo:text-transform"));
        if (string != null) {
            beforeAfter.add(string + "{", "}");
        }
    }

    private String convertFontDeclaration(String string) {
        FontDeclaration fontDeclaration = this.wsc.getFontDeclaration(string);
        if (fontDeclaration == null) {
            return null;
        }
        if (!this.fontDecls.containsKey(string)) {
            String string2 = fontDeclaration.getProperty("fo:font-family");
            String string3 = fontDeclaration.getProperty("style:font-pitch");
            String string4 = fontDeclaration.getProperty("style:font-family-generic");
            this.fontDecls.put(string, CharStyleConverter.nfssFamily(string2, string4, string3));
        }
        return (String)this.fontDecls.get(string);
    }

    private static final String nfssFamily(String string, String string2, String string3) {
        if ("fixed".equals(string3)) {
            return "tt";
        }
        if ("modern".equals(string2)) {
            return "tt";
        }
        if ("swiss".equals(string2)) {
            return "sf";
        }
        return "rm";
    }

    private static final String nfssSeries(String string) {
        if (string == null) {
            return null;
        }
        if ("bold".equals(string)) {
            return "bf";
        }
        return "md";
    }

    private static final String nfssShape(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        if ("small-caps".equals(string)) {
            return "sc";
        }
        if ("italic".equals(string2)) {
            return "it";
        }
        if ("oblique".equals(string2)) {
            return "sl";
        }
        return "up";
    }

    private static final String nfssSize(String string) {
        if (string == null) {
            return null;
        }
        return "\\fontsize{" + string + "}{" + Misc.multiply("120%", string) + "}\\selectfont";
    }

    private static final String color(String string) {
        float f;
        float f2;
        if ("#000000".equalsIgnoreCase(string)) {
            return "{black}";
        }
        if ("#ff0000".equalsIgnoreCase(string)) {
            return "{red}";
        }
        if ("#00ff00".equalsIgnoreCase(string)) {
            return "{green}";
        }
        if ("#0000ff".equalsIgnoreCase(string)) {
            return "{blue}";
        }
        if ("#ffff00".equalsIgnoreCase(string)) {
            return "{yellow}";
        }
        if ("#ff00ff".equalsIgnoreCase(string)) {
            return "{magenta}";
        }
        if ("#00ffff".equalsIgnoreCase(string)) {
            return "{cyan}";
        }
        if (string == null || string.length() != 7) {
            return null;
        }
        float f3 = (float)Misc.getIntegerFromHex(string.substring(1, 3), 0) / 255.0f;
        if ((double)(f3 + (f2 = (float)Misc.getIntegerFromHex(string.substring(3, 5), 0) / 255.0f) + (f = (float)Misc.getIntegerFromHex(string.substring(5, 7), 0) / 255.0f)) > 2.7) {
            return "{black}";
        }
        return "[rgb]{" + f3 + "," + f2 + "," + f + "}";
    }

    private final String textPosition(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("super")) {
            return "\\textsuperscript";
        }
        if (string.startsWith("sub") || string.startsWith("-")) {
            this.bNeedSubscript = true;
            return "\\textsubscript";
        }
        if (string.startsWith("0%")) {
            return null;
        }
        return "\\textsuperscript";
    }

    private static final String underline(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("none")) {
            return null;
        }
        if (string.indexOf("wave") >= 0) {
            return "\\uwave";
        }
        return "\\uline";
    }

    private static final String crossout(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("X")) {
            return "\\xout";
        }
        if (string.equals("slash")) {
            return "\\xout";
        }
        return "\\sout";
    }

    private static final String changeCase(String string) {
        if ("lowercase".equals(string)) {
            return "\\MakeLowercase";
        }
        if ("uppercase".equals(string)) {
            return "\\MakeUppercase";
        }
        return null;
    }
}

