/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc.pexcel.records;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.converter.xml.sxc.SheetSettings;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BIFFRecord;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BeginningOfFile;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BlankCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.BoolErrCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.ColInfo;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefColWidth;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.DefRowHeight;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Eof;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.FloatNumber;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Formula;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.LabelCell;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.NumberFormat;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Pane;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Row;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Selection;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.StringValue;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Window2;
import org.openoffice.xmerge.converter.xml.sxc.pexcel.records.Workbook;
import org.openoffice.xmerge.util.Debug;

public class Worksheet {
    private String name;
    private Workbook wb;
    private Vector rows = new Vector();
    private Vector colInfo = new Vector();
    private Vector cells = new Vector();
    private DefColWidth dcw = new DefColWidth();
    private DefRowHeight drh = new DefRowHeight();
    private Window2 win2 = new Window2();
    private Selection sel = new Selection();
    private Pane p = new Pane();
    private BeginningOfFile bof;
    private Eof eof;

    public Worksheet(Workbook workbook) {
        this.wb = workbook;
    }

    public Worksheet() {
    }

    public void write(OutputStream outputStream) throws IOException {
        BIFFRecord bIFFRecord;
        this.bof = new BeginningOfFile(false);
        this.bof.write(outputStream);
        this.dcw.write(outputStream);
        Enumeration enumeration = this.colInfo.elements();
        while (enumeration.hasMoreElements()) {
            bIFFRecord = (ColInfo)enumeration.nextElement();
            ((ColInfo)bIFFRecord).write(outputStream);
        }
        this.drh.write(outputStream);
        enumeration = this.rows.elements();
        while (enumeration.hasMoreElements()) {
            bIFFRecord = (Row)enumeration.nextElement();
            ((Row)bIFFRecord).write(outputStream);
        }
        enumeration = this.cells.elements();
        while (enumeration.hasMoreElements()) {
            bIFFRecord = (BIFFRecord)enumeration.nextElement();
            bIFFRecord.write(outputStream);
        }
        this.win2.write(outputStream);
        this.p.write(outputStream);
        this.sel.write(outputStream);
        this.eof = new Eof();
        this.eof.write(outputStream);
    }

    public boolean read(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            return false;
        }
        while (n != -1) {
            switch (n) {
                case 1: {
                    Debug.log((int)4, (String)"Blank Cell (01h)");
                    BlankCell blankCell = new BlankCell(inputStream);
                    this.cells.add(blankCell);
                    break;
                }
                case 3: {
                    Debug.log((int)4, (String)"NUMBER: Cell Value, Floating-Point Number (03h)");
                    FloatNumber floatNumber = new FloatNumber(inputStream);
                    this.cells.add(floatNumber);
                    break;
                }
                case 4: {
                    Debug.log((int)4, (String)"LABEL: Cell Value, String Constant (04h)");
                    LabelCell labelCell = new LabelCell(inputStream);
                    this.cells.add(labelCell);
                    break;
                }
                case 5: {
                    Debug.log((int)4, (String)"BOOLERR: Cell Value, Boolean or Error (05h)");
                    BoolErrCell boolErrCell = new BoolErrCell(inputStream);
                    break;
                }
                case 6: {
                    Debug.log((int)4, (String)"FORMULA: Cell Formula (06h)");
                    Formula formula = new Formula(inputStream, this.wb);
                    this.cells.add(formula);
                    break;
                }
                case 7: {
                    Debug.log((int)4, (String)"String Value of a Formula (07h)");
                    StringValue stringValue = new StringValue(inputStream);
                    break;
                }
                case 8: {
                    Debug.log((int)4, (String)"ROW: Describes a Row (08h)");
                    Row row = new Row(inputStream);
                    this.rows.add(row);
                    break;
                }
                case 9: {
                    Debug.log((int)4, (String)"BOF Record");
                    this.bof = new BeginningOfFile(inputStream);
                    break;
                }
                case 10: {
                    Debug.log((int)4, (String)"EOF Marker");
                    this.eof = new Eof();
                    return true;
                }
                case 29: {
                    Debug.log((int)4, (String)"SELECTION: Current Selection (1Dh)");
                    this.sel = new Selection(inputStream);
                    break;
                }
                case 30: {
                    Debug.log((int)4, (String)"FORMAT: Number Format (1Eh)");
                    NumberFormat numberFormat = new NumberFormat(inputStream);
                    break;
                }
                case 37: {
                    Debug.log((int)4, (String)"DEFAULTROWHEIGHT: Default Row Height (25h)");
                    this.drh = new DefRowHeight(inputStream);
                    break;
                }
                case 62: {
                    Debug.log((int)4, (String)"WINDOW2: Sheet Window Information (3Eh) [PXL 2.0]");
                    this.win2 = new Window2(inputStream);
                    break;
                }
                case 65: {
                    Debug.log((int)4, (String)"PANE: Number of Panes and their Position (41h) [PXL 2.0]");
                    this.p = new Pane(inputStream);
                    break;
                }
                case 85: {
                    Debug.log((int)4, (String)"DEFCOLWIDTH: Default Column Width (55h) [PXL 2.0]");
                    this.dcw = new DefColWidth(inputStream);
                    break;
                }
                case 125: {
                    Debug.log((int)4, (String)"COLINFO: Column Formatting Information (7Dh) [PXL 2.0]");
                    ColInfo colInfo = new ColInfo(inputStream);
                    this.colInfo.add(colInfo);
                    break;
                }
            }
            n = inputStream.read();
        }
        Debug.log((int)4, (String)"Leaving Worksheet:");
        return true;
    }

    public Enumeration getCellEnumerator() throws IOException {
        return this.cells.elements();
    }

    public void addCell(BIFFRecord bIFFRecord) {
        this.cells.add(bIFFRecord);
    }

    public void addRow(Row row) {
        this.rows.add(row);
    }

    public void addCol(ColInfo colInfo) {
        this.colInfo.add(colInfo);
    }

    public void addSettings(SheetSettings sheetSettings) {
        this.sel.setActiveCell(sheetSettings.getCursor());
        this.p.setLeft(sheetSettings.getLeft());
        this.p.setTop(sheetSettings.getTop());
        this.p.setPaneNumber(sheetSettings.getPaneNumber());
        Point point = sheetSettings.getSplit();
        if (point.getX() != 0.0 || point.getY() != 0.0) {
            this.p.setSplitPoint(sheetSettings.getSplitType(), point);
            this.win2.setSplitType(sheetSettings.getSplitType());
        }
    }

    public Enumeration getColInfos() {
        return this.colInfo.elements();
    }

    public SheetSettings getSettings() {
        SheetSettings sheetSettings = new SheetSettings();
        sheetSettings.setCursor(this.sel.getActiveCell());
        if (this.win2.isFrozen()) {
            sheetSettings.setFreeze(this.p.getFreezePoint());
        } else if (this.win2.isSplit()) {
            sheetSettings.setSplit(this.p.getSplitPoint());
        }
        sheetSettings.setPaneNumber(this.p.getPaneNumber());
        sheetSettings.setTopLeft(this.p.getTop(), this.p.getLeft());
        return sheetSettings;
    }

    public Enumeration getRows() {
        return this.rows.elements();
    }
}

